/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.api.server;

import com.sun.istack.internal.NotNull;
import com.sun.xml.internal.ws.api.Component;
import com.sun.xml.internal.ws.api.ComponentEx;
import com.sun.xml.internal.ws.api.ComponentRegistry;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public abstract class Container
implements ComponentRegistry,
ComponentEx {
    private final Set<Component> components = new CopyOnWriteArraySet<Component>();
    public static final Container NONE = new NoneContainer();

    protected Container() {
    }

    @Override
    public <S> S getSPI(Class<S> clazz) {
        if (this.components == null) {
            return null;
        }
        for (Component component : this.components) {
            S s = component.getSPI(clazz);
            if (s == null) continue;
            return s;
        }
        return null;
    }

    @Override
    public Set<Component> getComponents() {
        return this.components;
    }

    @NotNull
    public <E> Iterable<E> getIterableSPI(Class<E> clazz) {
        E e = this.getSPI(clazz);
        if (e != null) {
            List<E> list = Collections.singletonList(e);
            return list;
        }
        return Collections.emptySet();
    }

    private static final class NoneContainer
    extends Container {
        private NoneContainer() {
        }
    }
}

