/*
 * Decompiled with CFR 0.152.
 */
package startanSubscribeWebSocket;

import com.tas.wp500.App;
import com.tas.wp500.services.Service;
import com.tas.wp500.webSocket.FcgiCommand;
import com.tas.wp500.webSocket.WebSocketMessageProcessor;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import startanSubscribeWebSocket.ChunkWebSocketClient;

public class StartanSubscribeWebExecutor
implements Runnable {
    private static Logger logger = Logger.getLogger(StartanSubscribeWebExecutor.class);
    private static final FcgiCommand fcgi = FcgiCommand.getInstance();
    private static final Map<String, JSONArray> jsonArrayMap = new ConcurrentHashMap<String, JSONArray>();
    private static final List<ChunkWebSocketClient> activeClients = new ArrayList<ChunkWebSocketClient>();
    private static final int MAX_RETRIES = 5;
    private static final long RETRY_INTERVAL = 5000L;

    @Override
    public void run() {
        int retryCount = 0;
        while (retryCount < 5) {
            try {
                JSONObject fcgiGetListResponse = fcgi.executeFCGIgetListCommand();
                if (fcgiGetListResponse.has("status") && fcgiGetListResponse.has("result")) {
                    if ("Success".equals(fcgiGetListResponse.getString("status"))) {
                        jsonArrayMap.clear();
                        JSONArray jsonArray = fcgiGetListResponse.getJSONArray("result");
                        jsonArrayMap.put("resultArray", jsonArray);
                        StartanSubscribeWebExecutor.retrieveAndProcessJSONArray();
                        break;
                    }
                    logger.debug("Status is Fail, retrying...");
                    ++retryCount;
                    TimeUnit.MILLISECONDS.sleep(5000L);
                    continue;
                }
                logger.info("Status or result not found in the response, retrying...");
                ++retryCount;
                TimeUnit.MILLISECONDS.sleep(5000L);
            }
            catch (Exception e) {
                logger.error("Error while executing startan webSocket: " + e.getMessage(), e);
                ++retryCount;
                try {
                    TimeUnit.MILLISECONDS.sleep(5000L);
                }
                catch (InterruptedException ie) {
                    logger.error("Interrupted during sleep: " + ie.getMessage(), ie);
                    Thread.currentThread().interrupt();
                }
            }
        }
        if (retryCount >= 5) {
            logger.error("Max retries reached. Unable to get a successful response from FcgiCommand.");
        }
    }

    private static List<JSONArray> divideJSONArray(JSONArray jsonArray, int chunkSize) {
        ArrayList<JSONArray> chunks = new ArrayList<JSONArray>();
        for (int i = 0; i < jsonArray.length(); i += chunkSize) {
            JSONArray chunk = new JSONArray();
            for (int j = i; j < i + chunkSize && j < jsonArray.length(); ++j) {
                chunk.put(jsonArray.get(j));
            }
            chunks.add(chunk);
        }
        return chunks;
    }

    private static JSONObject buildCommandObject(JSONArray chunk) throws JSONException {
        JSONObject commandObj = new JSONObject();
        commandObj.put("cmd", "subscribe2");
        commandObj.put("param", new JSONObject().put("period", 1000));
        JSONArray dataArray = new JSONArray();
        for (int i = 0; i < chunk.length(); ++i) {
            String item = chunk.getString(i);
            JSONObject obj = new JSONObject();
            obj.put("name", "app." + item);
            dataArray.put(obj);
        }
        commandObj.put("data", dataArray);
        return commandObj;
    }

    public static void processJSONArray(JSONArray jsonArray) {
        try {
            Service.variableTagMap.clear();
            logger.info("Cleared the variableTagMap.");
            logger.info("Added " + jsonArray.length() + " items to variableTagMap.");
            int chunkSize = 300;
            List<JSONArray> chunks = StartanSubscribeWebExecutor.divideJSONArray(jsonArray, chunkSize);
            logger.debug("Divided JSON array into " + chunks.size() + " chunks.");
            WebSocketMessageProcessor messageProcessor = new WebSocketMessageProcessor();
            Thread processorThread = new Thread(messageProcessor);
            processorThread.start();
            boolean chunkCount = false;
            for (int chunkIndex = 0; chunkIndex < chunks.size(); ++chunkIndex) {
                try {
                    JSONArray chunk = chunks.get(chunkIndex);
                    JSONObject commandObj = StartanSubscribeWebExecutor.buildCommandObject(chunk);
                    String commandStr = commandObj.toString();
                    ChunkWebSocketClient client = new ChunkWebSocketClient(Service.webSocketUrl, commandStr, chunkIndex);
                    Thread clientThread = new Thread(client);
                    clientThread.setName("WebSocket-Chunk-" + chunkIndex);
                    clientThread.start();
                    activeClients.add(client);
                    logger.debug("Scheduled WebSocket client for chunk " + chunkIndex + " with size " + chunk.length());
                    Thread.sleep(200L);
                    continue;
                }
                catch (JSONException e) {
                    logger.error("Error while building command object or scheduling task: " + e.getMessage(), e);
                }
            }
        }
        catch (Exception e) {
            logger.error("Error occurred while processing JSON array: " + e.getMessage(), e);
        }
    }

    public static void retrieveAndProcessJSONArray() {
        try {
            JSONArray jsonArray = jsonArrayMap.get("resultArray");
            if (jsonArray != null) {
                StartanSubscribeWebExecutor.processJSONArray(jsonArray);
                logger.debug("JSONArray processed successfully.");
            } else {
                logger.warn("JSONArray with key 'resultArray' not found in HashMap.");
            }
        }
        catch (Exception e) {
            logger.error("Error occurred while retrieving and processing JSONArray: " + e.getMessage(), e);
        }
    }

    public void disconnectAllClients() {
        logger.info("Disconnecting all active WebSocket clients...");
        for (ChunkWebSocketClient client : activeClients) {
            try {
                client.disconnect();
            }
            catch (Exception e) {
                logger.error("Error while disconnecting client: " + e.getMessage(), e);
            }
        }
        activeClients.clear();
        StartanSubscribeWebExecutor.restartService();
        App.simpleServer.getName_space().removeNodes("Starton");
        logger.info("All WebSocket clients disconnected.");
    }

    public static boolean restartService() {
        String command = "systemctl restart t5ws";
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.command("bash", "-c", command);
        try {
            Process process = processBuilder.start();
            int exitCode = process.waitFor();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                 BufferedReader errorReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));){
                String line;
                while ((line = reader.readLine()) != null) {
                }
                while ((line = errorReader.readLine()) != null) {
                    logger.error(line);
                }
            }
            if (exitCode == 0) {
                logger.info("Service 't5ws' restarted successfully.");
                return true;
            }
            logger.error("Failed to restart service 't5ws'. Exit code: " + exitCode);
            return false;
        }
        catch (Exception e) {
            logger.error("Error restarting service 't5ws': " + e.getMessage(), e);
            return false;
        }
    }

    public static void main(String[] args) {
        StartanSubscribeWebExecutor startanWebExecutor = new StartanSubscribeWebExecutor();
        Thread startonThread = new Thread(startanWebExecutor);
        startonThread.setName("STARTON Web MODULE");
        startonThread.start();
        logger.info("Starton WEB executor module started.");
    }
}

