/*
 * Decompiled with CFR 0.152.
 */
package startanSubscribeWebSocket;

import com.tas.wp500.webSocket.WebSocketMessageProcessor;
import java.net.URI;
import java.util.concurrent.CountDownLatch;
import javax.websocket.ClientEndpoint;
import javax.websocket.CloseReason;
import javax.websocket.ContainerProvider;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

@ClientEndpoint(subprotocols={"straton-protocol"})
public class ChunkWebSocketClient
implements Runnable {
    private static final Logger logger = Logger.getLogger(ChunkWebSocketClient.class);
    private final String uri;
    private final String commandObj;
    private final int chunkIndex;
    private Session session;
    private CountDownLatch latch;

    public ChunkWebSocketClient(String uri, String commandObj, int chunkIndex) {
        this.uri = uri;
        this.commandObj = commandObj;
        this.chunkIndex = chunkIndex;
    }

    @Override
    public void run() {
        try {
            WebSocketContainer container = ContainerProvider.getWebSocketContainer();
            this.latch = new CountDownLatch(1);
            container.connectToServer(this, URI.create(this.uri));
            this.latch.await();
        }
        catch (Exception e) {
            logger.error("Error in WebSocket client for chunk " + this.chunkIndex + ": " + e.getMessage(), e);
        }
        finally {
            this.cleanupResources();
        }
    }

    @OnOpen
    public void onOpen(Session session) {
        this.session = session;
        this.sendCommand();
    }

    @OnMessage
    public void onMessage(String message) {
        try {
            if (message == null || message.isEmpty()) {
                logger.warn("Received empty or null message for chunk " + this.chunkIndex);
                return;
            }
            if (message.contains("rtstatus2")) {
                return;
            }
            JSONObject response = new JSONObject(message);
            if (response.has("error") && response.getInt("error") == 200 || response.has("ok") && "ok".equals(response.getString("ok"))) {
                WebSocketMessageProcessor.addMessage(message);
            } else {
                logger.error("Invalid response for chunk " + this.chunkIndex + ": " + response);
            }
        }
        catch (JSONException e) {
            logger.error("Error parsing message for chunk " + this.chunkIndex + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            logger.error("Unexpected error processing message for chunk " + this.chunkIndex + ": " + e.getMessage(), e);
        }
    }

    @OnClose
    public void onClose(CloseReason reason) {
        logger.info("WebSocket connection closed for chunk " + this.chunkIndex + ": " + reason);
        this.latch.countDown();
    }

    @OnError
    public void onError(Throwable throwable) {
        logger.error("Error in WebSocket for chunk " + this.chunkIndex + ": " + throwable.getMessage(), throwable);
        if (throwable instanceof Exception) {
            this.reconnect();
        }
    }

    private void sendCommand() {
        try {
            if (this.session != null && this.session.isOpen()) {
                this.session.getAsyncRemote().sendText(this.commandObj);
                logger.info("Command sent for chunk " + this.chunkIndex);
            } else {
                logger.warn("Cannot send command. Session is not open for chunk " + this.chunkIndex);
            }
        }
        catch (Exception e) {
            logger.error("Error sending command for chunk " + this.chunkIndex + ": " + e.getMessage(), e);
        }
    }

    public void disconnect() {
        try {
            if (this.session != null && this.session.isOpen()) {
                this.session.close();
                logger.info("WebSocket connection for chunk " + this.chunkIndex + " disconnected successfully.");
            } else {
                logger.info("WebSocket connection for chunk " + this.chunkIndex + " is already closed.");
            }
        }
        catch (Exception e) {
            logger.error("Error disconnecting WebSocket for chunk " + this.chunkIndex + ": " + e.getMessage(), e);
        }
    }

    private void reconnect() {
        logger.info("Attempting to reconnect WebSocket for chunk " + this.chunkIndex);
        new Thread(this).start();
    }

    private void cleanupResources() {
        try {
            if (this.session != null && this.session.isOpen()) {
                this.session.close();
            }
            this.latch.countDown();
        }
        catch (Exception e) {
            logger.error("Error during cleanup for chunk " + this.chunkIndex + ": " + e.getMessage(), e);
        }
    }
}

