/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.server.transport;

import com.google.common.collect.ConcurrentHashMultiset;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LoggingHandler;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.eclipse.milo.opcua.stack.core.Stack;
import org.eclipse.milo.opcua.stack.core.transport.TransportProfile;
import org.eclipse.milo.opcua.stack.core.util.AsyncSemaphore;
import org.eclipse.milo.opcua.stack.core.util.Unit;
import org.eclipse.milo.opcua.stack.server.EndpointConfiguration;
import org.eclipse.milo.opcua.stack.server.UaStackServer;
import org.eclipse.milo.opcua.stack.server.transport.http.OpcServerHttpChannelInitializer;
import org.eclipse.milo.opcua.stack.server.transport.tcp.OpcServerTcpChannelInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerChannelManager {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final AsyncSemaphore semaphore = new AsyncSemaphore(1);
    private final Multiset<InetSocketAddress> addresses = ConcurrentHashMultiset.create();
    private final Map<InetSocketAddress, Channel> channels = Maps.newConcurrentMap();
    private final UaStackServer stackServer;

    public ServerChannelManager(UaStackServer stackServer) {
        this.stackServer = stackServer;
    }

    public CompletableFuture<Unit> bind(EndpointConfiguration endpoint) {
        CompletableFuture<Unit> future = new CompletableFuture<Unit>();
        this.semaphore.acquire().thenApply(permit -> {
            future.whenComplete((u, ex) -> permit.release());
            InetSocketAddress bindAddress = new InetSocketAddress(endpoint.getBindAddress(), endpoint.getBindPort());
            if (this.channels.containsKey(bindAddress)) {
                return future.complete(Unit.VALUE);
            }
            this.logger.debug("binding to {}", (Object)bindAddress);
            CompletableFuture<Channel> bootstrap = ServerChannelManager.bootstrap(this.stackServer, bindAddress, endpoint.getTransportProfile());
            return bootstrap.whenComplete((channel, ex) -> {
                if (channel != null) {
                    this.addresses.add(bindAddress);
                    this.channels.put(bindAddress, (Channel)channel);
                    future.complete(Unit.VALUE);
                } else {
                    future.completeExceptionally((Throwable)ex);
                }
            });
        });
        return future;
    }

    public CompletableFuture<Unit> unbind(EndpointConfiguration endpoint) {
        CompletableFuture<Unit> future = new CompletableFuture<Unit>();
        this.semaphore.acquire().thenAccept(permit -> {
            future.whenComplete((u, ex) -> permit.release());
            InetSocketAddress bindAddress = new InetSocketAddress(endpoint.getBindAddress(), endpoint.getBindPort());
            if (this.addresses.remove(bindAddress, 1) == 1) {
                this.logger.debug("unbinding from {}", (Object)bindAddress);
                Channel channel = this.channels.remove(bindAddress);
                if (channel != null) {
                    channel.close();
                }
            }
            future.complete(Unit.VALUE);
        });
        return future;
    }

    private static CompletableFuture<Channel> bootstrap(UaStackServer stackServer, InetSocketAddress bindAddress, TransportProfile transportProfile) {
        ChannelInitializer initializer = transportProfile == TransportProfile.TCP_UASC_UABINARY ? new OpcServerTcpChannelInitializer(stackServer) : new OpcServerHttpChannelInitializer(stackServer);
        ServerBootstrap bootstrap = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)bootstrap.group(Stack.sharedEventLoop()).handler(new LoggingHandler(ServerChannelManager.class))).channel(NioServerSocketChannel.class)).childOption(ChannelOption.ALLOCATOR, PooledByteBufAllocator.DEFAULT).childOption(ChannelOption.TCP_NODELAY, true).childHandler(initializer);
        CompletableFuture<Channel> channelFuture = new CompletableFuture<Channel>();
        bootstrap.bind(bindAddress).addListener(future -> {
            if (future.isSuccess()) {
                Channel channel = future.channel();
                channelFuture.complete(channel);
            } else {
                channelFuture.completeExceptionally(future.cause());
            }
        });
        return channelFuture;
    }
}

