/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.util;

import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import java.util.UUID;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.XmlElement;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.ULong;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.jetbrains.annotations.Nullable;

public class TypeUtil {
    private static final ImmutableMap<Integer, Class<?>> BUILTIN_TYPES;
    private static final ImmutableMap<Class<?>, Integer> BUILTIN_TYPES_INVERSE;
    private static final ImmutableMap<Class<?>, Integer> PRIMITIVE_BUILTIN_TYPES;
    private static final ImmutableMap<Integer, Class<?>> PRIMITIVE_BUILTIN_TYPES_INVERSE;

    public static int getBuiltinTypeId(Class<?> backingType) {
        if (backingType.isPrimitive()) {
            return PRIMITIVE_BUILTIN_TYPES.getOrDefault(backingType, -1);
        }
        return BUILTIN_TYPES_INVERSE.getOrDefault(backingType, -1);
    }

    public static boolean isBuiltin(NodeId typeId) {
        return BUILTIN_TYPES.containsKey(TypeUtil.id(typeId));
    }

    public static boolean isBuiltin(ExpandedNodeId typeId) {
        return BUILTIN_TYPES.containsKey(TypeUtil.id(typeId));
    }

    @Nullable
    public static Class<?> getBackingClass(int id) {
        return BUILTIN_TYPES.get(id);
    }

    @Nullable
    public static Class<?> getBackingClass(NodeId typeId) {
        return TypeUtil.getBackingClass(TypeUtil.id(typeId));
    }

    @Nullable
    public static Class<?> getPrimitiveBackingClass(int id) {
        return PRIMITIVE_BUILTIN_TYPES_INVERSE.getOrDefault(id, TypeUtil.getBackingClass(id));
    }

    @Nullable
    public static Class<?> getPrimitiveBackingClass(NodeId typeId) {
        return TypeUtil.getPrimitiveBackingClass(TypeUtil.id(typeId));
    }

    private static int id(NodeId nodeId) {
        if (nodeId.getIdentifier() instanceof UInteger) {
            return ((UInteger)nodeId.getIdentifier()).intValue();
        }
        return -1;
    }

    private static int id(ExpandedNodeId nodeId) {
        if (nodeId.getIdentifier() instanceof UInteger) {
            return ((UInteger)nodeId.getIdentifier()).intValue();
        }
        return -1;
    }

    static {
        HashBiMap<Integer, Class<DiagnosticInfo>> builtinTypes = HashBiMap.create();
        builtinTypes.put(1, Boolean.class);
        builtinTypes.put(2, Byte.class);
        builtinTypes.put(3, UByte.class);
        builtinTypes.put(4, Short.class);
        builtinTypes.put(5, UShort.class);
        builtinTypes.put(6, Integer.class);
        builtinTypes.put(7, UInteger.class);
        builtinTypes.put(8, Long.class);
        builtinTypes.put(9, ULong.class);
        builtinTypes.put(10, Float.class);
        builtinTypes.put(11, Double.class);
        builtinTypes.put(12, String.class);
        builtinTypes.put(13, DateTime.class);
        builtinTypes.put(14, UUID.class);
        builtinTypes.put(15, ByteString.class);
        builtinTypes.put(16, XmlElement.class);
        builtinTypes.put(17, NodeId.class);
        builtinTypes.put(18, ExpandedNodeId.class);
        builtinTypes.put(19, StatusCode.class);
        builtinTypes.put(20, QualifiedName.class);
        builtinTypes.put(21, LocalizedText.class);
        builtinTypes.put(22, ExtensionObject.class);
        builtinTypes.put(23, DataValue.class);
        builtinTypes.put(24, Variant.class);
        builtinTypes.put(25, DiagnosticInfo.class);
        BUILTIN_TYPES = ImmutableMap.copyOf(builtinTypes);
        BUILTIN_TYPES_INVERSE = ImmutableMap.copyOf(builtinTypes.inverse());
        HashBiMap<Class<Comparable<Boolean>>, Integer> primitiveBuiltinTypes = HashBiMap.create();
        primitiveBuiltinTypes.put(Boolean.TYPE, 1);
        primitiveBuiltinTypes.put(Byte.TYPE, 2);
        primitiveBuiltinTypes.put(Short.TYPE, 4);
        primitiveBuiltinTypes.put(Integer.TYPE, 6);
        primitiveBuiltinTypes.put(Long.TYPE, 8);
        primitiveBuiltinTypes.put(Float.TYPE, 10);
        primitiveBuiltinTypes.put(Double.TYPE, 11);
        PRIMITIVE_BUILTIN_TYPES = ImmutableMap.copyOf(primitiveBuiltinTypes);
        PRIMITIVE_BUILTIN_TYPES_INVERSE = ImmutableMap.copyOf(primitiveBuiltinTypes.inverse());
    }
}

