/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.util;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.function.Function;

public class ArrayUtil {
    public static Object flatten(Object array) {
        Preconditions.checkArgument(array.getClass().isArray(), "array");
        Class<?> type = ArrayUtil.getType(array);
        int[] dimensions = ArrayUtil.getDimensions(array);
        int length = ArrayUtil.length(dimensions);
        Object flattened = Array.newInstance(type, length);
        ArrayUtil.flatten(array, flattened, dimensions, 0);
        return flattened;
    }

    private static void flatten(Object array, Object flattened, int[] dimensions, int offset) {
        if (dimensions.length == 1) {
            for (int i = 0; i < dimensions[0]; ++i) {
                Object element = Array.get(array, i);
                Array.set(flattened, i + offset, element);
            }
        } else {
            int[] tail = Arrays.copyOfRange(dimensions, 1, dimensions.length);
            for (int i = 0; i < dimensions[0]; ++i) {
                Object a = Array.get(array, i);
                ArrayUtil.flatten(a, flattened, tail, offset + i * ArrayUtil.length(tail));
            }
        }
    }

    public static Object unflatten(Object array, int[] dimensions) {
        Class<?> type = ArrayUtil.getType(array);
        return ArrayUtil.unflatten(type, array, dimensions, 0);
    }

    private static Object unflatten(Class<?> type, Object array, int[] dimensions, int offset) {
        Object a;
        if (dimensions.length == 1) {
            a = Array.newInstance(type, dimensions[0]);
            for (int i = 0; i < dimensions[0]; ++i) {
                Array.set(a, i, Array.get(array, offset + i));
            }
        } else {
            a = Array.newInstance(type, dimensions);
            int[] tail = Arrays.copyOfRange(dimensions, 1, dimensions.length);
            for (int i = 0; i < dimensions[0]; ++i) {
                Object element = ArrayUtil.unflatten(type, array, tail, offset + i * ArrayUtil.length(tail));
                Array.set(a, i, element);
            }
        }
        return a;
    }

    public static int[] getDimensions(Object array) {
        int[] dimensions = new int[]{};
        Class<?> type = array.getClass();
        while (type.isArray()) {
            int length = array != null ? Array.getLength(array) : 0;
            dimensions = Ints.concat(dimensions, {length});
            array = length > 0 ? Array.get(array, 0) : null;
            type = type.getComponentType();
        }
        return dimensions;
    }

    public static Class<?> getType(Object array) {
        Class<?> type = array.getClass();
        while (type.isArray()) {
            type = type.getComponentType();
        }
        return type;
    }

    private static int length(int[] tail) {
        int product = 1;
        for (int aTail : tail) {
            product *= aTail;
        }
        return product;
    }

    public static <F, T> Object transformArray(Object array, Function<F, T> transform, Class<T> toType) {
        int[] dimensions = ArrayUtil.getDimensions(array);
        Object flatArray = dimensions.length > 1 ? ArrayUtil.flatten(array) : array;
        Object transformedArray = ArrayUtil.transformFlatArray(flatArray, transform, toType);
        return dimensions.length > 1 ? ArrayUtil.unflatten(transformedArray, dimensions) : transformedArray;
    }

    private static <F, T> Object transformFlatArray(Object flatArray, Function<F, T> transform, Class<T> toType) {
        int length = Array.getLength(flatArray);
        Object array = Array.newInstance(toType, length);
        for (int i = 0; i < length; ++i) {
            T transformed = transform.apply(Array.get(flatArray, i));
            Array.set(array, i, transformed);
        }
        return array;
    }
}

