/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.builtin;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import javax.xml.bind.DatatypeConverter;
import org.eclipse.milo.opcua.stack.core.NamespaceTable;
import org.eclipse.milo.opcua.stack.core.UaRuntimeException;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.IdType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NodeId {
    public static final NodeId NULL_NUMERIC = new NodeId(Unsigned.ushort(0), Unsigned.uint(0));
    public static final NodeId NULL_STRING = new NodeId(Unsigned.ushort(0), "");
    public static final NodeId NULL_GUID = new NodeId(Unsigned.ushort(0), new UUID(0L, 0L));
    public static final NodeId NULL_OPAQUE = new NodeId(Unsigned.ushort(0), ByteString.NULL_VALUE);
    public static final NodeId NULL_VALUE = NULL_NUMERIC;
    private final UShort namespaceIndex;
    private final Object identifier;

    public NodeId(int namespaceIndex, int identifier) {
        this(Unsigned.ushort(namespaceIndex), Unsigned.uint(identifier));
    }

    public NodeId(int namespaceIndex, UInteger identifier) {
        this(Unsigned.ushort(namespaceIndex), identifier);
    }

    public NodeId(int namespaceIndex, String identifier) {
        this(Unsigned.ushort(namespaceIndex), identifier);
    }

    public NodeId(int namespaceIndex, UUID identifier) {
        this(Unsigned.ushort(namespaceIndex), identifier);
    }

    public NodeId(int namespaceIndex, ByteString identifier) {
        this(Unsigned.ushort(namespaceIndex), identifier);
    }

    public NodeId(UShort namespaceIndex, UInteger identifier) {
        Preconditions.checkNotNull(namespaceIndex);
        Preconditions.checkNotNull(identifier);
        this.namespaceIndex = namespaceIndex;
        this.identifier = identifier;
    }

    public NodeId(UShort namespaceIndex, int identifier) {
        Preconditions.checkNotNull(namespaceIndex);
        this.namespaceIndex = namespaceIndex;
        this.identifier = Unsigned.uint(identifier);
    }

    public NodeId(UShort namespaceIndex, String identifier) {
        Preconditions.checkNotNull(namespaceIndex);
        if (identifier == null) {
            identifier = "";
        }
        this.namespaceIndex = namespaceIndex;
        this.identifier = identifier;
    }

    public NodeId(UShort namespaceIndex, UUID identifier) {
        Preconditions.checkNotNull(namespaceIndex);
        Preconditions.checkNotNull(identifier);
        this.namespaceIndex = namespaceIndex;
        this.identifier = identifier;
    }

    public NodeId(UShort namespaceIndex, ByteString identifier) {
        Preconditions.checkNotNull(namespaceIndex);
        Preconditions.checkNotNull(identifier);
        this.namespaceIndex = namespaceIndex;
        this.identifier = identifier;
    }

    NodeId(@NotNull UShort namespaceIndex, @NotNull Object identifier) {
        Preconditions.checkNotNull(namespaceIndex);
        Preconditions.checkNotNull(identifier);
        this.namespaceIndex = namespaceIndex;
        this.identifier = identifier;
    }

    public UShort getNamespaceIndex() {
        return this.namespaceIndex;
    }

    public Object getIdentifier() {
        return this.identifier;
    }

    public IdType getType() {
        if (this.identifier instanceof UInteger) {
            return IdType.Numeric;
        }
        if (this.identifier instanceof String) {
            return IdType.String;
        }
        if (this.identifier instanceof UUID) {
            return IdType.Guid;
        }
        return IdType.Opaque;
    }

    public ExpandedNodeId expanded() {
        return new ExpandedNodeId(this.namespaceIndex, null, this.identifier, UInteger.MIN);
    }

    public ExpandedNodeId expanded(NamespaceTable namespaceTable) {
        String namespaceUri = namespaceTable.getUri(this.namespaceIndex);
        return new ExpandedNodeId(this.namespaceIndex, namespaceUri, this.identifier, UInteger.MIN);
    }

    public boolean isNull() {
        return this.namespaceIndex.intValue() == 0 && (NULL_NUMERIC.equals(this) || NULL_STRING.equals(this) || NULL_GUID.equals(this) || NULL_OPAQUE.equals(this));
    }

    public boolean isNotNull() {
        return !this.isNull();
    }

    public NodeId reindex(NamespaceTable namespaceTable, String namespaceUri) {
        UShort namespaceIndex = namespaceTable.getIndex(namespaceUri);
        if (namespaceIndex != null && !namespaceIndex.equals(this.getNamespaceIndex())) {
            return this.withNamespaceIndex(namespaceIndex);
        }
        return this;
    }

    public NodeId withId(UInteger id) {
        return new NodeId(this.namespaceIndex, id);
    }

    public NodeId withId(String id) {
        return new NodeId(this.namespaceIndex, id);
    }

    public NodeId withId(UUID id) {
        return new NodeId(this.namespaceIndex, id);
    }

    public NodeId withId(ByteString id) {
        return new NodeId(this.namespaceIndex, id);
    }

    public NodeId withNamespaceIndex(UShort namespaceIndex) {
        return new NodeId(namespaceIndex, this.identifier);
    }

    @Deprecated
    public boolean equals(ExpandedNodeId xni) {
        return this.equalTo(xni);
    }

    @Deprecated
    public boolean equals(ExpandedNodeId xni, NamespaceTable namespaceTable) {
        return this.equalTo(xni, namespaceTable);
    }

    public boolean equalTo(ExpandedNodeId xni) {
        return this.equalTo(xni, (String uri) -> {
            if ("http://opcfoundation.org/UA/".equals(uri)) {
                return UShort.MIN;
            }
            return null;
        });
    }

    public boolean equalTo(ExpandedNodeId xni, NamespaceTable namespaceTable) {
        return this.equalTo(xni, namespaceTable::getIndex);
    }

    private boolean equalTo(ExpandedNodeId xni, Function<String, UShort> getIndex) {
        if (!xni.isLocal()) {
            return false;
        }
        UShort otherNamespaceIndex = xni.isAbsolute() ? getIndex.apply(xni.getNamespaceUri()) : xni.getNamespaceIndex();
        return Objects.equal(this.namespaceIndex, otherNamespaceIndex) && Objects.equal(this.identifier, xni.getIdentifier());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeId nodeId = (NodeId)o;
        return this.identifier.equals(nodeId.identifier) && this.namespaceIndex.equals(nodeId.namespaceIndex);
    }

    public int hashCode() {
        int result = this.namespaceIndex.hashCode();
        result = 31 * result + this.identifier.hashCode();
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("ns", this.namespaceIndex).add("id", this.identifier).toString();
    }

    public String toParseableString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ns=").append(this.namespaceIndex).append(";");
        switch (this.getType()) {
            case Numeric: {
                sb.append("i=").append(this.identifier);
                break;
            }
            case String: {
                sb.append("s=").append(this.identifier);
                break;
            }
            case Guid: {
                sb.append("g=").append(this.identifier);
                break;
            }
            case Opaque: {
                ByteString bs = (ByteString)this.identifier;
                if (bs.isNull()) {
                    sb.append("b=");
                    break;
                }
                sb.append("b=").append(DatatypeConverter.printBase64Binary(bs.bytes()));
                break;
            }
            default: {
                throw new IllegalStateException("unknown IdType: " + this.getType());
            }
        }
        return sb.toString();
    }

    public static NodeId parse(@NotNull String s) throws UaRuntimeException {
        if (s.startsWith("ns=")) {
            int index = s.indexOf(";");
            if (index == -1) {
                throw new UaRuntimeException(0x80330000L);
            }
            try {
                int namespaceIndex = Integer.parseInt(s.substring(3, index));
                return NodeId.parse(s.substring(index + 1), namespaceIndex);
            }
            catch (NumberFormatException e) {
                throw new UaRuntimeException(0x80330000L, (Throwable)e);
            }
        }
        return NodeId.parse(s, 0);
    }

    private static NodeId parse(String s, int namespaceIndex) throws UaRuntimeException {
        if (s.length() < 2) {
            throw new UaRuntimeException(0x80330000L);
        }
        String type = s.substring(0, 2);
        String id = s.substring(2);
        switch (type) {
            case "i=": {
                try {
                    return new NodeId(namespaceIndex, Unsigned.uint(Long.parseLong(id)));
                }
                catch (NumberFormatException e) {
                    throw new UaRuntimeException(0x80330000L, (Throwable)e);
                }
            }
            case "s=": {
                return new NodeId(namespaceIndex, id);
            }
            case "g=": {
                try {
                    return new NodeId(namespaceIndex, UUID.fromString(id));
                }
                catch (IllegalArgumentException e) {
                    throw new UaRuntimeException(0x80330000L, (Throwable)e);
                }
            }
            case "b=": {
                try {
                    return new NodeId(namespaceIndex, ByteString.of(DatatypeConverter.parseBase64Binary(id)));
                }
                catch (IllegalArgumentException e) {
                    throw new UaRuntimeException(0x80330000L, (Throwable)e);
                }
            }
        }
        throw new UaRuntimeException(0x80330000L);
    }

    @Nullable
    public static NodeId parseOrNull(@NotNull String s) {
        try {
            return NodeId.parse(s);
        }
        catch (UaRuntimeException t) {
            return null;
        }
    }

    public static Optional<NodeId> parseSafe(@NotNull String s) {
        return Optional.ofNullable(NodeId.parseOrNull(s));
    }
}

