/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.builtin;

import com.google.common.base.MoreObjects;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;

public final class LocalizedText {
    public static final LocalizedText NULL_VALUE = new LocalizedText(null, null);
    private final String locale;
    private final String text;

    public LocalizedText(@Nullable String text) {
        this(Locale.ENGLISH.getLanguage(), text);
    }

    public LocalizedText(@Nullable String locale, @Nullable String text) {
        this.locale = locale;
        this.text = text;
    }

    @Nullable
    public String getLocale() {
        return this.locale;
    }

    @Nullable
    public String getText() {
        return this.text;
    }

    public static LocalizedText english(@Nullable String text) {
        return new LocalizedText(text);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalizedText that = (LocalizedText)o;
        return !(this.locale == null ? that.locale != null : !this.locale.equals(that.locale)) && !(this.text == null ? that.text != null : !this.text.equals(that.text));
    }

    public int hashCode() {
        int result = this.locale != null ? this.locale.hashCode() : 0;
        result = 31 * result + (this.text != null ? this.text.hashCode() : 0);
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("text", this.text).add("locale", this.locale).toString();
    }
}

