/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.channel;

import com.google.common.base.MoreObjects;
import io.netty.util.DefaultAttributeMap;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.channel.ChannelSecurity;
import org.eclipse.milo.opcua.stack.core.channel.SecureChannel;
import org.eclipse.milo.opcua.stack.core.security.SecurityPolicy;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MessageSecurityMode;
import org.eclipse.milo.opcua.stack.core.util.CertificateUtil;

public class ServerSecureChannel
extends DefaultAttributeMap
implements SecureChannel {
    private volatile long channelId = 0L;
    private volatile ChannelSecurity channelSecurity;
    private volatile ByteString localNonce = ByteString.NULL_VALUE;
    private volatile ByteString remoteNonce = ByteString.NULL_VALUE;
    private volatile KeyPair keyPair;
    private volatile X509Certificate localCertificate;
    private volatile List<X509Certificate> localCertificateChain;
    private volatile X509Certificate remoteCertificate;
    private volatile List<X509Certificate> remoteCertificateChain;
    private volatile SecurityPolicy securityPolicy;
    private volatile MessageSecurityMode messageSecurityMode;

    public void setChannelId(long channelId) {
        this.channelId = channelId;
    }

    public void setLocalNonce(ByteString localNonce) {
        this.localNonce = localNonce;
    }

    public void setRemoteNonce(ByteString remoteNonce) {
        this.remoteNonce = remoteNonce;
    }

    public void setChannelSecurity(ChannelSecurity channelSecurity) {
        this.channelSecurity = channelSecurity;
    }

    public void setKeyPair(KeyPair keyPair) {
        this.keyPair = keyPair;
    }

    public void setLocalCertificate(X509Certificate localCertificate) {
        this.localCertificate = localCertificate;
    }

    public void setLocalCertificateChain(X509Certificate[] localCertificateChain) {
        this.localCertificateChain = Arrays.asList(localCertificateChain);
    }

    public void setRemoteCertificate(byte[] certificateBytes) throws UaException {
        this.remoteCertificate = CertificateUtil.decodeCertificate(certificateBytes);
        this.remoteCertificateChain = CertificateUtil.decodeCertificates(certificateBytes);
    }

    public void setSecurityPolicy(SecurityPolicy securityPolicy) {
        this.securityPolicy = securityPolicy;
    }

    public void setMessageSecurityMode(MessageSecurityMode messageSecurityMode) {
        this.messageSecurityMode = messageSecurityMode;
    }

    @Override
    public KeyPair getKeyPair() {
        return this.keyPair;
    }

    @Override
    public X509Certificate getLocalCertificate() {
        return this.localCertificate;
    }

    @Override
    public List<X509Certificate> getLocalCertificateChain() {
        return this.localCertificateChain;
    }

    @Override
    public X509Certificate getRemoteCertificate() {
        return this.remoteCertificate;
    }

    @Override
    public List<X509Certificate> getRemoteCertificateChain() {
        return this.remoteCertificateChain;
    }

    @Override
    public SecurityPolicy getSecurityPolicy() {
        return this.securityPolicy;
    }

    @Override
    public MessageSecurityMode getMessageSecurityMode() {
        return this.messageSecurityMode;
    }

    @Override
    public long getChannelId() {
        return this.channelId;
    }

    @Override
    public ChannelSecurity getChannelSecurity() {
        return this.channelSecurity;
    }

    @Override
    public ChannelSecurity.SecretKeys getEncryptionKeys(ChannelSecurity.SecurityKeys securityKeys) {
        return securityKeys.getServerKeys();
    }

    @Override
    public ChannelSecurity.SecretKeys getDecryptionKeys(ChannelSecurity.SecurityKeys securityKeys) {
        return securityKeys.getClientKeys();
    }

    @Override
    public ByteString getLocalNonce() {
        return this.localNonce;
    }

    @Override
    public ByteString getRemoteNonce() {
        return this.remoteNonce;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("channelId", this.channelId).add("securityPolicy", (Object)this.securityPolicy).toString();
    }
}

