/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.channel;

import com.google.common.base.Preconditions;

public class EncodingLimits {
    public static final EncodingLimits DEFAULT = new EncodingLimits();
    public static final int DEFAULT_MAX_MESSAGE_SIZE = 0x200000;
    public static final int DEFAULT_MAX_CHUNK_SIZE = 65535;
    public static final int DEFAULT_MAX_CHUNK_COUNT = 64;
    public static final int DEFAULT_MAX_RECURSION_DEPTH = 128;
    private final int maxChunkSize;
    private final int maxChunkCount;
    private final int maxMessageSize;
    private final int maxRecursionDepth;

    public EncodingLimits() {
        this(65535, 64, 0x200000, 128);
    }

    public EncodingLimits(int maxChunkSize, int maxChunkCount, int maxMessageSize, int maxRecursionDepth) {
        Preconditions.checkArgument(maxChunkSize >= 8196, "maxChunkSize must be greater than or equal to 8196");
        this.maxChunkSize = maxChunkSize;
        this.maxChunkCount = maxChunkCount;
        this.maxMessageSize = maxMessageSize;
        this.maxRecursionDepth = maxRecursionDepth;
    }

    public int getMaxChunkSize() {
        return this.maxChunkSize;
    }

    public int getMaxChunkCount() {
        return this.maxChunkCount;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public int getMaxRecursionDepth() {
        return this.maxRecursionDepth;
    }
}

