/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Optional;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;

public enum AttributeId {
    NodeId(1),
    NodeClass(2),
    BrowseName(3),
    DisplayName(4),
    Description(5),
    WriteMask(6),
    UserWriteMask(7),
    IsAbstract(8),
    Symmetric(9),
    InverseName(10),
    ContainsNoLoops(11),
    EventNotifier(12),
    Value(13),
    DataType(14),
    ValueRank(15),
    ArrayDimensions(16),
    AccessLevel(17),
    UserAccessLevel(18),
    MinimumSamplingInterval(19),
    Historizing(20),
    Executable(21),
    UserExecutable(22);

    public static final ImmutableSet<AttributeId> BASE_ATTRIBUTES;
    public static final ImmutableSet<AttributeId> DATA_TYPE_ATTRIBUTES;
    public static final ImmutableSet<AttributeId> METHOD_ATTRIBUTES;
    public static final ImmutableSet<AttributeId> OBJECT_ATTRIBUTES;
    public static final ImmutableSet<AttributeId> OBJECT_TYPE_ATTRIBUTES;
    public static final ImmutableSet<AttributeId> REFERENCE_TYPE_ATTRIBUTES;
    public static final ImmutableSet<AttributeId> VARIABLE_ATTRIBUTES;
    public static final ImmutableSet<AttributeId> VARIABLE_TYPE_ATTRIBUTES;
    public static final ImmutableSet<AttributeId> VIEW_ATTRIBUTES;
    private final int id;

    private AttributeId(int id) {
        this.id = id;
    }

    public final int id() {
        return this.id;
    }

    public final UInteger uid() {
        return Unsigned.uint(this.id);
    }

    public static Optional<AttributeId> from(UInteger attributeId) {
        return AttributeId.from(attributeId.intValue());
    }

    public static Optional<AttributeId> from(int attributeId) {
        if (attributeId > 0 && attributeId <= AttributeId.values().length) {
            return Optional.of(AttributeId.values()[attributeId - 1]);
        }
        return Optional.empty();
    }

    public boolean isEqual(UInteger attributeId) {
        return attributeId != null && this.isEqual(attributeId.intValue());
    }

    public boolean isEqual(int attributeId) {
        return this.id == attributeId;
    }

    public static boolean isValid(UInteger attributeId) {
        return AttributeId.from(attributeId).isPresent();
    }

    public static boolean isValid(int attributeId) {
        return AttributeId.from(attributeId).isPresent();
    }

    public static ImmutableSet<AttributeId> getAttributes(NodeClass nodeClass) {
        switch (nodeClass) {
            case Object: {
                return OBJECT_ATTRIBUTES;
            }
            case Variable: {
                return VARIABLE_ATTRIBUTES;
            }
            case Method: {
                return METHOD_ATTRIBUTES;
            }
            case ObjectType: {
                return OBJECT_TYPE_ATTRIBUTES;
            }
            case VariableType: {
                return VARIABLE_TYPE_ATTRIBUTES;
            }
            case ReferenceType: {
                return REFERENCE_TYPE_ATTRIBUTES;
            }
            case DataType: {
                return DATA_TYPE_ATTRIBUTES;
            }
            case View: {
                return VIEW_ATTRIBUTES;
            }
        }
        return ImmutableSet.of();
    }

    static {
        BASE_ATTRIBUTES = ImmutableSet.copyOf(ImmutableSet.of(NodeId, NodeClass, BrowseName, DisplayName, Description, WriteMask, new AttributeId[]{UserWriteMask}));
        DATA_TYPE_ATTRIBUTES = ImmutableSet.copyOf(Sets.union(BASE_ATTRIBUTES, ImmutableSet.of(IsAbstract)));
        METHOD_ATTRIBUTES = ImmutableSet.copyOf(Sets.union(BASE_ATTRIBUTES, ImmutableSet.of(Executable, UserExecutable)));
        OBJECT_ATTRIBUTES = ImmutableSet.copyOf(Sets.union(BASE_ATTRIBUTES, ImmutableSet.of(EventNotifier)));
        OBJECT_TYPE_ATTRIBUTES = ImmutableSet.copyOf(Sets.union(BASE_ATTRIBUTES, ImmutableSet.of(IsAbstract)));
        REFERENCE_TYPE_ATTRIBUTES = ImmutableSet.copyOf(Sets.union(BASE_ATTRIBUTES, ImmutableSet.of(IsAbstract, Symmetric, InverseName)));
        VARIABLE_ATTRIBUTES = ImmutableSet.copyOf(Sets.union(BASE_ATTRIBUTES, ImmutableSet.of(Value, DataType, ValueRank, ArrayDimensions, AccessLevel, UserAccessLevel, new AttributeId[]{MinimumSamplingInterval, Historizing})));
        VARIABLE_TYPE_ATTRIBUTES = ImmutableSet.copyOf(Sets.union(BASE_ATTRIBUTES, ImmutableSet.of(Value, DataType, ValueRank, ArrayDimensions, IsAbstract)));
        VIEW_ATTRIBUTES = ImmutableSet.copyOf(Sets.union(BASE_ATTRIBUTES, ImmutableSet.of(ContainsNoLoops, EventNotifier)));
    }
}

