/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.client.transport.websocket;

import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketClientProtocolHandler;
import io.netty.handler.codec.http.websocketx.WebSocketFrameAggregator;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import org.eclipse.milo.opcua.stack.client.UaStackClient;
import org.eclipse.milo.opcua.stack.client.transport.uasc.ClientSecureChannel;
import org.eclipse.milo.opcua.stack.client.transport.websocket.OpcClientWebSocketBinaryFrameCodec;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.transport.TransportProfile;
import org.eclipse.milo.opcua.stack.core.util.EndpointUtil;

public class OpcClientWebSocketChannelInitializer
extends ChannelInitializer<SocketChannel> {
    private final UaStackClient client;
    private final CompletableFuture<ClientSecureChannel> handshake;

    public OpcClientWebSocketChannelInitializer(UaStackClient client, CompletableFuture<ClientSecureChannel> handshake) {
        this.client = client;
        this.handshake = handshake;
    }

    @Override
    protected void initChannel(SocketChannel channel) throws Exception {
        String subprotocol;
        String endpointUrl = this.client.getConfig().getEndpoint().getEndpointUrl();
        String scheme = EndpointUtil.getScheme(endpointUrl);
        TransportProfile transportProfile = TransportProfile.fromUri(this.client.getConfig().getEndpoint().getTransportProfileUri());
        if (transportProfile == TransportProfile.WSS_UASC_UABINARY) {
            subprotocol = "opcua+cp";
        } else if (transportProfile == TransportProfile.WSS_UAJSON) {
            subprotocol = "opcua+uajson";
        } else {
            throw new UaException(0x80020000L, "unexpected TransportProfile: " + (Object)((Object)transportProfile));
        }
        if ("opc.wss".equalsIgnoreCase(scheme)) {
            SslContext sslContext = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build();
            channel.pipeline().addLast(sslContext.newHandler(channel.alloc()));
        }
        int maxMessageSize = this.client.getConfig().getEncodingLimits().getMaxMessageSize();
        channel.pipeline().addLast(new LoggingHandler(LogLevel.INFO));
        channel.pipeline().addLast(new HttpClientCodec());
        channel.pipeline().addLast(new HttpObjectAggregator(maxMessageSize));
        channel.pipeline().addLast(new WebSocketClientProtocolHandler(WebSocketClientHandshakerFactory.newHandshaker(new URI(endpointUrl), WebSocketVersion.V13, subprotocol, true, new DefaultHttpHeaders(), this.client.getConfig().getEncodingLimits().getMaxChunkSize())));
        channel.pipeline().addLast(new WebSocketFrameAggregator(this.client.getConfig().getEncodingLimits().getMaxMessageSize()));
        channel.pipeline().addLast(new OpcClientWebSocketBinaryFrameCodec(this.client, this.handshake));
    }
}

