/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.client.transport.websocket;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientProtocolHandler;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.milo.opcua.stack.client.UaStackClient;
import org.eclipse.milo.opcua.stack.client.transport.uasc.ClientSecureChannel;
import org.eclipse.milo.opcua.stack.client.transport.uasc.UascClientAcknowledgeHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpcClientWebSocketBinaryFrameCodec
extends MessageToMessageCodec<WebSocketFrame, ByteBuf> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final UaStackClient client;
    private final CompletableFuture<ClientSecureChannel> handshake;

    public OpcClientWebSocketBinaryFrameCodec(UaStackClient client, CompletableFuture<ClientSecureChannel> handshake) {
        this.client = client;
        this.handshake = handshake;
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object event) throws Exception {
        if (event instanceof WebSocketClientProtocolHandler.ClientHandshakeStateEvent) {
            this.logger.debug("WebSocket handshake event: " + event);
            if (event == WebSocketClientProtocolHandler.ClientHandshakeStateEvent.HANDSHAKE_COMPLETE) {
                ctx.pipeline().addLast(new UascClientAcknowledgeHandler(this.client, this.handshake));
            }
        }
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, ByteBuf msg, List<Object> out) {
        out.add(new BinaryWebSocketFrame(msg.retain()));
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, WebSocketFrame msg, List<Object> out) {
        if (msg instanceof BinaryWebSocketFrame) {
            out.add(msg.content().retain());
        } else if (msg instanceof TextWebSocketFrame) {
            TextWebSocketFrame textFrame = (TextWebSocketFrame)msg;
            this.logger.error("Received WebSocket frame:\n" + textFrame.text());
            ctx.close();
        }
    }
}

