/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.client.transport.uasc;

import com.google.common.primitives.Ints;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageCodec;
import io.netty.util.AttributeKey;
import io.netty.util.Timeout;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.milo.opcua.stack.client.UaStackClient;
import org.eclipse.milo.opcua.stack.client.UaStackClientConfig;
import org.eclipse.milo.opcua.stack.client.transport.UaTransportRequest;
import org.eclipse.milo.opcua.stack.client.transport.uasc.ClientSecureChannel;
import org.eclipse.milo.opcua.stack.client.transport.uasc.UascClientMessageHandler;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.channel.ChannelParameters;
import org.eclipse.milo.opcua.stack.core.channel.EncodingLimits;
import org.eclipse.milo.opcua.stack.core.channel.SerializationQueue;
import org.eclipse.milo.opcua.stack.core.channel.headers.HeaderDecoder;
import org.eclipse.milo.opcua.stack.core.channel.messages.AcknowledgeMessage;
import org.eclipse.milo.opcua.stack.core.channel.messages.ErrorMessage;
import org.eclipse.milo.opcua.stack.core.channel.messages.HelloMessage;
import org.eclipse.milo.opcua.stack.core.channel.messages.MessageType;
import org.eclipse.milo.opcua.stack.core.channel.messages.TcpMessageDecoder;
import org.eclipse.milo.opcua.stack.core.channel.messages.TcpMessageEncoder;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UascClientAcknowledgeHandler
extends ByteToMessageCodec<UaTransportRequest>
implements HeaderDecoder {
    static final AttributeKey<List<UaTransportRequest>> KEY_AWAITING_HANDSHAKE = AttributeKey.valueOf("awaiting-handshake");
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final List<UaTransportRequest> awaitingHandshake = new CopyOnWriteArrayList<UaTransportRequest>();
    private final AtomicBoolean helloSent = new AtomicBoolean(false);
    private Timeout helloTimeout;
    private final UaStackClientConfig config;
    private final ClientSecureChannel secureChannel;
    private final UaStackClient client;
    private final CompletableFuture<ClientSecureChannel> handshakeFuture;

    public UascClientAcknowledgeHandler(UaStackClient client, CompletableFuture<ClientSecureChannel> handshakeFuture) throws UaException {
        this.client = client;
        this.handshakeFuture = handshakeFuture;
        this.config = client.getConfig();
        this.secureChannel = ClientSecureChannel.fromConfig(this.config);
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        if (this.helloSent.compareAndSet(false, true)) {
            this.sendHello(ctx);
        }
        super.channelActive(ctx);
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        if (ctx.channel().isActive() && this.helloSent.compareAndSet(false, true)) {
            this.sendHello(ctx);
        }
        super.handlerAdded(ctx);
    }

    private void sendHello(ChannelHandlerContext ctx) throws UaException {
        this.helloTimeout = this.startHelloTimeout(ctx);
        this.secureChannel.setChannel(ctx.channel());
        String endpointUrl = this.config.getEndpoint().getEndpointUrl();
        HelloMessage hello = new HelloMessage(0L, this.config.getEncodingLimits().getMaxChunkSize(), this.config.getEncodingLimits().getMaxChunkSize(), this.config.getEncodingLimits().getMaxMessageSize(), this.config.getEncodingLimits().getMaxChunkCount(), endpointUrl);
        ByteBuf messageBuffer = TcpMessageEncoder.encode(hello);
        ctx.writeAndFlush(messageBuffer, ctx.voidPromise());
        this.logger.debug("Sent Hello message on channel={}.", (Object)ctx.channel());
    }

    private Timeout startHelloTimeout(ChannelHandlerContext ctx) {
        long acknowledgeTimeoutMs = this.config.getAcknowledgeTimeout().longValue();
        return this.config.getWheelTimer().newTimeout(timeout -> {
            if (!timeout.isCancelled()) {
                this.handshakeFuture.completeExceptionally(new UaException(0x800A0000L, "timed out waiting for acknowledge"));
                ctx.close();
            }
        }, acknowledgeTimeoutMs, TimeUnit.MILLISECONDS);
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, UaTransportRequest message, ByteBuf out) {
        this.awaitingHandshake.add(message);
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf buffer, List<Object> out) throws Exception {
        int maxChunkSize = this.config.getEncodingLimits().getMaxChunkSize();
        if (buffer.readableBytes() >= 8) {
            int messageLength = this.getMessageLength(buffer, maxChunkSize);
            if (buffer.readableBytes() >= messageLength) {
                MessageType messageType = MessageType.fromMediumInt(buffer.getMediumLE(buffer.readerIndex()));
                switch (messageType) {
                    case Acknowledge: {
                        this.onAcknowledge(ctx, buffer.readSlice(messageLength));
                        break;
                    }
                    case Error: {
                        this.onError(ctx, buffer.readSlice(messageLength));
                        break;
                    }
                    default: {
                        ctx.fireChannelRead(buffer.readRetainedSlice(messageLength));
                    }
                }
            }
        }
    }

    private void onAcknowledge(ChannelHandlerContext ctx, ByteBuf buffer) {
        if (this.helloTimeout != null && !this.helloTimeout.cancel()) {
            this.helloTimeout = null;
            this.handshakeFuture.completeExceptionally(new UaException(0x800A0000L, "timed out waiting for acknowledge"));
            ctx.close();
            return;
        }
        this.logger.debug("Received Acknowledge message on channel={}.", (Object)ctx.channel());
        buffer.skipBytes(8);
        AcknowledgeMessage acknowledge = AcknowledgeMessage.decode(buffer);
        long remoteProtocolVersion = acknowledge.getProtocolVersion();
        long remoteReceiveBufferSize = acknowledge.getReceiveBufferSize();
        long remoteSendBufferSize = acknowledge.getSendBufferSize();
        long remoteMaxMessageSize = acknowledge.getMaxMessageSize();
        long remoteMaxChunkCount = acknowledge.getMaxChunkCount();
        if (0L > remoteProtocolVersion) {
            this.logger.warn("Client protocol version ({}) does not match server protocol version ({}).", (Object)0L, (Object)remoteProtocolVersion);
        }
        EncodingLimits encodingLimits = this.config.getEncodingLimits();
        long localReceiveBufferSize = Math.min(remoteSendBufferSize, (long)encodingLimits.getMaxChunkSize());
        long localSendBufferSize = Math.min(remoteReceiveBufferSize, (long)encodingLimits.getMaxChunkSize());
        long localMaxMessageSize = encodingLimits.getMaxMessageSize();
        long localMaxChunkCount = encodingLimits.getMaxChunkCount();
        ChannelParameters parameters = new ChannelParameters(Ints.saturatedCast(localMaxMessageSize), Ints.saturatedCast(localReceiveBufferSize), Ints.saturatedCast(localSendBufferSize), Ints.saturatedCast(localMaxChunkCount), Ints.saturatedCast(remoteMaxMessageSize), Ints.saturatedCast(remoteReceiveBufferSize), Ints.saturatedCast(remoteSendBufferSize), Ints.saturatedCast(remoteMaxChunkCount));
        ctx.channel().attr(KEY_AWAITING_HANDSHAKE).set(this.awaitingHandshake);
        ctx.executor().execute(() -> {
            SerializationQueue serializationQueue = new SerializationQueue(this.config.getExecutor(), parameters, this.client.getStaticSerializationContext());
            UascClientMessageHandler handler = new UascClientMessageHandler(this.config, this.secureChannel, serializationQueue, this.handshakeFuture);
            ctx.pipeline().addLast(handler);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onError(ChannelHandlerContext ctx, ByteBuf buffer) {
        try {
            ErrorMessage errorMessage = TcpMessageDecoder.decodeError(buffer);
            StatusCode statusCode = errorMessage.getError();
            this.logger.error("[remote={}] Received error message: {}", (Object)ctx.channel().remoteAddress(), (Object)errorMessage);
            this.handshakeFuture.completeExceptionally(new UaException(statusCode, errorMessage.getReason()));
        }
        catch (UaException e) {
            this.logger.error("[remote={}] An exception occurred while decoding an error message: {}", ctx.channel().remoteAddress(), e.getMessage(), e);
            this.handshakeFuture.completeExceptionally(e);
        }
        finally {
            ctx.close();
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.logger.error("[remote={}] Exception caught: {}", ctx.channel().remoteAddress(), cause.getMessage(), cause);
        this.handshakeFuture.completeExceptionally(cause);
        ctx.close();
    }
}

