/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.util;

import java.util.Optional;
import java.util.Set;
import org.eclipse.milo.opcua.sdk.core.AccessLevel;
import org.eclipse.milo.opcua.sdk.core.NumericRange;
import org.eclipse.milo.opcua.sdk.core.nodes.Node;
import org.eclipse.milo.opcua.sdk.core.nodes.VariableNode;
import org.eclipse.milo.opcua.sdk.core.nodes.VariableTypeNode;
import org.eclipse.milo.opcua.sdk.core.util.StreamUtil;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.api.AddressSpaceManager;
import org.eclipse.milo.opcua.sdk.server.nodes.AttributeContext;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaServerNode;
import org.eclipse.milo.opcua.sdk.server.util.AttributeUtil;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.DataTypeEncoding;
import org.eclipse.milo.opcua.stack.core.types.OpcUaDefaultBinaryEncoding;
import org.eclipse.milo.opcua.stack.core.types.OpcUaDefaultXmlEncoding;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;
import org.eclipse.milo.opcua.stack.core.util.ArrayUtil;
import org.jetbrains.annotations.Nullable;

public class AttributeReader {
    public static DataValue readAttribute(AttributeContext context, UaServerNode node, AttributeId attributeId, @Nullable TimestampsToReturn timestamps, @Nullable String indexRange, @Nullable QualifiedName encodingName) {
        try {
            AttributeContext internalContext = new AttributeContext(context.getServer());
            NodeClass nodeClass = node.getNodeClass();
            if (attributeId == AttributeId.Value && nodeClass == NodeClass.Variable) {
                Set<AccessLevel> accessLevels = AttributeUtil.getAccessLevels(node, internalContext);
                if (!accessLevels.contains((Object)AccessLevel.CurrentRead)) {
                    throw new UaException(2151284736L);
                }
                Set<AccessLevel> userAccessLevels = AttributeUtil.getUserAccessLevels(node, context);
                if (!userAccessLevels.contains((Object)AccessLevel.CurrentRead)) {
                    throw new UaException(2149515264L);
                }
            }
            if (encodingName != null && encodingName.isNotNull()) {
                NodeId dataTypeId;
                if (attributeId != AttributeId.Value) {
                    throw new UaException(0x80380000L);
                }
                if (node instanceof VariableNode) {
                    dataTypeId = ((VariableNode)((Object)node)).getDataType();
                } else if (node instanceof VariableTypeNode) {
                    dataTypeId = ((VariableTypeNode)((Object)node)).getDataType();
                } else {
                    throw new UaException(0x80380000L);
                }
                boolean structured = AttributeReader.isStructureSubtype(context.getServer(), dataTypeId);
                if (!structured) {
                    throw new UaException(0x80380000L);
                }
            }
            DataValue.Builder dvb = node.getAttribute(context, attributeId).copy();
            if (dvb.value.isNotNull()) {
                Object valueObject = dvb.value.getValue();
                Class<?> valueClazz = valueObject.getClass();
                if (valueClazz.isArray() && ArrayUtil.getType(valueObject) == ExtensionObject.class) {
                    Object newValue = ArrayUtil.transformArray(valueObject, xo -> AttributeReader.transcode(context, node, xo, encodingName), ExtensionObject.class);
                    dvb.setValue(new Variant(newValue));
                } else if (valueClazz == ExtensionObject.class) {
                    ExtensionObject xo2 = (ExtensionObject)valueObject;
                    ExtensionObject newValue = AttributeReader.transcode(context, node, xo2, encodingName);
                    dvb.setValue(new Variant(newValue));
                }
            }
            if (indexRange != null) {
                NumericRange range = NumericRange.parse(indexRange);
                Object valueAtRange = NumericRange.readFromValueAtRange(dvb.value, range);
                dvb.setValue(new Variant(valueAtRange));
            }
            if (timestamps != null) {
                dvb.applyTimestamps(attributeId, timestamps);
            }
            return dvb.build();
        }
        catch (UaException e) {
            return new DataValue(e.getStatusCode());
        }
    }

    private static boolean isStructureSubtype(OpcUaServer server, NodeId dataTypeId) {
        UaNode dataTypeNode = server.getAddressSpaceManager().getManagedNode(dataTypeId).orElse(null);
        if (dataTypeNode != null) {
            Optional superTypeId = dataTypeNode.getReferences().stream().filter(r -> r.isInverse() && r.getReferenceTypeId().equals(Identifiers.HasSubtype)).flatMap(r -> StreamUtil.opt2stream(r.getTargetNodeId().toNodeId(server.getNamespaceTable()))).findFirst();
            return superTypeId.map(id -> id.equals(Identifiers.Structure) || AttributeReader.isStructureSubtype(server, id)).orElse(false);
        }
        return false;
    }

    private static ExtensionObject transcode(AttributeContext context, UaServerNode node, ExtensionObject xo, QualifiedName encodingName) {
        if (xo == null || xo.isNull()) {
            return xo;
        }
        if (encodingName == null || encodingName.isNull()) {
            encodingName = OpcUaDefaultBinaryEncoding.ENCODING_NAME;
        }
        DataTypeEncoding newEncoding = OpcUaDefaultBinaryEncoding.ENCODING_NAME.equals(encodingName) ? OpcUaDefaultBinaryEncoding.getInstance() : (OpcUaDefaultXmlEncoding.ENCODING_NAME.equals(encodingName) ? OpcUaDefaultXmlEncoding.getInstance() : OpcUaDefaultBinaryEncoding.getInstance());
        NodeId newEncodingId = AttributeReader.getEncodingId(context, node, encodingName);
        if (newEncodingId != null) {
            return xo.transcode(context.getServer().getSerializationContext(), newEncodingId, newEncoding);
        }
        return xo;
    }

    @Nullable
    private static NodeId getEncodingId(AttributeContext context, UaServerNode node, QualifiedName encodingName) {
        NodeId dataTypeId;
        if (node instanceof VariableNode) {
            dataTypeId = ((VariableNode)((Object)node)).getDataType();
        } else if (node instanceof VariableTypeNode) {
            dataTypeId = ((VariableTypeNode)((Object)node)).getDataType();
        } else {
            return null;
        }
        AddressSpaceManager addressSpaceManager = context.getServer().getAddressSpaceManager();
        UaNode dataTypeNode = addressSpaceManager.getManagedNode(dataTypeId).orElse(null);
        if (dataTypeNode != null) {
            return dataTypeNode.getReferences().stream().filter(r -> r.isForward() && Identifiers.HasEncoding.equals(r.getReferenceTypeId())).flatMap(r -> StreamUtil.opt2stream(addressSpaceManager.getManagedNode(r.getTargetNodeId()))).filter(n -> encodingName.equals(n.getBrowseName())).map(Node::getNodeId).findFirst().orElse(null);
        }
        return null;
    }
}

