/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.subscriptions;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.netty.util.AttributeKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.milo.opcua.sdk.core.AccessLevel;
import org.eclipse.milo.opcua.sdk.core.NumericRange;
import org.eclipse.milo.opcua.sdk.core.Reference;
import org.eclipse.milo.opcua.sdk.core.util.StreamUtil;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.Session;
import org.eclipse.milo.opcua.sdk.server.api.DataItem;
import org.eclipse.milo.opcua.sdk.server.api.EventItem;
import org.eclipse.milo.opcua.sdk.server.api.MonitoredItem;
import org.eclipse.milo.opcua.sdk.server.api.services.AttributeServices;
import org.eclipse.milo.opcua.sdk.server.items.BaseMonitoredItem;
import org.eclipse.milo.opcua.sdk.server.items.MonitoredDataItem;
import org.eclipse.milo.opcua.sdk.server.items.MonitoredEventItem;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.subscriptions.PublishQueue;
import org.eclipse.milo.opcua.sdk.server.subscriptions.Subscription;
import org.eclipse.milo.opcua.sdk.server.subscriptions.SubscriptionCreatedEvent;
import org.eclipse.milo.opcua.sdk.server.subscriptions.SubscriptionDeletedEvent;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.DeadbandType;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MonitoringMode;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;
import org.eclipse.milo.opcua.stack.core.types.structured.CreateMonitoredItemsRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.CreateMonitoredItemsResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.CreateSubscriptionRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.CreateSubscriptionResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.DataChangeFilter;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteMonitoredItemsRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteMonitoredItemsResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteSubscriptionsRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteSubscriptionsResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.EventFilter;
import org.eclipse.milo.opcua.stack.core.types.structured.ModifyMonitoredItemsRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.ModifyMonitoredItemsResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.ModifySubscriptionRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.ModifySubscriptionResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoredItemCreateRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoredItemCreateResult;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoredItemModifyRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoredItemModifyResult;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoringFilter;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoringParameters;
import org.eclipse.milo.opcua.stack.core.types.structured.NotificationMessage;
import org.eclipse.milo.opcua.stack.core.types.structured.PublishRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadValueId;
import org.eclipse.milo.opcua.stack.core.types.structured.RepublishRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.RepublishResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.SetMonitoringModeRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.SetMonitoringModeResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.SetPublishingModeRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.SetPublishingModeResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.SetTriggeringRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.SetTriggeringResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.SubscriptionAcknowledgement;
import org.eclipse.milo.opcua.stack.core.util.ConversionUtil;
import org.eclipse.milo.opcua.stack.server.services.ServiceRequest;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionManager {
    static final AttributeKey<StatusCode[]> KEY_ACK_RESULTS = AttributeKey.valueOf("ackResults");
    private static final QualifiedName DEFAULT_BINARY_ENCODING = new QualifiedName(0, "DefaultBinary");
    private static final QualifiedName DEFAULT_XML_ENCODING = new QualifiedName(0, "DefaultXML");
    private static final AtomicLong SUBSCRIPTION_IDS = new AtomicLong(0L);
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final PublishQueue publishQueue = new PublishQueue();
    private final Map<UInteger, Subscription> subscriptions = Maps.newConcurrentMap();
    private final List<Subscription> transferred = Lists.newCopyOnWriteArrayList();
    private final Session session;
    private final OpcUaServer server;

    private static UInteger nextSubscriptionId() {
        return Unsigned.uint(SUBSCRIPTION_IDS.incrementAndGet());
    }

    public SubscriptionManager(Session session, OpcUaServer server) {
        this.session = session;
        this.server = server;
    }

    public Session getSession() {
        return this.session;
    }

    public PublishQueue getPublishQueue() {
        return this.publishQueue;
    }

    public OpcUaServer getServer() {
        return this.server;
    }

    @Nullable
    public Subscription getSubscription(UInteger subscriptionId) {
        return this.subscriptions.get(subscriptionId);
    }

    public List<Subscription> getSubscriptions() {
        return new ArrayList<Subscription>(this.subscriptions.values());
    }

    public void createSubscription(ServiceRequest service) {
        CreateSubscriptionRequest request = (CreateSubscriptionRequest)service.getRequest();
        UInteger subscriptionId = SubscriptionManager.nextSubscriptionId();
        Subscription subscription = new Subscription(this, subscriptionId, request.getRequestedPublishingInterval(), request.getRequestedMaxKeepAliveCount().longValue(), request.getRequestedLifetimeCount().longValue(), request.getMaxNotificationsPerPublish().longValue(), request.getPublishingEnabled(), request.getPriority().intValue());
        this.subscriptions.put(subscriptionId, subscription);
        this.server.getSubscriptions().put(subscriptionId, subscription);
        this.server.getDiagnosticsSummary().getCumulatedSubscriptionCount().increment();
        this.server.getEventBus().post(new SubscriptionCreatedEvent(subscription));
        subscription.setStateListener((s, ps, cs) -> {
            if (cs == Subscription.State.Closing) {
                this.subscriptions.remove(s.getId());
                this.server.getSubscriptions().remove(s.getId());
                this.server.getEventBus().post(new SubscriptionDeletedEvent(s));
                SubscriptionManager.byMonitoredItemType(s.getMonitoredItems().values(), dataItems -> this.server.getAddressSpaceManager().onDataItemsDeleted((List<DataItem>)dataItems), eventItems -> this.server.getAddressSpaceManager().onEventItemsDeleted((List<EventItem>)eventItems));
                s.getMonitoredItems().clear();
            }
        });
        subscription.startPublishingTimer();
        ResponseHeader header = service.createResponseHeader();
        CreateSubscriptionResponse response = new CreateSubscriptionResponse(header, subscriptionId, subscription.getPublishingInterval(), Unsigned.uint(subscription.getLifetimeCount()), Unsigned.uint(subscription.getMaxKeepAliveCount()));
        service.setResponse(response);
    }

    public void modifySubscription(ServiceRequest service) throws UaException {
        ModifySubscriptionRequest request = (ModifySubscriptionRequest)service.getRequest();
        UInteger subscriptionId = request.getSubscriptionId();
        Subscription subscription = this.subscriptions.get(subscriptionId);
        if (subscription == null) {
            throw new UaException(0x80280000L);
        }
        subscription.modifySubscription(request);
        ResponseHeader header = service.createResponseHeader();
        ModifySubscriptionResponse response = new ModifySubscriptionResponse(header, subscription.getPublishingInterval(), Unsigned.uint(subscription.getLifetimeCount()), Unsigned.uint(subscription.getMaxKeepAliveCount()));
        service.setResponse(response);
    }

    public void deleteSubscription(ServiceRequest service) throws UaException {
        DeleteSubscriptionsRequest request = (DeleteSubscriptionsRequest)service.getRequest();
        List<UInteger> subscriptionIds = ConversionUtil.l(request.getSubscriptionIds());
        if (subscriptionIds.isEmpty()) {
            throw new UaException(0x800F0000L);
        }
        StatusCode[] results = new StatusCode[subscriptionIds.size()];
        for (int i = 0; i < subscriptionIds.size(); ++i) {
            UInteger subscriptionId = subscriptionIds.get(i);
            Subscription subscription = this.subscriptions.remove(subscriptionId);
            if (subscription != null) {
                this.server.getSubscriptions().remove(subscription.getId());
                this.server.getEventBus().post(new SubscriptionDeletedEvent(subscription));
                List<BaseMonitoredItem<?>> deletedItems = subscription.deleteSubscription();
                SubscriptionManager.byMonitoredItemType(deletedItems, dataItems -> this.server.getAddressSpaceManager().onDataItemsDeleted((List<DataItem>)dataItems), eventItems -> this.server.getAddressSpaceManager().onEventItemsDeleted((List<EventItem>)eventItems));
                results[i] = StatusCode.GOOD;
                continue;
            }
            results[i] = new StatusCode(0x80280000L);
        }
        ResponseHeader header = service.createResponseHeader();
        DeleteSubscriptionsResponse response = new DeleteSubscriptionsResponse(header, results, new DiagnosticInfo[0]);
        service.setResponse(response);
        while (this.subscriptions.isEmpty() && this.publishQueue.isNotEmpty()) {
            ServiceRequest publishService = this.publishQueue.poll();
            if (publishService == null) continue;
            publishService.setServiceFault(2155413504L);
        }
    }

    public void setPublishingMode(ServiceRequest service) {
        SetPublishingModeRequest request = (SetPublishingModeRequest)service.getRequest();
        List<UInteger> subscriptionIds = ConversionUtil.l(request.getSubscriptionIds());
        StatusCode[] results = new StatusCode[subscriptionIds.size()];
        for (int i = 0; i < subscriptionIds.size(); ++i) {
            Subscription subscription = this.subscriptions.get(subscriptionIds.get(i));
            if (subscription == null) {
                results[i] = new StatusCode(0x80280000L);
                continue;
            }
            subscription.setPublishingMode(request);
            results[i] = StatusCode.GOOD;
        }
        ResponseHeader header = service.createResponseHeader();
        SetPublishingModeResponse response = new SetPublishingModeResponse(header, results, new DiagnosticInfo[0]);
        service.setResponse(response);
    }

    public void createMonitoredItems(ServiceRequest service) throws UaException {
        CreateMonitoredItemsRequest request = (CreateMonitoredItemsRequest)service.getRequest();
        UInteger subscriptionId = request.getSubscriptionId();
        Subscription subscription = this.subscriptions.get(subscriptionId);
        TimestampsToReturn timestamps = request.getTimestampsToReturn();
        List<MonitoredItemCreateRequest> itemsToCreate = ConversionUtil.l(request.getItemsToCreate());
        if (subscription == null) {
            throw new UaException(0x80280000L);
        }
        if (timestamps == null) {
            throw new UaException(2150301696L);
        }
        if (itemsToCreate.isEmpty()) {
            throw new UaException(0x800F0000L);
        }
        List<NodeId> distinctNodeIds = itemsToCreate.stream().map(item -> item.getItemToMonitor().getNodeId()).distinct().collect(Collectors.toList());
        CompletableFuture<Map<NodeId, AttributeGroup>> attributesFuture = this.readMonitoringAttributes(distinctNodeIds);
        attributesFuture.thenAccept(attributeGroups -> {
            MonitoredItemCreateResult[] createResults = new MonitoredItemCreateResult[itemsToCreate.size()];
            ArrayList monitoredItems = new ArrayList();
            for (int i = 0; i < itemsToCreate.size(); ++i) {
                MonitoredItemCreateRequest createRequest = (MonitoredItemCreateRequest)itemsToCreate.get(i);
                try {
                    BaseMonitoredItem<?> monitoredItem = this.createMonitoredItem(createRequest, subscription, timestamps, (Map<NodeId, AttributeGroup>)attributeGroups);
                    monitoredItems.add(monitoredItem);
                    createResults[i] = new MonitoredItemCreateResult(StatusCode.GOOD, monitoredItem.getId(), monitoredItem.getSamplingInterval(), Unsigned.uint(monitoredItem.getQueueSize()), monitoredItem.getFilterResult());
                    continue;
                }
                catch (UaException e) {
                    createResults[i] = new MonitoredItemCreateResult(e.getStatusCode(), UInteger.MIN, 0.0, UInteger.MIN, null);
                }
            }
            subscription.addMonitoredItems(monitoredItems);
            SubscriptionManager.byMonitoredItemType(monitoredItems, dataItems -> this.server.getAddressSpaceManager().onDataItemsCreated((List<DataItem>)dataItems), eventItems -> this.server.getAddressSpaceManager().onEventItemsCreated((List<EventItem>)eventItems));
            ResponseHeader header = service.createResponseHeader();
            CreateMonitoredItemsResponse response = new CreateMonitoredItemsResponse(header, createResults, new DiagnosticInfo[0]);
            service.setResponse(response);
        });
    }

    private BaseMonitoredItem<?> createMonitoredItem(MonitoredItemCreateRequest request, Subscription subscription, TimestampsToReturn timestamps, Map<NodeId, AttributeGroup> attributeGroups) throws UaException {
        Double minimumSamplingInterval;
        AttributeGroup attributeGroup;
        UInteger attributeId;
        block22: {
            String indexRange;
            NodeId nodeId = request.getItemToMonitor().getNodeId();
            attributeId = request.getItemToMonitor().getAttributeId();
            QualifiedName dataEncoding = request.getItemToMonitor().getDataEncoding();
            if (!AttributeId.isValid(attributeId)) {
                throw new UaException(2150957056L);
            }
            if (dataEncoding.isNotNull()) {
                if (!AttributeId.Value.isEqual(attributeId)) {
                    throw new UaException(0x80380000L);
                }
                if (!dataEncoding.equals(DEFAULT_BINARY_ENCODING) && !dataEncoding.equals(DEFAULT_XML_ENCODING)) {
                    throw new UaException(2151219200L);
                }
            }
            attributeGroup = attributeGroups.get(nodeId);
            if (attributeId.equals(AttributeId.EventNotifier.uid())) {
                UByte eventNotifier = attributeGroup.getEventNotifier();
                if (eventNotifier == null || (eventNotifier.intValue() & 1) == 0) {
                    throw new UaException(2150957056L);
                }
                Object filterObject = request.getRequestedParameters().getFilter().decode(this.server.getSerializationContext());
                MonitoringFilter filter = this.validateEventItemFilter(filterObject, attributeGroup);
                UInteger requestedQueueSize = request.getRequestedParameters().getQueueSize();
                AtomicReference<UInteger> revisedQueueSize = new AtomicReference<UInteger>(requestedQueueSize);
                try {
                    this.server.getAddressSpaceManager().onCreateEventItem(request.getItemToMonitor(), requestedQueueSize, revisedQueueSize::set);
                }
                catch (Throwable t) {
                    throw new UaException(0x80020000L, t);
                }
                MonitoredEventItem monitoredEventItem = new MonitoredEventItem(this.server, this.session, Unsigned.uint(subscription.nextItemId()), subscription.getId(), request.getItemToMonitor(), request.getMonitoringMode(), timestamps, request.getRequestedParameters().getClientHandle(), 0.0, revisedQueueSize.get(), request.getRequestedParameters().getDiscardOldest());
                monitoredEventItem.installFilter(filter);
                return monitoredEventItem;
            }
            if (attributeId.equals(AttributeId.Value.uid())) {
                UByte userAccessLevel;
                UByte accessLevel = attributeGroup.getAccessLevel();
                if (accessLevel == null) {
                    accessLevel = Unsigned.ubyte(0);
                }
                if ((userAccessLevel = attributeGroup.getUserAccessLevel()) == null) {
                    userAccessLevel = Unsigned.ubyte(0);
                }
                EnumSet<AccessLevel> accessLevels = AccessLevel.fromValue(accessLevel);
                EnumSet<AccessLevel> userAccessLevels = AccessLevel.fromValue(userAccessLevel);
                if (!accessLevels.contains((Object)AccessLevel.CurrentRead)) {
                    throw new UaException(2151284736L);
                }
                if (!userAccessLevels.contains((Object)AccessLevel.CurrentRead)) {
                    throw new UaException(2149515264L);
                }
            }
            if ((indexRange = request.getItemToMonitor().getIndexRange()) != null) {
                NumericRange.parse(indexRange);
            }
            minimumSamplingInterval = -1.0;
            try {
                minimumSamplingInterval = attributeGroup.getMinimumSamplingInterval();
                if (minimumSamplingInterval == null) {
                    minimumSamplingInterval = this.server.getConfig().getLimits().getMinSupportedSampleRate();
                }
            }
            catch (UaException e) {
                if (e.getStatusCode().getValue() == 2150957056L) break block22;
                throw e;
            }
        }
        MonitoringFilter filter = MonitoredDataItem.DEFAULT_FILTER;
        try {
            ExtensionObject filterXo = request.getRequestedParameters().getFilter();
            if (filterXo != null && !filterXo.isNull()) {
                Object filterObject = filterXo.decode(this.server.getSerializationContext());
                filter = this.validateDataItemFilter(filterObject, attributeId, attributeGroup);
            }
        }
        catch (UaSerializationException e) {
            this.logger.debug("error decoding MonitoringFilter", e);
            throw new UaException(2151874560L, (Throwable)e);
        }
        double requestedSamplingInterval = this.getSamplingInterval(subscription, minimumSamplingInterval, request.getRequestedParameters().getSamplingInterval());
        UInteger requestedQueueSize = request.getRequestedParameters().getQueueSize();
        AtomicReference<Double> revisedSamplingInterval = new AtomicReference<Double>(requestedSamplingInterval);
        AtomicReference<UInteger> revisedQueueSize = new AtomicReference<UInteger>(requestedQueueSize);
        try {
            this.server.getAddressSpaceManager().onCreateDataItem(request.getItemToMonitor(), requestedSamplingInterval, requestedQueueSize, (rsi, rqs) -> {
                revisedSamplingInterval.set((Double)rsi);
                revisedQueueSize.set((UInteger)rqs);
            });
        }
        catch (Throwable t) {
            throw new UaException(0x80020000L, t);
        }
        MonitoredDataItem monitoredDataItem = new MonitoredDataItem(this.server, this.session, Unsigned.uint(subscription.nextItemId()), subscription.getId(), request.getItemToMonitor(), request.getMonitoringMode(), timestamps, request.getRequestedParameters().getClientHandle(), revisedSamplingInterval.get(), revisedQueueSize.get(), request.getRequestedParameters().getDiscardOldest());
        monitoredDataItem.installFilter(filter);
        return monitoredDataItem;
    }

    private MonitoringFilter validateDataItemFilter(Object filterObject, UInteger attributeId, AttributeGroup attributeGroup) throws UaException {
        if (filterObject instanceof MonitoringFilter) {
            if (filterObject instanceof DataChangeFilter) {
                DataChangeFilter filter = (DataChangeFilter)filterObject;
                DeadbandType deadbandType = DeadbandType.from(filter.getDeadbandType().intValue());
                if (deadbandType == null) {
                    throw new UaException(0x808E0000L);
                }
                if (deadbandType == DeadbandType.Percent) {
                    throw new UaException(0x80440000L);
                }
                if (deadbandType == DeadbandType.Absolute && !AttributeId.Value.isEqual(attributeId)) {
                    throw new UaException(2152005632L);
                }
                if (deadbandType != DeadbandType.None) {
                    NodeId dataTypeId = null;
                    try {
                        dataTypeId = attributeGroup.getDataType();
                    }
                    catch (UaException uaException) {
                        // empty catch block
                    }
                    if (dataTypeId == null) {
                        dataTypeId = NodeId.NULL_VALUE;
                    }
                    if (!Identifiers.Number.equals(dataTypeId) && !SubscriptionManager.subtypeOf(this.server, dataTypeId, Identifiers.Number)) {
                        throw new UaException(2152005632L);
                    }
                }
                return filter;
            }
            if (filterObject instanceof EventFilter) {
                throw new UaException(2152005632L);
            }
            throw new UaException(0x80440000L);
        }
        throw new UaException(2151874560L);
    }

    private MonitoringFilter validateEventItemFilter(Object filterObject, AttributeGroup attributeGroup) throws UaException {
        if (filterObject instanceof MonitoringFilter) {
            if (!(filterObject instanceof EventFilter)) {
                throw new UaException(2152005632L);
            }
            return (EventFilter)filterObject;
        }
        throw new UaException(2151874560L);
    }

    public void modifyMonitoredItems(ServiceRequest service) throws UaException {
        ModifyMonitoredItemsRequest request = (ModifyMonitoredItemsRequest)service.getRequest();
        UInteger subscriptionId = request.getSubscriptionId();
        Subscription subscription = this.subscriptions.get(subscriptionId);
        TimestampsToReturn timestamps = request.getTimestampsToReturn();
        List<MonitoredItemModifyRequest> itemsToModify = ConversionUtil.l(request.getItemsToModify());
        if (subscription == null) {
            throw new UaException(0x80280000L);
        }
        if (timestamps == null) {
            throw new UaException(2150301696L);
        }
        if (itemsToModify.isEmpty()) {
            throw new UaException(0x800F0000L);
        }
        List<NodeId> distinctNodeIds = itemsToModify.stream().map(item -> {
            UInteger itemId = item.getMonitoredItemId();
            BaseMonitoredItem<?> monitoredItem = subscription.getMonitoredItems().get(itemId);
            return monitoredItem != null ? monitoredItem.getReadValueId().getNodeId() : NodeId.NULL_VALUE;
        }).filter(NodeId::isNotNull).distinct().collect(Collectors.toList());
        CompletableFuture<Map<NodeId, AttributeGroup>> attributesFuture = this.readMonitoringAttributes(distinctNodeIds);
        attributesFuture.thenAccept(attributeGroups -> {
            MonitoredItemModifyResult[] modifyResults = new MonitoredItemModifyResult[itemsToModify.size()];
            ArrayList monitoredItems = new ArrayList();
            for (int i = 0; i < itemsToModify.size(); ++i) {
                MonitoredItemModifyRequest modifyRequest = (MonitoredItemModifyRequest)itemsToModify.get(i);
                try {
                    BaseMonitoredItem<?> monitoredItem = this.modifyMonitoredItem(modifyRequest, timestamps, subscription, (Map<NodeId, AttributeGroup>)attributeGroups);
                    monitoredItems.add(monitoredItem);
                    modifyResults[i] = new MonitoredItemModifyResult(StatusCode.GOOD, monitoredItem.getSamplingInterval(), Unsigned.uint(monitoredItem.getQueueSize()), monitoredItem.getFilterResult());
                    continue;
                }
                catch (UaException e) {
                    modifyResults[i] = new MonitoredItemModifyResult(e.getStatusCode(), 0.0, UInteger.MIN, null);
                }
            }
            subscription.resetLifetimeCounter();
            SubscriptionManager.byMonitoredItemType(monitoredItems, dataItems -> this.server.getAddressSpaceManager().onDataItemsModified((List<DataItem>)dataItems), eventItems -> this.server.getAddressSpaceManager().onEventItemsModified((List<EventItem>)eventItems));
            ResponseHeader header = service.createResponseHeader();
            ModifyMonitoredItemsResponse response = new ModifyMonitoredItemsResponse(header, modifyResults, new DiagnosticInfo[0]);
            service.setResponse(response);
        });
    }

    private BaseMonitoredItem<?> modifyMonitoredItem(MonitoredItemModifyRequest request, TimestampsToReturn timestamps, Subscription subscription, Map<NodeId, AttributeGroup> attributeGroups) throws UaException {
        UInteger itemId = request.getMonitoredItemId();
        MonitoringParameters parameters = request.getRequestedParameters();
        BaseMonitoredItem<?> monitoredItem = subscription.getMonitoredItems().get(itemId);
        if (monitoredItem == null) {
            throw new UaException(2151809024L);
        }
        NodeId nodeId = monitoredItem.getReadValueId().getNodeId();
        UInteger attributeId = monitoredItem.getReadValueId().getAttributeId();
        AttributeGroup attributeGroup = attributeGroups.get(nodeId);
        if (attributeId.equals(AttributeId.EventNotifier.uid())) {
            Object filterObject = request.getRequestedParameters().getFilter().decode(this.server.getSerializationContext());
            MonitoringFilter filter = this.validateEventItemFilter(filterObject, attributeGroup);
            UInteger requestedQueueSize = parameters.getQueueSize();
            AtomicReference<UInteger> revisedQueueSize = new AtomicReference<UInteger>(requestedQueueSize);
            try {
                this.server.getAddressSpaceManager().onModifyEventItem(monitoredItem.getReadValueId(), requestedQueueSize, revisedQueueSize::set);
            }
            catch (Throwable t) {
                throw new UaException(0x80020000L, t);
            }
            monitoredItem.modify(timestamps, parameters.getClientHandle(), monitoredItem.getSamplingInterval(), filter, revisedQueueSize.get(), parameters.getDiscardOldest());
        } else {
            Double minimumSamplingInterval;
            MonitoringFilter filter;
            block13: {
                filter = MonitoredDataItem.DEFAULT_FILTER;
                try {
                    ExtensionObject filterXo = request.getRequestedParameters().getFilter();
                    if (filterXo != null && !filterXo.isNull()) {
                        Object filterObject = filterXo.decode(this.server.getSerializationContext());
                        filter = this.validateDataItemFilter(filterObject, attributeId, attributeGroup);
                    }
                }
                catch (UaSerializationException e) {
                    this.logger.debug("error decoding MonitoringFilter", e);
                    throw new UaException(2151874560L, (Throwable)e);
                }
                minimumSamplingInterval = -1.0;
                try {
                    minimumSamplingInterval = attributeGroup.getMinimumSamplingInterval();
                    if (minimumSamplingInterval == null) {
                        minimumSamplingInterval = this.server.getConfig().getLimits().getMinSupportedSampleRate();
                    }
                }
                catch (UaException e) {
                    long statusCodeValue = e.getStatusCode().getValue();
                    if (statusCodeValue == 2150957056L || statusCodeValue == 2150891520L) break block13;
                    throw e;
                }
            }
            double requestedSamplingInterval = this.getSamplingInterval(subscription, minimumSamplingInterval, request.getRequestedParameters().getSamplingInterval());
            UInteger requestedQueueSize = parameters.getQueueSize();
            AtomicReference<Double> revisedSamplingInterval = new AtomicReference<Double>(requestedSamplingInterval);
            AtomicReference<UInteger> revisedQueueSize = new AtomicReference<UInteger>(requestedQueueSize);
            try {
                this.server.getAddressSpaceManager().onModifyDataItem(monitoredItem.getReadValueId(), requestedSamplingInterval, requestedQueueSize, (rsi, rqs) -> {
                    revisedSamplingInterval.set((Double)rsi);
                    revisedQueueSize.set((UInteger)rqs);
                });
            }
            catch (Throwable t) {
                throw new UaException(0x80020000L, t);
            }
            monitoredItem.modify(timestamps, parameters.getClientHandle(), revisedSamplingInterval.get(), filter, revisedQueueSize.get(), parameters.getDiscardOldest());
        }
        return monitoredItem;
    }

    private double getSamplingInterval(Subscription subscription, Double minimumSamplingInterval, Double requestedSamplingInterval) {
        double samplingInterval = requestedSamplingInterval;
        if (requestedSamplingInterval < 0.0) {
            samplingInterval = subscription.getPublishingInterval();
        } else if (requestedSamplingInterval == 0.0) {
            if (minimumSamplingInterval < 0.0) {
                samplingInterval = subscription.getPublishingInterval();
            } else if (minimumSamplingInterval == 0.0) {
                samplingInterval = minimumSamplingInterval;
            } else if (minimumSamplingInterval > 0.0) {
                samplingInterval = minimumSamplingInterval;
            }
        } else if (requestedSamplingInterval < minimumSamplingInterval) {
            samplingInterval = minimumSamplingInterval;
        }
        double minSupportedSampleRate = this.server.getConfig().getLimits().getMinSupportedSampleRate();
        double maxSupportedSampleRate = this.server.getConfig().getLimits().getMaxSupportedSampleRate();
        if (samplingInterval < minSupportedSampleRate) {
            samplingInterval = minSupportedSampleRate;
        }
        if (samplingInterval > maxSupportedSampleRate) {
            samplingInterval = maxSupportedSampleRate;
        }
        return samplingInterval;
    }

    private CompletableFuture<Map<NodeId, AttributeGroup>> readMonitoringAttributes(List<NodeId> nodeIds) {
        List<ReadValueId> attributesToRead = nodeIds.stream().flatMap(nodeId -> {
            Function<AttributeId, ReadValueId> f = id -> new ReadValueId((NodeId)nodeId, id.uid(), null, QualifiedName.NULL_VALUE);
            return Stream.of(f.apply(AttributeId.AccessLevel), f.apply(AttributeId.UserAccessLevel), f.apply(AttributeId.EventNotifier), f.apply(AttributeId.MinimumSamplingInterval), f.apply(AttributeId.DataType));
        }).collect(Collectors.toList());
        AttributeServices.ReadContext context = new AttributeServices.ReadContext(this.server, this.session);
        this.server.getAddressSpaceManager().read(context, 0.0, TimestampsToReturn.Neither, attributesToRead);
        return context.getFuture().thenApply(attributeValues -> {
            HashMap monitoringAttributes = new HashMap();
            int nodeIdx = 0;
            int attrIdx = 0;
            while (nodeIdx < nodeIds.size()) {
                monitoringAttributes.put(nodeIds.get(nodeIdx), new AttributeGroup((DataValue)attributeValues.get(attrIdx), (DataValue)attributeValues.get(attrIdx + 1), (DataValue)attributeValues.get(attrIdx + 2), (DataValue)attributeValues.get(attrIdx + 3), (DataValue)attributeValues.get(attrIdx + 4)));
                ++nodeIdx;
                attrIdx += 5;
            }
            return monitoringAttributes;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteMonitoredItems(ServiceRequest service) throws UaException {
        DeleteMonitoredItemsRequest request = (DeleteMonitoredItemsRequest)service.getRequest();
        UInteger subscriptionId = request.getSubscriptionId();
        Subscription subscription = this.subscriptions.get(subscriptionId);
        List<UInteger> itemsToDelete = ConversionUtil.l(request.getMonitoredItemIds());
        if (subscription == null) {
            throw new UaException(0x80280000L);
        }
        if (itemsToDelete.isEmpty()) {
            throw new UaException(0x800F0000L);
        }
        StatusCode[] deleteResults = new StatusCode[itemsToDelete.size()];
        ArrayList<BaseMonitoredItem<?>> deletedItems = Lists.newArrayListWithCapacity(itemsToDelete.size());
        Subscription subscription2 = subscription;
        synchronized (subscription2) {
            for (int i = 0; i < itemsToDelete.size(); ++i) {
                UInteger itemId = itemsToDelete.get(i);
                BaseMonitoredItem<?> item = subscription.getMonitoredItems().get(itemId);
                if (item == null) {
                    deleteResults[i] = new StatusCode(2151809024L);
                    continue;
                }
                deletedItems.add(item);
                deleteResults[i] = StatusCode.GOOD;
            }
            subscription.removeMonitoredItems(deletedItems);
        }
        SubscriptionManager.byMonitoredItemType(deletedItems, dataItems -> this.server.getAddressSpaceManager().onDataItemsDeleted((List<DataItem>)dataItems), eventItems -> this.server.getAddressSpaceManager().onEventItemsDeleted((List<EventItem>)eventItems));
        ResponseHeader header = service.createResponseHeader();
        DeleteMonitoredItemsResponse response = new DeleteMonitoredItemsResponse(header, deleteResults, new DiagnosticInfo[0]);
        service.setResponse(response);
    }

    public void setMonitoringMode(ServiceRequest service) {
        SetMonitoringModeRequest request = (SetMonitoringModeRequest)service.getRequest();
        UInteger subscriptionId = request.getSubscriptionId();
        try {
            Subscription subscription = this.subscriptions.get(subscriptionId);
            List<UInteger> itemsToModify = ConversionUtil.l(request.getMonitoredItemIds());
            if (subscription == null) {
                throw new UaException(0x80280000L);
            }
            if (itemsToModify.isEmpty()) {
                throw new UaException(0x800F0000L);
            }
            MonitoringMode monitoringMode = request.getMonitoringMode();
            StatusCode[] results = new StatusCode[itemsToModify.size()];
            ArrayList<MonitoredItem> modified = Lists.newArrayListWithCapacity(itemsToModify.size());
            for (int i = 0; i < itemsToModify.size(); ++i) {
                UInteger itemId = itemsToModify.get(i);
                BaseMonitoredItem<?> item = subscription.getMonitoredItems().get(itemId);
                if (item != null) {
                    item.setMonitoringMode(monitoringMode);
                    modified.add(item);
                    results[i] = StatusCode.GOOD;
                    continue;
                }
                results[i] = new StatusCode(2151809024L);
            }
            this.server.getAddressSpaceManager().onMonitoringModeChanged(modified);
            ResponseHeader header = service.createResponseHeader();
            SetMonitoringModeResponse response = new SetMonitoringModeResponse(header, results, new DiagnosticInfo[0]);
            service.setResponse(response);
        }
        catch (UaException e) {
            service.setServiceFault(e);
        }
    }

    public void publish(ServiceRequest service) {
        PublishRequest request = (PublishRequest)service.getRequest();
        SubscriptionAcknowledgement[] acknowledgements = request.getSubscriptionAcknowledgements();
        if (acknowledgements != null) {
            StatusCode[] results = new StatusCode[acknowledgements.length];
            for (int i = 0; i < acknowledgements.length; ++i) {
                SubscriptionAcknowledgement acknowledgement = acknowledgements[i];
                UInteger sequenceNumber = acknowledgement.getSequenceNumber();
                UInteger subscriptionId = acknowledgement.getSubscriptionId();
                Subscription subscription = this.subscriptions.get(subscriptionId);
                if (subscription == null) {
                    this.logger.debug("Can't acknowledge sequenceNumber={} on subscriptionId={}; id not valid for this session", (Object)sequenceNumber, (Object)subscriptionId);
                    results[i] = new StatusCode(0x80280000L);
                    continue;
                }
                this.logger.debug("Acknowledging sequenceNumber={} on subscriptionId={}", (Object)sequenceNumber, (Object)subscriptionId);
                results[i] = subscription.acknowledge(sequenceNumber);
            }
            service.attr(KEY_ACK_RESULTS).set(results);
        }
        if (!this.transferred.isEmpty()) {
            Subscription subscription = this.transferred.remove(0);
            subscription.returnStatusChangeNotification(service, new StatusCode(0x2D0000L));
            return;
        }
        if (this.subscriptions.isEmpty() && this.publishQueue.isWaitListEmpty()) {
            service.setServiceFault(2155413504L);
            return;
        }
        this.publishQueue.addRequest(service);
    }

    public void republish(ServiceRequest service) {
        RepublishRequest request = (RepublishRequest)service.getRequest();
        if (this.subscriptions.isEmpty()) {
            service.setServiceFault(0x80280000L);
            return;
        }
        UInteger subscriptionId = request.getSubscriptionId();
        Subscription subscription = this.subscriptions.get(subscriptionId);
        if (subscription == null) {
            service.setServiceFault(0x80280000L);
            return;
        }
        UInteger sequenceNumber = request.getRetransmitSequenceNumber();
        NotificationMessage notificationMessage = subscription.republish(sequenceNumber);
        if (notificationMessage == null) {
            service.setServiceFault(2155544576L);
            return;
        }
        ResponseHeader header = service.createResponseHeader();
        RepublishResponse response = new RepublishResponse(header, notificationMessage);
        service.setResponse(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTriggering(ServiceRequest service) {
        StatusCode[] addResults;
        StatusCode[] removeResults;
        SetTriggeringRequest request = (SetTriggeringRequest)service.getRequest();
        UInteger subscriptionId = request.getSubscriptionId();
        Subscription subscription = this.subscriptions.get(subscriptionId);
        if (subscription == null) {
            service.setServiceFault(0x80280000L);
            return;
        }
        UInteger triggerId = request.getTriggeringItemId();
        List<UInteger> linksToAdd = ConversionUtil.l(request.getLinksToAdd());
        List<UInteger> linksToRemove = ConversionUtil.l(request.getLinksToRemove());
        if (linksToAdd.isEmpty() && linksToRemove.isEmpty()) {
            service.setServiceFault(0x800F0000L);
            return;
        }
        Subscription subscription2 = subscription;
        synchronized (subscription2) {
            Map<UInteger, BaseMonitoredItem<?>> itemsById = subscription.getMonitoredItems();
            BaseMonitoredItem<?> triggerItem = itemsById.get(triggerId);
            if (triggerItem == null) {
                service.setServiceFault(2151809024L);
                return;
            }
            removeResults = (StatusCode[])linksToRemove.stream().map(linkedItemId -> {
                BaseMonitoredItem item = (BaseMonitoredItem)itemsById.get(linkedItemId);
                if (item != null) {
                    if (triggerItem.getTriggeredItems().remove(linkedItemId) != null) {
                        return StatusCode.GOOD;
                    }
                    return new StatusCode(2151809024L);
                }
                return new StatusCode(2151809024L);
            }).toArray(StatusCode[]::new);
            addResults = (StatusCode[])linksToAdd.stream().map(linkedItemId -> {
                BaseMonitoredItem linkedItem = (BaseMonitoredItem)itemsById.get(linkedItemId);
                if (linkedItem != null) {
                    triggerItem.getTriggeredItems().put((UInteger)linkedItemId, linkedItem);
                    return StatusCode.GOOD;
                }
                return new StatusCode(2151809024L);
            }).toArray(StatusCode[]::new);
        }
        SetTriggeringResponse response = new SetTriggeringResponse(service.createResponseHeader(), addResults, new DiagnosticInfo[0], removeResults, new DiagnosticInfo[0]);
        service.setResponse(response);
    }

    public void sessionClosed(boolean deleteSubscriptions) {
        Iterator<Subscription> iterator = this.subscriptions.values().iterator();
        while (iterator.hasNext()) {
            Subscription s = iterator.next();
            s.setStateListener(null);
            if (deleteSubscriptions) {
                this.server.getSubscriptions().remove(s.getId());
                this.server.getEventBus().post(new SubscriptionDeletedEvent(s));
                List<BaseMonitoredItem<?>> deletedItems = s.deleteSubscription();
                SubscriptionManager.byMonitoredItemType(deletedItems, dataItems -> this.server.getAddressSpaceManager().onDataItemsDeleted((List<DataItem>)dataItems), eventItems -> this.server.getAddressSpaceManager().onEventItemsDeleted((List<EventItem>)eventItems));
            }
            iterator.remove();
        }
        if (deleteSubscriptions) {
            while (this.publishQueue.isNotEmpty()) {
                ServiceRequest publishService = this.publishQueue.poll();
                if (publishService == null) continue;
                publishService.setServiceFault(2149974016L);
            }
        }
    }

    public void addSubscription(Subscription subscription) {
        this.subscriptions.put(subscription.getId(), subscription);
        this.server.getEventBus().post(new SubscriptionCreatedEvent(subscription));
        subscription.setStateListener((s, ps, cs) -> {
            if (cs == Subscription.State.Closing) {
                this.subscriptions.remove(s.getId());
                this.server.getSubscriptions().remove(s.getId());
                this.server.getEventBus().post(new SubscriptionDeletedEvent(s));
                SubscriptionManager.byMonitoredItemType(s.getMonitoredItems().values(), dataItems -> this.server.getAddressSpaceManager().onDataItemsDeleted((List<DataItem>)dataItems), eventItems -> this.server.getAddressSpaceManager().onEventItemsDeleted((List<EventItem>)eventItems));
                s.getMonitoredItems().clear();
            }
        });
    }

    public Subscription removeSubscription(UInteger subscriptionId) {
        Subscription subscription = this.subscriptions.remove(subscriptionId);
        this.server.getEventBus().post(new SubscriptionDeletedEvent(subscription));
        if (subscription != null) {
            subscription.setStateListener(null);
        }
        return subscription;
    }

    public void sendStatusChangeNotification(Subscription subscription, StatusCode status) {
        ServiceRequest service = this.publishQueue.poll();
        if (service != null) {
            subscription.returnStatusChangeNotification(service, status);
        } else {
            this.transferred.add(subscription);
        }
    }

    private static void byMonitoredItemType(Collection<BaseMonitoredItem<?>> monitoredItems, Consumer<List<DataItem>> dataItemConsumer, Consumer<List<EventItem>> eventItemConsumer) {
        ArrayList<DataItem> dataItems = Lists.newArrayList();
        ArrayList<EventItem> eventItems = Lists.newArrayList();
        for (BaseMonitoredItem<?> item : monitoredItems) {
            if (item instanceof MonitoredDataItem) {
                dataItems.add((DataItem)((Object)item));
                continue;
            }
            if (!(item instanceof MonitoredEventItem)) continue;
            eventItems.add((EventItem)((Object)item));
        }
        try {
            if (!dataItems.isEmpty()) {
                dataItemConsumer.accept(dataItems);
            }
        }
        catch (Throwable t) {
            LoggerFactory.getLogger(SubscriptionManager.class).error("Uncaught Throwable in dataItemConsumer", t);
        }
        try {
            if (!eventItems.isEmpty()) {
                eventItemConsumer.accept(eventItems);
            }
        }
        catch (Throwable t) {
            LoggerFactory.getLogger(SubscriptionManager.class).error("Uncaught Throwable in eventItemConsumer", t);
        }
    }

    private static boolean subtypeOf(OpcUaServer server, NodeId dataTypeId, NodeId potentialSuperTypeId) {
        UaNode dataTypeNode = server.getAddressSpaceManager().getManagedNode(dataTypeId).orElse(null);
        if (dataTypeNode != null) {
            NodeId superTypeId = SubscriptionManager.getSuperTypeId(server, dataTypeId);
            if (superTypeId != null) {
                return superTypeId.equals(potentialSuperTypeId) || SubscriptionManager.subtypeOf(server, superTypeId, potentialSuperTypeId);
            }
            return false;
        }
        return false;
    }

    @Nullable
    private static NodeId getSuperTypeId(OpcUaServer server, NodeId dataTypeId) {
        UaNode dataTypeNode = server.getAddressSpaceManager().getManagedNode(dataTypeId).orElse(null);
        if (dataTypeNode != null) {
            return dataTypeNode.getReferences().stream().filter(Reference.SUBTYPE_OF).flatMap(r -> StreamUtil.opt2stream(r.getTargetNodeId().toNodeId(server.getNamespaceTable()))).findFirst().orElse(null);
        }
        return null;
    }

    private static class AttributeGroup {
        final DataValue accessLevelValue;
        final DataValue userAccessLevelValue;
        final DataValue eventNotifierValue;
        final DataValue minimumSamplingIntervalValue;
        final DataValue dataType;

        AttributeGroup(DataValue accessLevelValue, DataValue userAccessLevelValue, DataValue eventNotifierValue, DataValue minimumSamplingIntervalValue, DataValue dataType) {
            this.accessLevelValue = accessLevelValue;
            this.userAccessLevelValue = userAccessLevelValue;
            this.eventNotifierValue = eventNotifierValue;
            this.minimumSamplingIntervalValue = minimumSamplingIntervalValue;
            this.dataType = dataType;
        }

        @Nullable
        UByte getAccessLevel() throws UaException {
            Object value = this.getValue(this.accessLevelValue);
            if (value instanceof UByte) {
                return (UByte)value;
            }
            return null;
        }

        @Nullable
        UByte getUserAccessLevel() throws UaException {
            Object value = this.getValue(this.userAccessLevelValue);
            if (value instanceof UByte) {
                return (UByte)value;
            }
            return null;
        }

        @Nullable
        UByte getEventNotifier() throws UaException {
            Object value = this.getValue(this.eventNotifierValue);
            if (value instanceof UByte) {
                return (UByte)value;
            }
            return null;
        }

        @Nullable
        Double getMinimumSamplingInterval() throws UaException {
            Object value = this.getValue(this.minimumSamplingIntervalValue);
            if (value instanceof Double) {
                return (Double)value;
            }
            return null;
        }

        @Nullable
        NodeId getDataType() throws UaException {
            Object value = this.getValue(this.dataType);
            if (value instanceof NodeId) {
                return (NodeId)value;
            }
            return null;
        }

        private Object getValue(DataValue dataValue) throws UaException {
            StatusCode statusCode = dataValue.getStatusCode();
            if (statusCode == null) {
                throw new UaException(StatusCode.BAD);
            }
            if (statusCode.isBad()) {
                throw new UaException(statusCode);
            }
            return dataValue.getValue().getValue();
        }
    }
}

