/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.services;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.Session;
import org.eclipse.milo.opcua.sdk.server.items.MonitoredDataItem;
import org.eclipse.milo.opcua.sdk.server.services.ServiceAttributes;
import org.eclipse.milo.opcua.sdk.server.subscriptions.Subscription;
import org.eclipse.milo.opcua.sdk.server.subscriptions.SubscriptionManager;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.ApplicationDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.TransferResult;
import org.eclipse.milo.opcua.stack.core.types.structured.TransferSubscriptionsRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.TransferSubscriptionsResponse;
import org.eclipse.milo.opcua.stack.core.util.ConversionUtil;
import org.eclipse.milo.opcua.stack.server.services.ServiceRequest;
import org.eclipse.milo.opcua.stack.server.services.SubscriptionServiceSet;

public class DefaultSubscriptionServiceSet
implements SubscriptionServiceSet {
    private final SubscriptionManager subscriptionManager;

    public DefaultSubscriptionServiceSet(SubscriptionManager subscriptionManager) {
        this.subscriptionManager = subscriptionManager;
    }

    @Override
    public void onCreateSubscription(ServiceRequest service) {
        this.subscriptionManager.createSubscription(service);
    }

    @Override
    public void onModifySubscription(ServiceRequest service) throws UaException {
        this.subscriptionManager.modifySubscription(service);
    }

    @Override
    public void onDeleteSubscriptions(ServiceRequest service) throws UaException {
        this.subscriptionManager.deleteSubscription(service);
    }

    @Override
    public void onSetPublishingMode(ServiceRequest service) {
        this.subscriptionManager.setPublishingMode(service);
    }

    @Override
    public void onPublish(ServiceRequest service) {
        this.subscriptionManager.publish(service);
    }

    @Override
    public void onRepublish(ServiceRequest service) {
        this.subscriptionManager.republish(service);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTransferSubscriptions(ServiceRequest service) throws UaException {
        TransferSubscriptionsRequest request = (TransferSubscriptionsRequest)service.getRequest();
        OpcUaServer server = service.attr(ServiceAttributes.SERVER_KEY).get();
        Session session = service.attr(ServiceAttributes.SESSION_KEY).get();
        List<UInteger> subscriptionIds = ConversionUtil.l(request.getSubscriptionIds());
        if (subscriptionIds.isEmpty()) {
            throw new UaException(0x800F0000L);
        }
        ArrayList<TransferResult> results = Lists.newArrayList();
        for (UInteger subscriptionId : subscriptionIds) {
            UInteger[] availableSequenceNumbers;
            Subscription subscription = server.getSubscriptions().get(subscriptionId);
            if (subscription == null) {
                results.add(new TransferResult(new StatusCode(0x80280000L), new UInteger[0]));
                continue;
            }
            Session otherSession = subscription.getSession();
            if (!this.sessionsHaveSameUser(session, otherSession)) {
                results.add(new TransferResult(new StatusCode(2149515264L), new UInteger[0]));
                continue;
            }
            Subscription subscription2 = subscription;
            synchronized (subscription2) {
                otherSession.getSubscriptionManager().sendStatusChangeNotification(subscription, new StatusCode(0x2D0000L));
                otherSession.getSubscriptionManager().removeSubscription(subscriptionId);
                subscription.setSubscriptionManager(session.getSubscriptionManager());
                this.subscriptionManager.addSubscription(subscription);
                subscription.getMonitoredItems().values().forEach(item -> item.setSession(session));
                availableSequenceNumbers = subscription.getAvailableSequenceNumbers();
                if (request.getSendInitialValues().booleanValue()) {
                    subscription.getMonitoredItems().values().stream().filter(item -> item instanceof MonitoredDataItem).map(item -> (MonitoredDataItem)item).forEach(MonitoredDataItem::maybeSendLastValue);
                }
            }
            subscription.getSubscriptionDiagnostics().getTransferRequestCount().increment();
            ApplicationDescription toClient = session.getClientDescription();
            ApplicationDescription fromClient = otherSession.getClientDescription();
            if (Objects.equals(toClient, fromClient)) {
                subscription.getSubscriptionDiagnostics().getTransferredToSameClientCount().increment();
            } else {
                subscription.getSubscriptionDiagnostics().getTransferredToAltClientCount().increment();
            }
            results.add(new TransferResult(StatusCode.GOOD, availableSequenceNumbers));
        }
        TransferSubscriptionsResponse response = new TransferSubscriptionsResponse(service.createResponseHeader(), ConversionUtil.a(results, TransferResult.class), new DiagnosticInfo[0]);
        service.setResponse(response);
    }

    private boolean sessionsHaveSameUser(Session s1, Session s2) {
        Object identity1 = s1.getIdentityObject();
        Object identity2 = s2.getIdentityObject();
        return Objects.equals(identity1, identity2);
    }
}

