/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.nodes.factories;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.milo.opcua.sdk.server.nodes.factories.BrowsePath;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.util.Tree;

class NodeTable {
    final LinkedHashMap<BrowsePath, NodeId> nodes = new LinkedHashMap();

    NodeTable() {
    }

    void addNode(BrowsePath browsePath, NodeId nodeId) {
        this.nodes.put(browsePath, nodeId);
    }

    Tree<BrowsePath> getBrowsePathTree() {
        BrowsePath parentBrowsePath = this.nodes.keySet().stream().filter(b -> b.parent == null).findFirst().orElse(null);
        Map<BrowsePath, List<BrowsePath>> grouping = this.nodes.keySet().stream().filter(b -> b.parent != null).collect(Collectors.groupingBy(b -> b.parent));
        Tree<BrowsePath> root = new Tree<BrowsePath>(null, parentBrowsePath);
        NodeTable.addChildren(grouping, root);
        return root;
    }

    private static void addChildren(Map<BrowsePath, List<BrowsePath>> grouping, Tree<BrowsePath> parent) {
        BrowsePath parentPath = parent.getValue();
        List<BrowsePath> childPaths = grouping.get(parentPath);
        if (childPaths != null) {
            childPaths.forEach(childPath -> {
                Tree<BrowsePath> child = parent.addChild((BrowsePath)childPath);
                NodeTable.addChildren(grouping, child);
            });
        }
    }

    static NodeTable merge(NodeTable table1, NodeTable table2) {
        NodeTable mergedNodeTable = new NodeTable();
        mergedNodeTable.nodes.putAll(table2.nodes);
        mergedNodeTable.nodes.putAll(table1.nodes);
        return mergedNodeTable;
    }
}

