/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.nodes;

import org.eclipse.milo.opcua.sdk.core.nodes.VariableTypeNode;
import org.eclipse.milo.opcua.sdk.core.nodes.VariableTypeNodeProperties;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNodeContext;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.jetbrains.annotations.Nullable;

public class UaVariableTypeNode
extends UaNode
implements VariableTypeNode {
    private DataValue value;
    private NodeId dataType;
    private Integer valueRank;
    private UInteger[] arrayDimensions;
    private Boolean isAbstract;

    public UaVariableTypeNode(UaNodeContext context, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, DataValue value, NodeId dataType, Integer valueRank, UInteger[] arrayDimensions, Boolean isAbstract) {
        super(context, nodeId, NodeClass.VariableType, browseName, displayName, description, writeMask, userWriteMask);
        this.value = value;
        this.dataType = dataType;
        this.valueRank = valueRank;
        this.arrayDimensions = arrayDimensions;
        this.isAbstract = isAbstract;
    }

    @Override
    public DataValue getValue() {
        return (DataValue)this.filterChain.getAttribute(this, AttributeId.Value);
    }

    @Override
    public NodeId getDataType() {
        return (NodeId)this.filterChain.getAttribute(this, AttributeId.DataType);
    }

    @Override
    public Integer getValueRank() {
        return (Integer)this.filterChain.getAttribute(this, AttributeId.ValueRank);
    }

    @Override
    public UInteger[] getArrayDimensions() {
        return (UInteger[])this.filterChain.getAttribute(this, AttributeId.ArrayDimensions);
    }

    @Override
    public Boolean getIsAbstract() {
        return (Boolean)this.filterChain.getAttribute(this, AttributeId.IsAbstract);
    }

    @Override
    public void setValue(DataValue value) {
        this.filterChain.setAttribute(this, AttributeId.Value, value);
    }

    @Override
    public void setDataType(NodeId dataType) {
        this.filterChain.setAttribute(this, AttributeId.DataType, dataType);
    }

    @Override
    public void setValueRank(Integer valueRank) {
        this.filterChain.setAttribute(this, AttributeId.ValueRank, valueRank);
    }

    @Override
    public void setArrayDimensions(UInteger[] arrayDimensions) {
        this.filterChain.setAttribute(this, AttributeId.ArrayDimensions, arrayDimensions);
    }

    @Override
    public void setIsAbstract(Boolean isAbstract) {
        this.filterChain.setAttribute(this, AttributeId.IsAbstract, isAbstract);
    }

    @Override
    public synchronized Object getAttribute(AttributeId attributeId) {
        switch (attributeId) {
            case Value: {
                return this.value;
            }
            case DataType: {
                return this.dataType;
            }
            case ValueRank: {
                return this.valueRank;
            }
            case ArrayDimensions: {
                return this.arrayDimensions;
            }
            case IsAbstract: {
                return this.isAbstract;
            }
        }
        return super.getAttribute(attributeId);
    }

    @Override
    public synchronized void setAttribute(AttributeId attributeId, Object value) {
        switch (attributeId) {
            case Value: {
                this.value = (DataValue)value;
                break;
            }
            case DataType: {
                this.dataType = (NodeId)value;
                break;
            }
            case ValueRank: {
                this.valueRank = (Integer)value;
                break;
            }
            case ArrayDimensions: {
                this.arrayDimensions = (UInteger[])value;
                break;
            }
            case IsAbstract: {
                this.isAbstract = (Boolean)value;
                break;
            }
            default: {
                super.setAttribute(attributeId, value);
                return;
            }
        }
        this.fireAttributeChanged(attributeId, value);
    }

    @Nullable
    public String getNodeVersion() {
        return this.getProperty(VariableTypeNodeProperties.NodeVersion).orElse(null);
    }

    public void setNodeVersion(String nodeVersion) {
        this.setProperty(VariableTypeNodeProperties.NodeVersion, nodeVersion);
    }
}

