/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.nodes;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.eclipse.milo.opcua.sdk.core.QualifiedProperty;
import org.eclipse.milo.opcua.sdk.core.Reference;
import org.eclipse.milo.opcua.sdk.core.nodes.Node;
import org.eclipse.milo.opcua.sdk.core.nodes.ObjectNode;
import org.eclipse.milo.opcua.sdk.core.nodes.VariableNode;
import org.eclipse.milo.opcua.sdk.core.util.StreamUtil;
import org.eclipse.milo.opcua.sdk.server.api.NodeManager;
import org.eclipse.milo.opcua.sdk.server.model.nodes.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.server.nodes.AttributeContext;
import org.eclipse.milo.opcua.sdk.server.nodes.AttributeObserver;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNodeContext;
import org.eclipse.milo.opcua.sdk.server.nodes.UaServerNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaVariableNode;
import org.eclipse.milo.opcua.sdk.server.nodes.delegates.AttributeDelegate;
import org.eclipse.milo.opcua.sdk.server.nodes.filters.AttributeFilterChain;
import org.eclipse.milo.opcua.sdk.server.util.AttributeUtil;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.UaRuntimeException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.jetbrains.annotations.Nullable;

public abstract class UaNode
implements UaServerNode {
    private AttributeDelegate attributeDelegate;
    private List<AttributeObserver> observers;
    final AttributeFilterChain filterChain = new AttributeFilterChain();
    private final UaNodeContext context;
    private NodeId nodeId;
    private NodeClass nodeClass;
    private QualifiedName browseName;
    private LocalizedText displayName;
    private LocalizedText description;
    private UInteger writeMask;
    private UInteger userWriteMask;

    protected UaNode(UaNodeContext context, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName) {
        this(context, nodeId, nodeClass, browseName, displayName, LocalizedText.NULL_VALUE, UInteger.MIN, UInteger.MIN);
    }

    protected UaNode(UaNodeContext context, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask) {
        this.context = context;
        this.nodeId = nodeId;
        this.nodeClass = nodeClass;
        this.browseName = browseName;
        this.displayName = displayName;
        this.description = description;
        this.writeMask = writeMask;
        this.userWriteMask = userWriteMask;
    }

    @Override
    public NodeId getNodeId() {
        return (NodeId)this.filterChain.getAttribute(this, AttributeId.NodeId);
    }

    @Override
    public NodeClass getNodeClass() {
        return (NodeClass)this.filterChain.getAttribute(this, AttributeId.NodeClass);
    }

    @Override
    public QualifiedName getBrowseName() {
        return (QualifiedName)this.filterChain.getAttribute(this, AttributeId.BrowseName);
    }

    @Override
    public LocalizedText getDisplayName() {
        return (LocalizedText)this.filterChain.getAttribute(this, AttributeId.DisplayName);
    }

    @Override
    public LocalizedText getDescription() {
        return (LocalizedText)this.filterChain.getAttribute(this, AttributeId.Description);
    }

    @Override
    public UInteger getWriteMask() {
        return (UInteger)this.filterChain.getAttribute(this, AttributeId.WriteMask);
    }

    @Override
    public UInteger getUserWriteMask() {
        return (UInteger)this.filterChain.getAttribute(this, AttributeId.UserWriteMask);
    }

    @Override
    public void setNodeId(NodeId nodeId) {
        this.filterChain.setAttribute(this, AttributeId.NodeId, nodeId);
    }

    @Override
    public void setNodeClass(NodeClass nodeClass) {
        this.filterChain.setAttribute(this, AttributeId.NodeClass, nodeClass);
    }

    @Override
    public void setBrowseName(QualifiedName browseName) {
        this.filterChain.setAttribute(this, AttributeId.BrowseName, browseName);
    }

    @Override
    public void setDisplayName(LocalizedText displayName) {
        this.filterChain.setAttribute(this, AttributeId.DisplayName, displayName);
    }

    @Override
    public void setDescription(LocalizedText description) {
        this.filterChain.setAttribute(this, AttributeId.Description, description);
    }

    @Override
    public void setWriteMask(UInteger writeMask) {
        this.filterChain.setAttribute(this, AttributeId.WriteMask, writeMask);
    }

    @Override
    public void setUserWriteMask(UInteger userWriteMask) {
        this.filterChain.setAttribute(this, AttributeId.UserWriteMask, userWriteMask);
    }

    public synchronized Object getAttribute(AttributeId attributeId) {
        switch (attributeId) {
            case NodeId: {
                return this.nodeId;
            }
            case NodeClass: {
                return this.nodeClass;
            }
            case BrowseName: {
                return this.browseName;
            }
            case DisplayName: {
                return this.displayName;
            }
            case Description: {
                return this.description;
            }
            case WriteMask: {
                return this.writeMask;
            }
            case UserWriteMask: {
                return this.userWriteMask;
            }
        }
        throw new UaRuntimeException(2150957056L, "AttributeId: " + (Object)((Object)attributeId));
    }

    public synchronized void setAttribute(AttributeId attributeId, Object value) {
        switch (attributeId) {
            case NodeId: {
                this.nodeId = (NodeId)value;
                break;
            }
            case NodeClass: {
                this.nodeClass = (NodeClass)value;
                break;
            }
            case BrowseName: {
                this.browseName = (QualifiedName)value;
                break;
            }
            case DisplayName: {
                this.displayName = (LocalizedText)value;
                break;
            }
            case Description: {
                this.description = (LocalizedText)value;
                break;
            }
            case WriteMask: {
                this.writeMask = (UInteger)value;
                break;
            }
            case UserWriteMask: {
                this.userWriteMask = (UInteger)value;
                break;
            }
            default: {
                throw new UaRuntimeException(2150957056L, "AttributeId: " + (Object)((Object)attributeId));
            }
        }
        this.fireAttributeChanged(attributeId, value);
    }

    public final void delete() {
        NodeManager<UaNode> nodeManager = this.context.getNodeManager();
        nodeManager.removeNode((UaNode)((Object)this.getNodeId()));
        for (Reference reference : nodeManager.getReferences(this.getNodeId())) {
            if (reference.isForward() && reference.subtypeOf(Identifiers.HasChild)) {
                Optional<UaNode> targetNode = nodeManager.getNode(reference.getTargetNodeId(), this.getNodeContext().getServer().getNamespaceTable());
                targetNode.ifPresent(UaNode::delete);
            }
            nodeManager.removeReferences(reference, this.context.getNamespaceTable());
        }
    }

    @Override
    public final UaNodeContext getNodeContext() {
        return this.context;
    }

    public final NodeManager<UaNode> getNodeManager() {
        return this.context.getNodeManager();
    }

    protected Optional<UaNode> getManagedNode(NodeId nodeId) {
        return this.context.getServer().getAddressSpaceManager().getManagedNode(nodeId);
    }

    protected Optional<UaNode> getManagedNode(ExpandedNodeId nodeId) {
        return this.context.getServer().getAddressSpaceManager().getManagedNode(nodeId);
    }

    @Override
    public ImmutableList<Reference> getReferences() {
        return ImmutableList.copyOf(this.context.getServer().getAddressSpaceManager().getManagedReferences(this.getNodeId()));
    }

    @Override
    public void addReference(Reference reference) {
        this.context.getNodeManager().addReferences(reference, this.context.getNamespaceTable());
    }

    @Override
    public void removeReference(Reference reference) {
        this.context.getNodeManager().removeReferences(reference, this.context.getNamespaceTable());
    }

    public <T> Optional<T> getProperty(QualifiedProperty<T> property) {
        String namespaceUri = property.getNamespaceUri();
        UShort namespaceIndex = this.context.getServer().getNamespaceTable().getIndex(namespaceUri);
        if (namespaceIndex != null) {
            QualifiedName browseName = new QualifiedName(namespaceIndex, property.getBrowseName());
            try {
                return this.getProperty(browseName).map(property.getJavaType()::cast);
            }
            catch (Throwable t) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    public Optional<Object> getProperty(QualifiedName browseName) {
        return this.getPropertyNode(browseName).map(node -> node.getValue().getValue().getValue());
    }

    public <T> void setProperty(QualifiedProperty<T> property, T value) {
        UShort namespaceIndex = this.context.getServer().getNamespaceTable().getIndex(property.getNamespaceUri());
        if (namespaceIndex == null) {
            throw new IllegalArgumentException("property belongs to unregistered namespace: " + property.getNamespaceUri());
        }
        VariableNode node = this.getPropertyNode(property).orElseGet(() -> {
            String browseName = property.getBrowseName();
            NodeId propertyNodeId = new NodeId(this.getNodeId().getNamespaceIndex(), String.format("%s.%s", this.getNodeId().getIdentifier().toString(), browseName));
            PropertyTypeNode propertyNode = new PropertyTypeNode(this.context, propertyNodeId, new QualifiedName(namespaceIndex, browseName), LocalizedText.english(browseName), LocalizedText.NULL_VALUE, Unsigned.uint(0), Unsigned.uint(0));
            NodeId dataType = property.getDataType().toNodeId(this.context.getNamespaceTable()).orElse(NodeId.NULL_VALUE);
            propertyNode.setDataType(dataType);
            propertyNode.setValueRank(property.getValueRank());
            propertyNode.setArrayDimensions(property.getArrayDimensions());
            propertyNode.addReference(new Reference(propertyNode.getNodeId(), Identifiers.HasTypeDefinition, Identifiers.PropertyType.expanded(), true));
            this.addProperty(propertyNode);
            this.context.getNodeManager().addNode(propertyNode);
            return propertyNode;
        });
        node.setValue(new DataValue(new Variant(value)));
    }

    public Optional<VariableNode> getPropertyNode(QualifiedProperty<?> property) {
        Optional<QualifiedName> qualifiedName = property.getQualifiedName(this.context.getServer().getNamespaceTable());
        return qualifiedName.map(this::getPropertyNode).orElseGet(() -> this.getPropertyNode(property.getBrowseName()));
    }

    public Optional<VariableNode> getPropertyNode(String browseName) {
        return this.getPropertyNode(new QualifiedName(this.getNodeId().getNamespaceIndex(), browseName));
    }

    public Optional<VariableNode> getPropertyNode(QualifiedName browseName) {
        Node node = this.getReferences().stream().filter(Reference.HAS_PROPERTY_PREDICATE).flatMap(r -> StreamUtil.opt2stream(this.getManagedNode(r.getTargetNodeId()))).filter(n -> n.getBrowseName().equals(browseName)).findFirst().orElse(null);
        try {
            return Optional.ofNullable((VariableNode)node);
        }
        catch (Throwable t) {
            return Optional.empty();
        }
    }

    void addProperty(UaVariableNode node) {
        this.addReference(new Reference(this.getNodeId(), Identifiers.HasProperty, node.getNodeId().expanded(), true));
        node.addReference(new Reference(node.getNodeId(), Identifiers.HasProperty, this.getNodeId().expanded(), false));
    }

    void removeProperty(UaVariableNode node) {
        this.removeReference(new Reference(this.getNodeId(), Identifiers.HasProperty, node.getNodeId().expanded(), true));
        node.removeReference(new Reference(node.getNodeId(), Identifiers.HasProperty, this.getNodeId().expanded(), false));
    }

    public Optional<UaNode> findNode(QualifiedName browseName) {
        return this.findNode(browseName, uaNode -> true, reference -> true);
    }

    public Optional<UaNode> findNode(QualifiedName browseName, Predicate<Reference> references) {
        return this.findNode(browseName, uaNode -> true, references);
    }

    public Optional<UaNode> findNode(QualifiedName browseName, Predicate<UaNode> nodePredicate, Predicate<Reference> referencePredicate) {
        return this.getReferences().stream().filter(referencePredicate).flatMap(r -> StreamUtil.opt2stream(this.getManagedNode(r.getTargetNodeId()))).filter(nodePredicate).filter(n -> n.getBrowseName().equals(browseName)).findFirst();
    }

    public Optional<UaNode> findNode(String namespaceUri, String browseName, Predicate<UaNode> nodePredicate, Predicate<Reference> referencePredicate) {
        return this.getReferences().stream().filter(referencePredicate).flatMap(r -> StreamUtil.opt2stream(this.getManagedNode(r.getTargetNodeId()))).filter(nodePredicate).filter(n -> {
            String nodeBrowseName = n.getBrowseName().getName();
            UShort index = n.getBrowseName().getNamespaceIndex();
            String nodeBrowseNameUri = this.context.getServer().getNamespaceTable().getUri(index);
            return Objects.equals(browseName, nodeBrowseName) && Objects.equals(namespaceUri, nodeBrowseNameUri);
        }).findFirst();
    }

    protected Optional<ObjectNode> getObjectComponent(String namespaceUri, String name) {
        UShort namespaceIndex = this.context.getServer().getNamespaceTable().getIndex(namespaceUri);
        if (namespaceIndex != null) {
            return this.getObjectComponent(new QualifiedName(namespaceIndex, name));
        }
        return Optional.empty();
    }

    protected Optional<ObjectNode> getObjectComponent(String browseName) {
        return this.getObjectComponent(new QualifiedName(this.getNodeId().getNamespaceIndex(), browseName));
    }

    protected Optional<ObjectNode> getObjectComponent(QualifiedName browseName) {
        ObjectNode node = this.getReferences().stream().filter(Reference.HAS_COMPONENT_PREDICATE).flatMap(r -> StreamUtil.opt2stream(this.getManagedNode(r.getTargetNodeId()))).filter(n -> n.getNodeClass() == NodeClass.Object && n.getBrowseName().equals(browseName)).findFirst().orElse(null);
        return Optional.ofNullable(node);
    }

    protected Optional<VariableNode> getVariableComponent(String namespaceUri, String name) {
        UShort namespaceIndex = this.context.getServer().getNamespaceTable().getIndex(namespaceUri);
        if (namespaceIndex != null) {
            return this.getVariableComponent(new QualifiedName(namespaceIndex, name));
        }
        return Optional.empty();
    }

    protected Optional<VariableNode> getVariableComponent(String browseName) {
        return this.getVariableComponent(new QualifiedName(this.getNodeId().getNamespaceIndex(), browseName));
    }

    protected Optional<VariableNode> getVariableComponent(QualifiedName browseName) {
        VariableNode node = this.getReferences().stream().filter(Reference.HAS_COMPONENT_PREDICATE).flatMap(r -> StreamUtil.opt2stream(this.getManagedNode(r.getTargetNodeId()))).filter(n -> n.getNodeClass() == NodeClass.Variable && n.getBrowseName().equals(browseName)).findFirst().orElse(null);
        return Optional.ofNullable(node);
    }

    public synchronized void addAttributeObserver(AttributeObserver observer) {
        if (this.observers == null) {
            this.observers = new LinkedList<AttributeObserver>();
        }
        this.observers.add(observer);
    }

    public synchronized void removeAttributeObserver(AttributeObserver observer) {
        if (this.observers == null) {
            return;
        }
        this.observers.remove(observer);
        if (this.observers.isEmpty()) {
            this.observers = null;
        }
    }

    public synchronized void fireAttributeChanged(AttributeId attributeId, Object attributeValue) {
        if (this.observers == null) {
            return;
        }
        ArrayList<AttributeObserver> toNotify = new ArrayList<AttributeObserver>(this.observers);
        toNotify.forEach(o -> o.attributeChanged(this, attributeId, attributeValue));
    }

    public AttributeFilterChain getFilterChain() {
        return this.filterChain;
    }

    public synchronized void setAttributeDelegate(AttributeDelegate attributeDelegate) {
        this.attributeDelegate = attributeDelegate;
    }

    @Nullable
    public synchronized AttributeDelegate getAttributeDelegate() {
        return this.attributeDelegate;
    }

    @Override
    public DataValue getAttribute(AttributeContext context, AttributeId attributeId) {
        AttributeDelegate delegate = this.getAttributeDelegate();
        if (delegate == null) {
            try {
                Object attributeValue = this.getFilterChain().getAttribute(context.getSession().orElse(null), this, attributeId);
                if (attributeId == AttributeId.Value) {
                    return (DataValue)attributeValue;
                }
                return AttributeUtil.dv(attributeValue);
            }
            catch (Throwable t) {
                StatusCode statusCode = UaException.extractStatusCode(t).orElse(new StatusCode(0x80020000L));
                return new DataValue(statusCode);
            }
        }
        return delegate.getAttribute(context, this, attributeId);
    }

    @Override
    public void setAttribute(AttributeContext context, AttributeId attributeId, DataValue value) throws UaException {
        AttributeDelegate delegate = this.getAttributeDelegate();
        if (delegate == null) {
            try {
                this.getFilterChain().setAttribute(context.getSession().orElse(null), this, attributeId, attributeId == AttributeId.Value ? value : value.getValue().getValue());
            }
            catch (Throwable t) {
                long statusCode = UaException.extractStatusCode(t).map(StatusCode::getValue).orElse(0x80020000L);
                throw new UaException(statusCode, t);
            }
        } else {
            delegate.setAttribute(context, this, attributeId, value);
        }
    }
}

