/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.model.nodes.objects;

import java.util.Optional;
import org.eclipse.milo.opcua.sdk.core.Reference;
import org.eclipse.milo.opcua.sdk.core.nodes.ObjectNode;
import org.eclipse.milo.opcua.sdk.core.nodes.VariableNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.objects.BaseObjectTypeNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.objects.FiniteStateMachineTypeNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.objects.StateTypeNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.objects.TransitionTypeNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.variables.FiniteStateVariableTypeNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.variables.FiniteTransitionVariableTypeNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.variables.ProgramDiagnosticTypeNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.server.model.types.objects.ProgramStateMachineType;
import org.eclipse.milo.opcua.sdk.server.nodes.UaMethodNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNodeContext;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.ProgramDiagnosticDataType;

public class ProgramStateMachineTypeNode
extends FiniteStateMachineTypeNode
implements ProgramStateMachineType {
    public ProgramStateMachineTypeNode(UaNodeContext context, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask) {
        super(context, nodeId, browseName, displayName, description, writeMask, userWriteMask);
    }

    public ProgramStateMachineTypeNode(UaNodeContext context, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, UByte eventNotifier) {
        super(context, nodeId, browseName, displayName, description, writeMask, userWriteMask, eventNotifier);
    }

    @Override
    public PropertyTypeNode getCreatableNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(ProgramStateMachineType.CREATABLE);
        return propertyNode.orElse(null);
    }

    @Override
    public Boolean getCreatable() {
        Optional<Boolean> propertyValue = this.getProperty(ProgramStateMachineType.CREATABLE);
        return propertyValue.orElse(null);
    }

    @Override
    public void setCreatable(Boolean value) {
        this.setProperty(ProgramStateMachineType.CREATABLE, value);
    }

    @Override
    public PropertyTypeNode getDeletableNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(ProgramStateMachineType.DELETABLE);
        return propertyNode.orElse(null);
    }

    @Override
    public Boolean getDeletable() {
        Optional<Boolean> propertyValue = this.getProperty(ProgramStateMachineType.DELETABLE);
        return propertyValue.orElse(null);
    }

    @Override
    public void setDeletable(Boolean value) {
        this.setProperty(ProgramStateMachineType.DELETABLE, value);
    }

    @Override
    public PropertyTypeNode getAutoDeleteNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(ProgramStateMachineType.AUTO_DELETE);
        return propertyNode.orElse(null);
    }

    @Override
    public Boolean getAutoDelete() {
        Optional<Boolean> propertyValue = this.getProperty(ProgramStateMachineType.AUTO_DELETE);
        return propertyValue.orElse(null);
    }

    @Override
    public void setAutoDelete(Boolean value) {
        this.setProperty(ProgramStateMachineType.AUTO_DELETE, value);
    }

    @Override
    public PropertyTypeNode getRecycleCountNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(ProgramStateMachineType.RECYCLE_COUNT);
        return propertyNode.orElse(null);
    }

    @Override
    public Integer getRecycleCount() {
        Optional<Integer> propertyValue = this.getProperty(ProgramStateMachineType.RECYCLE_COUNT);
        return propertyValue.orElse(null);
    }

    @Override
    public void setRecycleCount(Integer value) {
        this.setProperty(ProgramStateMachineType.RECYCLE_COUNT, value);
    }

    @Override
    public PropertyTypeNode getInstanceCountNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(ProgramStateMachineType.INSTANCE_COUNT);
        return propertyNode.orElse(null);
    }

    @Override
    public UInteger getInstanceCount() {
        Optional<UInteger> propertyValue = this.getProperty(ProgramStateMachineType.INSTANCE_COUNT);
        return propertyValue.orElse(null);
    }

    @Override
    public void setInstanceCount(UInteger value) {
        this.setProperty(ProgramStateMachineType.INSTANCE_COUNT, value);
    }

    @Override
    public PropertyTypeNode getMaxInstanceCountNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(ProgramStateMachineType.MAX_INSTANCE_COUNT);
        return propertyNode.orElse(null);
    }

    @Override
    public UInteger getMaxInstanceCount() {
        Optional<UInteger> propertyValue = this.getProperty(ProgramStateMachineType.MAX_INSTANCE_COUNT);
        return propertyValue.orElse(null);
    }

    @Override
    public void setMaxInstanceCount(UInteger value) {
        this.setProperty(ProgramStateMachineType.MAX_INSTANCE_COUNT, value);
    }

    @Override
    public PropertyTypeNode getMaxRecycleCountNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(ProgramStateMachineType.MAX_RECYCLE_COUNT);
        return propertyNode.orElse(null);
    }

    @Override
    public UInteger getMaxRecycleCount() {
        Optional<UInteger> propertyValue = this.getProperty(ProgramStateMachineType.MAX_RECYCLE_COUNT);
        return propertyValue.orElse(null);
    }

    @Override
    public void setMaxRecycleCount(UInteger value) {
        this.setProperty(ProgramStateMachineType.MAX_RECYCLE_COUNT, value);
    }

    @Override
    public FiniteStateVariableTypeNode getCurrentStateNode() {
        Optional<VariableNode> component = this.getVariableComponent("http://opcfoundation.org/UA/", "CurrentState");
        return component.orElse(null);
    }

    @Override
    public LocalizedText getCurrentState() {
        Optional<VariableNode> component = this.getVariableComponent("http://opcfoundation.org/UA/", "CurrentState");
        return component.map(node -> (LocalizedText)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public void setCurrentState(LocalizedText value) {
        this.getVariableComponent("http://opcfoundation.org/UA/", "CurrentState").ifPresent(n -> n.setValue(new DataValue(new Variant(value))));
    }

    @Override
    public FiniteTransitionVariableTypeNode getLastTransitionNode() {
        Optional<VariableNode> component = this.getVariableComponent("http://opcfoundation.org/UA/", "LastTransition");
        return component.orElse(null);
    }

    @Override
    public LocalizedText getLastTransition() {
        Optional<VariableNode> component = this.getVariableComponent("http://opcfoundation.org/UA/", "LastTransition");
        return component.map(node -> (LocalizedText)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public void setLastTransition(LocalizedText value) {
        this.getVariableComponent("http://opcfoundation.org/UA/", "LastTransition").ifPresent(n -> n.setValue(new DataValue(new Variant(value))));
    }

    @Override
    public ProgramDiagnosticTypeNode getProgramDiagnosticsNode() {
        Optional<VariableNode> component = this.getVariableComponent("http://opcfoundation.org/UA/", "ProgramDiagnostics");
        return component.orElse(null);
    }

    @Override
    public ProgramDiagnosticDataType getProgramDiagnostics() {
        Optional<VariableNode> component = this.getVariableComponent("http://opcfoundation.org/UA/", "ProgramDiagnostics");
        return component.map(node -> (ProgramDiagnosticDataType)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public void setProgramDiagnostics(ProgramDiagnosticDataType value) {
        this.getVariableComponent("http://opcfoundation.org/UA/", "ProgramDiagnostics").ifPresent(n -> n.setValue(new DataValue(new Variant(value))));
    }

    @Override
    public BaseObjectTypeNode getFinalResultDataNode() {
        Optional<ObjectNode> component = this.getObjectComponent("http://opcfoundation.org/UA/", "FinalResultData");
        return component.orElse(null);
    }

    @Override
    public StateTypeNode getReadyNode() {
        Optional<ObjectNode> component = this.getObjectComponent("http://opcfoundation.org/UA/", "Ready");
        return component.orElse(null);
    }

    @Override
    public StateTypeNode getRunningNode() {
        Optional<ObjectNode> component = this.getObjectComponent("http://opcfoundation.org/UA/", "Running");
        return component.orElse(null);
    }

    @Override
    public StateTypeNode getSuspendedNode() {
        Optional<ObjectNode> component = this.getObjectComponent("http://opcfoundation.org/UA/", "Suspended");
        return component.orElse(null);
    }

    @Override
    public StateTypeNode getHaltedNode() {
        Optional<ObjectNode> component = this.getObjectComponent("http://opcfoundation.org/UA/", "Halted");
        return component.orElse(null);
    }

    @Override
    public TransitionTypeNode getHaltedToReadyNode() {
        Optional<ObjectNode> component = this.getObjectComponent("http://opcfoundation.org/UA/", "HaltedToReady");
        return component.orElse(null);
    }

    @Override
    public TransitionTypeNode getReadyToRunningNode() {
        Optional<ObjectNode> component = this.getObjectComponent("http://opcfoundation.org/UA/", "ReadyToRunning");
        return component.orElse(null);
    }

    @Override
    public TransitionTypeNode getRunningToHaltedNode() {
        Optional<ObjectNode> component = this.getObjectComponent("http://opcfoundation.org/UA/", "RunningToHalted");
        return component.orElse(null);
    }

    @Override
    public TransitionTypeNode getRunningToReadyNode() {
        Optional<ObjectNode> component = this.getObjectComponent("http://opcfoundation.org/UA/", "RunningToReady");
        return component.orElse(null);
    }

    @Override
    public TransitionTypeNode getRunningToSuspendedNode() {
        Optional<ObjectNode> component = this.getObjectComponent("http://opcfoundation.org/UA/", "RunningToSuspended");
        return component.orElse(null);
    }

    @Override
    public TransitionTypeNode getSuspendedToRunningNode() {
        Optional<ObjectNode> component = this.getObjectComponent("http://opcfoundation.org/UA/", "SuspendedToRunning");
        return component.orElse(null);
    }

    @Override
    public TransitionTypeNode getSuspendedToHaltedNode() {
        Optional<ObjectNode> component = this.getObjectComponent("http://opcfoundation.org/UA/", "SuspendedToHalted");
        return component.orElse(null);
    }

    @Override
    public TransitionTypeNode getSuspendedToReadyNode() {
        Optional<ObjectNode> component = this.getObjectComponent("http://opcfoundation.org/UA/", "SuspendedToReady");
        return component.orElse(null);
    }

    @Override
    public TransitionTypeNode getReadyToHaltedNode() {
        Optional<ObjectNode> component = this.getObjectComponent("http://opcfoundation.org/UA/", "ReadyToHalted");
        return component.orElse(null);
    }

    @Override
    public UaMethodNode getStartMethodNode() {
        Optional<UaNode> methodNode = this.findNode("http://opcfoundation.org/UA/", "Start", node -> node instanceof UaMethodNode, Reference.HAS_COMPONENT_PREDICATE);
        return methodNode.orElse(null);
    }

    @Override
    public UaMethodNode getSuspendMethodNode() {
        Optional<UaNode> methodNode = this.findNode("http://opcfoundation.org/UA/", "Suspend", node -> node instanceof UaMethodNode, Reference.HAS_COMPONENT_PREDICATE);
        return methodNode.orElse(null);
    }

    @Override
    public UaMethodNode getResumeMethodNode() {
        Optional<UaNode> methodNode = this.findNode("http://opcfoundation.org/UA/", "Resume", node -> node instanceof UaMethodNode, Reference.HAS_COMPONENT_PREDICATE);
        return methodNode.orElse(null);
    }

    @Override
    public UaMethodNode getHaltMethodNode() {
        Optional<UaNode> methodNode = this.findNode("http://opcfoundation.org/UA/", "Halt", node -> node instanceof UaMethodNode, Reference.HAS_COMPONENT_PREDICATE);
        return methodNode.orElse(null);
    }

    @Override
    public UaMethodNode getResetMethodNode() {
        Optional<UaNode> methodNode = this.findNode("http://opcfoundation.org/UA/", "Reset", node -> node instanceof UaMethodNode, Reference.HAS_COMPONENT_PREDICATE);
        return methodNode.orElse(null);
    }
}

