/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.model.nodes.objects;

import java.util.Optional;
import org.eclipse.milo.opcua.sdk.core.nodes.ObjectNode;
import org.eclipse.milo.opcua.sdk.core.nodes.VariableNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.objects.AcknowledgeableConditionTypeNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.objects.ShelvedStateMachineTypeNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.variables.TwoStateVariableTypeNode;
import org.eclipse.milo.opcua.sdk.server.model.types.objects.AlarmConditionType;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNodeContext;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;

public class AlarmConditionTypeNode
extends AcknowledgeableConditionTypeNode
implements AlarmConditionType {
    public AlarmConditionTypeNode(UaNodeContext context, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask) {
        super(context, nodeId, browseName, displayName, description, writeMask, userWriteMask);
    }

    public AlarmConditionTypeNode(UaNodeContext context, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, UByte eventNotifier) {
        super(context, nodeId, browseName, displayName, description, writeMask, userWriteMask, eventNotifier);
    }

    @Override
    public PropertyTypeNode getInputNodeNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(AlarmConditionType.INPUT_NODE);
        return propertyNode.orElse(null);
    }

    @Override
    public NodeId getInputNode() {
        Optional<NodeId> propertyValue = this.getProperty(AlarmConditionType.INPUT_NODE);
        return propertyValue.orElse(null);
    }

    @Override
    public void setInputNode(NodeId value) {
        this.setProperty(AlarmConditionType.INPUT_NODE, value);
    }

    @Override
    public PropertyTypeNode getSuppressedOrShelvedNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(AlarmConditionType.SUPPRESSED_OR_SHELVED);
        return propertyNode.orElse(null);
    }

    @Override
    public Boolean getSuppressedOrShelved() {
        Optional<Boolean> propertyValue = this.getProperty(AlarmConditionType.SUPPRESSED_OR_SHELVED);
        return propertyValue.orElse(null);
    }

    @Override
    public void setSuppressedOrShelved(Boolean value) {
        this.setProperty(AlarmConditionType.SUPPRESSED_OR_SHELVED, value);
    }

    @Override
    public PropertyTypeNode getMaxTimeShelvedNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(AlarmConditionType.MAX_TIME_SHELVED);
        return propertyNode.orElse(null);
    }

    @Override
    public Double getMaxTimeShelved() {
        Optional<Double> propertyValue = this.getProperty(AlarmConditionType.MAX_TIME_SHELVED);
        return propertyValue.orElse(null);
    }

    @Override
    public void setMaxTimeShelved(Double value) {
        this.setProperty(AlarmConditionType.MAX_TIME_SHELVED, value);
    }

    @Override
    public TwoStateVariableTypeNode getEnabledStateNode() {
        Optional<VariableNode> component = this.getVariableComponent("http://opcfoundation.org/UA/", "EnabledState");
        return component.orElse(null);
    }

    @Override
    public LocalizedText getEnabledState() {
        Optional<VariableNode> component = this.getVariableComponent("http://opcfoundation.org/UA/", "EnabledState");
        return component.map(node -> (LocalizedText)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public void setEnabledState(LocalizedText value) {
        this.getVariableComponent("http://opcfoundation.org/UA/", "EnabledState").ifPresent(n -> n.setValue(new DataValue(new Variant(value))));
    }

    @Override
    public TwoStateVariableTypeNode getActiveStateNode() {
        Optional<VariableNode> component = this.getVariableComponent("http://opcfoundation.org/UA/", "ActiveState");
        return component.orElse(null);
    }

    @Override
    public LocalizedText getActiveState() {
        Optional<VariableNode> component = this.getVariableComponent("http://opcfoundation.org/UA/", "ActiveState");
        return component.map(node -> (LocalizedText)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public void setActiveState(LocalizedText value) {
        this.getVariableComponent("http://opcfoundation.org/UA/", "ActiveState").ifPresent(n -> n.setValue(new DataValue(new Variant(value))));
    }

    @Override
    public TwoStateVariableTypeNode getSuppressedStateNode() {
        Optional<VariableNode> component = this.getVariableComponent("http://opcfoundation.org/UA/", "SuppressedState");
        return component.orElse(null);
    }

    @Override
    public LocalizedText getSuppressedState() {
        Optional<VariableNode> component = this.getVariableComponent("http://opcfoundation.org/UA/", "SuppressedState");
        return component.map(node -> (LocalizedText)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public void setSuppressedState(LocalizedText value) {
        this.getVariableComponent("http://opcfoundation.org/UA/", "SuppressedState").ifPresent(n -> n.setValue(new DataValue(new Variant(value))));
    }

    @Override
    public ShelvedStateMachineTypeNode getShelvingStateNode() {
        Optional<ObjectNode> component = this.getObjectComponent("http://opcfoundation.org/UA/", "ShelvingState");
        return component.orElse(null);
    }
}

