/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.events.operators;

import org.eclipse.milo.opcua.sdk.server.events.FilterContext;
import org.eclipse.milo.opcua.sdk.server.events.OperatorContext;
import org.eclipse.milo.opcua.sdk.server.events.ValidationException;
import org.eclipse.milo.opcua.sdk.server.events.conversions.ImplicitConversions;
import org.eclipse.milo.opcua.sdk.server.events.operators.Operator;
import org.eclipse.milo.opcua.sdk.server.model.nodes.objects.BaseEventTypeNode;
import org.eclipse.milo.opcua.stack.core.BuiltinDataType;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.FilterOperand;
import org.jetbrains.annotations.Nullable;

public class Cast
implements Operator<Object> {
    Cast() {
    }

    @Override
    public void validate(FilterContext context, FilterOperand[] operands) throws ValidationException {
        if (operands.length < 2) {
            throw new ValidationException(2160263168L);
        }
    }

    @Override
    @Nullable
    public Object apply(OperatorContext context, BaseEventTypeNode eventNode, FilterOperand[] operands) throws UaException {
        this.validate(context, operands);
        FilterOperand op0 = operands[0];
        FilterOperand op1 = operands[1];
        Object sourceValue = context.resolve(op0, eventNode);
        Object dataTypeIdObject = context.resolve(op1, eventNode);
        if (dataTypeIdObject instanceof NodeId) {
            NodeId dataTypeId = (NodeId)dataTypeIdObject;
            BuiltinDataType dataType = BuiltinDataType.fromNodeId(dataTypeId);
            if (dataType != null) {
                return ImplicitConversions.convert(sourceValue, dataType);
            }
            return null;
        }
        if (dataTypeIdObject instanceof ExpandedNodeId) {
            ExpandedNodeId dataTypeId = (ExpandedNodeId)dataTypeIdObject;
            BuiltinDataType dataType = BuiltinDataType.fromNodeId(dataTypeId);
            if (dataType != null) {
                return ImplicitConversions.convert(sourceValue, dataType);
            }
            return null;
        }
        return null;
    }
}

