/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.events.conversions;

import org.eclipse.milo.opcua.stack.core.BuiltinDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.ULong;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class StatusCodeConversions {
    private StatusCodeConversions() {
    }

    @NotNull
    static Short statusCodeToInt16(@NotNull StatusCode s) {
        return (short)(s.getValue() >>> 16 & 0xFFFFL);
    }

    @NotNull
    static Integer statusCodeToInt32(@NotNull StatusCode s) {
        return (int)s.getValue();
    }

    @NotNull
    static Long statusCodeToInt64(@NotNull StatusCode s) {
        return s.getValue();
    }

    @NotNull
    static UShort statusCodeToUInt16(@NotNull StatusCode s) {
        return Unsigned.ushort(StatusCodeConversions.statusCodeToInt16(s));
    }

    @NotNull
    static UInteger statusCodeToUInt32(@NotNull StatusCode s) {
        return Unsigned.uint(StatusCodeConversions.statusCodeToInt32(s));
    }

    @NotNull
    static ULong statusCodeToUInt64(@NotNull StatusCode s) {
        return Unsigned.ulong(s.getValue());
    }

    @Nullable
    static Object convert(@NotNull Object o, BuiltinDataType targetType, boolean implicit) {
        if (o instanceof StatusCode) {
            StatusCode s = (StatusCode)o;
            return implicit ? StatusCodeConversions.implicitConversion(s, targetType) : StatusCodeConversions.explicitConversion(s, targetType);
        }
        return null;
    }

    @Nullable
    static Object explicitConversion(@NotNull StatusCode s, BuiltinDataType targetType) {
        switch (targetType) {
            case Int16: {
                return StatusCodeConversions.statusCodeToInt16(s);
            }
            case UInt16: {
                return StatusCodeConversions.statusCodeToUInt16(s);
            }
        }
        return StatusCodeConversions.implicitConversion(s, targetType);
    }

    @Nullable
    static Object implicitConversion(@NotNull StatusCode s, BuiltinDataType targetType) {
        switch (targetType) {
            case Int32: {
                return StatusCodeConversions.statusCodeToInt32(s);
            }
            case Int64: {
                return StatusCodeConversions.statusCodeToInt64(s);
            }
            case UInt32: {
                return StatusCodeConversions.statusCodeToUInt32(s);
            }
            case UInt64: {
                return StatusCodeConversions.statusCodeToUInt64(s);
            }
        }
        return null;
    }
}

