/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.events.conversions;

import org.eclipse.milo.opcua.stack.core.BuiltinDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.ULong;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class Int64Conversions {
    private Int64Conversions() {
    }

    @NotNull
    static Boolean int64ToBoolean(@NotNull Long l) {
        return l != 0L;
    }

    @Nullable
    static UByte int64ToByte(@NotNull Long l) {
        if (l >= 0L && l <= 255L) {
            return Unsigned.ubyte(l);
        }
        return null;
    }

    @NotNull
    static Double int64ToDouble(@NotNull Long l) {
        return l.doubleValue();
    }

    @NotNull
    static Float int64ToFloat(@NotNull Long l) {
        return Float.valueOf(l.floatValue());
    }

    @Nullable
    static Short int64ToInt16(@NotNull Long l) {
        if (l >= -32768L && l <= 32767L) {
            return l.shortValue();
        }
        return null;
    }

    @Nullable
    static Integer int64ToInt32(@NotNull Long l) {
        if (l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE) {
            return l.intValue();
        }
        return null;
    }

    @Nullable
    static Byte int64ToSByte(@NotNull Long l) {
        if (l >= -128L && l <= 127L) {
            return l.byteValue();
        }
        return null;
    }

    @NotNull
    static StatusCode int64ToStatusCode(@NotNull Long l) {
        return new StatusCode(l);
    }

    @NotNull
    static String int64ToString(@NotNull Long l) {
        return l.toString();
    }

    @Nullable
    static UShort int64ToUInt16(@NotNull Long l) {
        if (l >= 0L && l <= 65535L) {
            return Unsigned.ushort(l.intValue());
        }
        return null;
    }

    @Nullable
    static UInteger int64ToUInt32(@NotNull Long l) {
        if (l >= 0L && l <= 0xFFFFFFFFL) {
            return Unsigned.uint(l);
        }
        return null;
    }

    @Nullable
    static ULong int64ToUInt64(@NotNull Long l) {
        if (l >= 0L) {
            return Unsigned.ulong(l);
        }
        return null;
    }

    @Nullable
    static Object convert(@Nullable Object o, BuiltinDataType targetType, boolean implicit) {
        if (o instanceof Long) {
            Long l = (Long)o;
            return implicit ? Int64Conversions.implicitConversion(l, targetType) : Int64Conversions.explicitConversion(l, targetType);
        }
        return null;
    }

    @Nullable
    static Object explicitConversion(@NotNull Long l, BuiltinDataType targetType) {
        switch (targetType) {
            case Boolean: {
                return Int64Conversions.int64ToBoolean(l);
            }
            case Byte: {
                return Int64Conversions.int64ToByte(l);
            }
            case Int16: {
                return Int64Conversions.int64ToInt16(l);
            }
            case Int32: {
                return Int64Conversions.int64ToInt32(l);
            }
            case SByte: {
                return Int64Conversions.int64ToSByte(l);
            }
            case StatusCode: {
                return Int64Conversions.int64ToStatusCode(l);
            }
            case String: {
                return Int64Conversions.int64ToString(l);
            }
            case UInt16: {
                return Int64Conversions.int64ToUInt16(l);
            }
            case UInt32: {
                return Int64Conversions.int64ToUInt32(l);
            }
            case UInt64: {
                return Int64Conversions.int64ToUInt64(l);
            }
        }
        return Int64Conversions.implicitConversion(l, targetType);
    }

    @Nullable
    static Object implicitConversion(@NotNull Long l, BuiltinDataType targetType) {
        switch (targetType) {
            case Double: {
                return Int64Conversions.int64ToDouble(l);
            }
            case Float: {
                return Int64Conversions.int64ToFloat(l);
            }
        }
        return null;
    }
}

