/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.events.conversions;

import org.eclipse.milo.opcua.stack.core.BuiltinDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.ULong;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class FloatConversions {
    private FloatConversions() {
    }

    @NotNull
    static Boolean floatToBoolean(@NotNull Float f) {
        return f.floatValue() != 0.0f;
    }

    @Nullable
    static UByte floatToByte(@NotNull Float f) {
        long rounded = Math.round(f.floatValue());
        if (rounded >= 0L && rounded <= 255L) {
            return Unsigned.ubyte(rounded);
        }
        return null;
    }

    @NotNull
    static Double floatToDouble(@NotNull Float f) {
        return f.doubleValue();
    }

    @Nullable
    static Short floatToInt16(@NotNull Float f) {
        long rounded = Math.round(f.floatValue());
        if (rounded >= -32768L && rounded <= 32767L) {
            return (short)rounded;
        }
        return null;
    }

    @NotNull
    static Integer floatToInt32(@NotNull Float f) {
        return Math.round(f.floatValue());
    }

    @NotNull
    static Long floatToInt64(@NotNull Float f) {
        return Math.round(f.floatValue());
    }

    @Nullable
    static Byte floatToSByte(@NotNull Float f) {
        long rounded = Math.round(f.floatValue());
        if (rounded >= -128L && rounded <= 127L) {
            return (byte)rounded;
        }
        return null;
    }

    @NotNull
    static String floatToString(@NotNull Float f) {
        return f.toString();
    }

    @Nullable
    static UShort floatToUInt16(@NotNull Float f) {
        long rounded = Math.round(f.floatValue());
        if (rounded >= 0L && rounded <= 65535L) {
            return Unsigned.ushort((int)rounded);
        }
        return null;
    }

    @Nullable
    static UInteger floatToUInt32(@NotNull Float f) {
        int rounded = Math.round(f.floatValue());
        if (rounded >= 0) {
            return Unsigned.uint(rounded);
        }
        return null;
    }

    @Nullable
    static ULong floatToUInt64(@NotNull Float f) {
        long rounded = Math.round(f.floatValue());
        if (rounded >= 0L) {
            return Unsigned.ulong(rounded);
        }
        return null;
    }

    @Nullable
    static Object convert(@Nullable Object o, BuiltinDataType targetType, boolean implicit) {
        if (o instanceof Float) {
            Float f = (Float)o;
            return implicit ? FloatConversions.implicitConversion(f, targetType) : FloatConversions.explicitConversion(f, targetType);
        }
        return null;
    }

    @Nullable
    static Object explicitConversion(@NotNull Float f, BuiltinDataType targetType) {
        switch (targetType) {
            case Boolean: {
                return FloatConversions.floatToBoolean(f);
            }
            case Byte: {
                return FloatConversions.floatToByte(f);
            }
            case Int16: {
                return FloatConversions.floatToInt16(f);
            }
            case Int32: {
                return FloatConversions.floatToInt32(f);
            }
            case Int64: {
                return FloatConversions.floatToInt64(f);
            }
            case SByte: {
                return FloatConversions.floatToSByte(f);
            }
            case String: {
                return FloatConversions.floatToString(f);
            }
            case UInt16: {
                return FloatConversions.floatToUInt16(f);
            }
            case UInt32: {
                return FloatConversions.floatToUInt32(f);
            }
            case UInt64: {
                return FloatConversions.floatToUInt64(f);
            }
        }
        return FloatConversions.implicitConversion(f, targetType);
    }

    @Nullable
    static Object implicitConversion(@NotNull Float f, BuiltinDataType targetType) {
        switch (targetType) {
            case Double: {
                return FloatConversions.floatToDouble(f);
            }
        }
        return null;
    }
}

