/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.diagnostics.objects;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.UUID;
import org.eclipse.milo.opcua.sdk.core.Reference;
import org.eclipse.milo.opcua.sdk.server.AbstractLifecycle;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.Session;
import org.eclipse.milo.opcua.sdk.server.SessionListener;
import org.eclipse.milo.opcua.sdk.server.api.NodeManager;
import org.eclipse.milo.opcua.sdk.server.diagnostics.objects.SessionDiagnosticsObject;
import org.eclipse.milo.opcua.sdk.server.diagnostics.variables.SessionDiagnosticsVariableArray;
import org.eclipse.milo.opcua.sdk.server.diagnostics.variables.SessionSecurityDiagnosticsVariableArray;
import org.eclipse.milo.opcua.sdk.server.model.nodes.objects.SessionDiagnosticsObjectTypeNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.objects.SessionsDiagnosticsSummaryTypeNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNodeContext;
import org.eclipse.milo.opcua.sdk.server.nodes.factories.NodeFactory;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionsDiagnosticsSummaryObject
extends AbstractLifecycle {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<NodeId, SessionDiagnosticsObject> sessionDiagnosticsObjects = Maps.newConcurrentMap();
    private SessionDiagnosticsVariableArray sessionDiagnosticsVariableArray;
    private SessionSecurityDiagnosticsVariableArray sessionSecurityDiagnosticsVariableArray;
    private SessionListener sessionListener;
    private final OpcUaServer server;
    private final NodeFactory nodeFactory;
    private final NodeManager<UaNode> diagnosticsNodeManager;
    private final SessionsDiagnosticsSummaryTypeNode node;

    public SessionsDiagnosticsSummaryObject(SessionsDiagnosticsSummaryTypeNode node, final NodeManager<UaNode> diagnosticsNodeManager) {
        this.node = node;
        this.diagnosticsNodeManager = diagnosticsNodeManager;
        this.server = node.getNodeContext().getServer();
        this.nodeFactory = new NodeFactory(new UaNodeContext(){

            @Override
            public OpcUaServer getServer() {
                return SessionsDiagnosticsSummaryObject.this.server;
            }

            @Override
            public NodeManager<UaNode> getNodeManager() {
                return diagnosticsNodeManager;
            }
        });
    }

    @Override
    protected void onStartup() {
        this.sessionDiagnosticsVariableArray = new SessionDiagnosticsVariableArray(this.node.getSessionDiagnosticsArrayNode(), this.diagnosticsNodeManager);
        this.sessionDiagnosticsVariableArray.startup();
        this.sessionSecurityDiagnosticsVariableArray = new SessionSecurityDiagnosticsVariableArray(this.node.getSessionSecurityDiagnosticsArrayNode(), this.diagnosticsNodeManager);
        this.sessionSecurityDiagnosticsVariableArray.startup();
        this.server.getSessionManager().getAllSessions().forEach(this::createSessionDiagnosticsObject);
        this.sessionListener = new SessionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSessionCreated(Session session) {
                SessionsDiagnosticsSummaryObject sessionsDiagnosticsSummaryObject = SessionsDiagnosticsSummaryObject.this;
                synchronized (sessionsDiagnosticsSummaryObject) {
                    SessionsDiagnosticsSummaryObject.this.createSessionDiagnosticsObject(session);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSessionClosed(Session session) {
                SessionsDiagnosticsSummaryObject sessionsDiagnosticsSummaryObject = SessionsDiagnosticsSummaryObject.this;
                synchronized (sessionsDiagnosticsSummaryObject) {
                    SessionDiagnosticsObject sdo = (SessionDiagnosticsObject)SessionsDiagnosticsSummaryObject.this.sessionDiagnosticsObjects.remove(session.getSessionId());
                    if (sdo != null) {
                        sdo.shutdown();
                    }
                }
            }
        };
        this.server.getSessionManager().addSessionListener(this.sessionListener);
    }

    private void createSessionDiagnosticsObject(Session session) {
        try {
            SessionDiagnosticsObjectTypeNode sdoNode = (SessionDiagnosticsObjectTypeNode)this.nodeFactory.createNode(new NodeId(1, UUID.randomUUID()), Identifiers.SessionDiagnosticsObjectType);
            sdoNode.setBrowseName(new QualifiedName(1, session.getSessionName()));
            sdoNode.setDisplayName(LocalizedText.english(session.getSessionName()));
            sdoNode.addReference(new Reference(sdoNode.getNodeId(), Identifiers.HasComponent, this.node.getNodeId().expanded(), Reference.Direction.INVERSE));
            this.diagnosticsNodeManager.addNode(sdoNode);
            SessionDiagnosticsObject sdo = new SessionDiagnosticsObject(sdoNode, session, this.diagnosticsNodeManager);
            this.sessionDiagnosticsObjects.put(session.getSessionId(), sdo);
            sdo.startup();
        }
        catch (UaException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void onShutdown() {
        this.logger.debug("SessionsDiagnosticsSummaryObject onShutdown()");
        if (this.sessionListener != null) {
            this.server.getSessionManager().removeSessionListener(this.sessionListener);
        }
        this.sessionDiagnosticsVariableArray.shutdown();
        this.sessionSecurityDiagnosticsVariableArray.shutdown();
        this.sessionDiagnosticsObjects.values().forEach(AbstractLifecycle::shutdown);
        this.sessionDiagnosticsObjects.clear();
        this.node.delete();
    }
}

