/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.diagnostics;

import java.util.Objects;
import org.eclipse.milo.opcua.sdk.server.Session;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MessageSecurityMode;
import org.eclipse.milo.opcua.stack.core.types.structured.SessionSecurityDiagnosticsDataType;
import org.eclipse.milo.opcua.stack.core.util.EndpointUtil;

public class SessionSecurityDiagnostics {
    private final Session session;

    public SessionSecurityDiagnostics(Session session) {
        this.session = session;
    }

    public NodeId getSessionId() {
        return this.session.getSessionId();
    }

    public String getClientUserIdOfSession() {
        return this.session.getClientUserId();
    }

    public String[] getClientUserIdHistory() {
        return this.session.getClientUserIdHistory().toArray(new String[0]);
    }

    public String getAuthenticationMechanism() {
        return Objects.toString(this.session.getTokenType());
    }

    public String getEncoding() {
        return "UA Binary";
    }

    public String getTransportProtocol() {
        String endpointUrl = this.session.getEndpoint().getEndpointUrl();
        return EndpointUtil.getScheme(endpointUrl);
    }

    public MessageSecurityMode getSecurityMode() {
        return this.session.getSecurityConfiguration().getSecurityMode();
    }

    public String getSecurityPolicyUri() {
        return this.session.getSecurityConfiguration().getSecurityPolicy().getUri();
    }

    public ByteString getClientCertificate() {
        try {
            return this.session.getSecurityConfiguration().getClientCertificateBytes();
        }
        catch (UaException e) {
            return ByteString.NULL_VALUE;
        }
    }

    public SessionSecurityDiagnosticsDataType getSessionSecurityDiagnosticsDataType() {
        return new SessionSecurityDiagnosticsDataType(this.getSessionId(), this.getClientUserIdOfSession(), this.getClientUserIdHistory(), this.getAuthenticationMechanism(), this.getEncoding(), this.getTransportProtocol(), this.getSecurityMode(), this.getSecurityPolicyUri(), this.getClientCertificate());
    }
}

