/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.eventbus.EventBus;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Stream;
import org.eclipse.milo.opcua.sdk.core.ServerTable;
import org.eclipse.milo.opcua.sdk.server.ObjectTypeManager;
import org.eclipse.milo.opcua.sdk.server.SessionManager;
import org.eclipse.milo.opcua.sdk.server.VariableTypeManager;
import org.eclipse.milo.opcua.sdk.server.api.AddressSpaceManager;
import org.eclipse.milo.opcua.sdk.server.api.config.OpcUaServerConfig;
import org.eclipse.milo.opcua.sdk.server.diagnostics.ServerDiagnosticsSummary;
import org.eclipse.milo.opcua.sdk.server.model.ObjectTypeInitializer;
import org.eclipse.milo.opcua.sdk.server.model.VariableTypeInitializer;
import org.eclipse.milo.opcua.sdk.server.namespaces.OpcUaNamespace;
import org.eclipse.milo.opcua.sdk.server.namespaces.ServerNamespace;
import org.eclipse.milo.opcua.sdk.server.nodes.factories.EventFactory;
import org.eclipse.milo.opcua.sdk.server.subscriptions.Subscription;
import org.eclipse.milo.opcua.stack.core.BuiltinReferenceType;
import org.eclipse.milo.opcua.stack.core.NamespaceTable;
import org.eclipse.milo.opcua.stack.core.ReferenceType;
import org.eclipse.milo.opcua.stack.core.Stack;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.types.DataTypeManager;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.EndpointDescription;
import org.eclipse.milo.opcua.stack.core.util.EndpointUtil;
import org.eclipse.milo.opcua.stack.core.util.ManifestUtil;
import org.eclipse.milo.opcua.stack.server.UaStackServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpcUaServer {
    public static final String SDK_VERSION = ManifestUtil.read("X-SDK-Version").orElse("dev");
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<NodeId, ReferenceType> referenceTypes = Maps.newConcurrentMap();
    private final Map<UInteger, Subscription> subscriptions = Maps.newConcurrentMap();
    private final ServerTable serverTable = new ServerTable();
    private final AddressSpaceManager addressSpaceManager = new AddressSpaceManager(this);
    private final SessionManager sessionManager = new SessionManager(this);
    private final ObjectTypeManager objectTypeManager = new ObjectTypeManager();
    private final VariableTypeManager variableTypeManager = new VariableTypeManager();
    private final Set<NodeId> registeredViews = Sets.newConcurrentHashSet();
    private final ServerDiagnosticsSummary diagnosticsSummary = new ServerDiagnosticsSummary(this);
    private final EventBus eventBus = new EventBus("server");
    private final EventFactory eventFactory = new EventFactory(this);
    private final UaStackServer stackServer;
    private final OpcUaNamespace opcUaNamespace;
    private final ServerNamespace serverNamespace;
    private final OpcUaServerConfig config;

    public OpcUaServer(OpcUaServerConfig config) {
        this.config = config;
        this.stackServer = new UaStackServer(config);
        Stream<String> paths = this.stackServer.getConfig().getEndpoints().stream().map(e -> EndpointUtil.getPath(e.getEndpointUrl())).distinct();
        paths.filter(path -> !path.endsWith("/discovery")).forEach(path -> {
            this.stackServer.addServiceSet((String)path, this.sessionManager);
            this.stackServer.addServiceSet((String)path, this.sessionManager);
            this.stackServer.addServiceSet((String)path, this.sessionManager);
            this.stackServer.addServiceSet((String)path, this.sessionManager);
            this.stackServer.addServiceSet((String)path, this.sessionManager);
            this.stackServer.addServiceSet((String)path, this.sessionManager);
            this.stackServer.addServiceSet((String)path, this.sessionManager);
            this.stackServer.addServiceSet((String)path, this.sessionManager);
        });
        ObjectTypeInitializer.initialize(this.stackServer.getNamespaceTable(), this.objectTypeManager);
        VariableTypeInitializer.initialize(this.stackServer.getNamespaceTable(), this.variableTypeManager);
        this.opcUaNamespace = new OpcUaNamespace(this);
        this.opcUaNamespace.startup();
        this.serverNamespace = new ServerNamespace(this);
        this.serverNamespace.startup();
        this.serverTable.addUri(this.stackServer.getConfig().getApplicationUri());
        for (BuiltinReferenceType referenceType : BuiltinReferenceType.values()) {
            this.referenceTypes.put(referenceType.getNodeId(), referenceType);
        }
    }

    public OpcUaServerConfig getConfig() {
        return this.config;
    }

    public CompletableFuture<OpcUaServer> startup() {
        this.eventFactory.startup();
        return this.stackServer.startup().thenApply(s -> this);
    }

    public CompletableFuture<OpcUaServer> shutdown() {
        this.serverNamespace.shutdown();
        this.opcUaNamespace.shutdown();
        this.eventFactory.shutdown();
        this.subscriptions.values().forEach(Subscription::deleteSubscription);
        return this.stackServer.shutdown().thenApply(s -> this);
    }

    public UaStackServer getStackServer() {
        return this.stackServer;
    }

    public AddressSpaceManager getAddressSpaceManager() {
        return this.addressSpaceManager;
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public OpcUaNamespace getOpcUaNamespace() {
        return this.opcUaNamespace;
    }

    public ServerNamespace getServerNamespace() {
        return this.serverNamespace;
    }

    public ServerTable getServerTable() {
        return this.serverTable;
    }

    public DataTypeManager getDataTypeManager() {
        return this.stackServer.getDataTypeManager();
    }

    public NamespaceTable getNamespaceTable() {
        return this.stackServer.getNamespaceTable();
    }

    public SerializationContext getSerializationContext() {
        return this.stackServer.getSerializationContext();
    }

    public ServerDiagnosticsSummary getDiagnosticsSummary() {
        return this.diagnosticsSummary;
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }

    public EventFactory getEventFactory() {
        return this.eventFactory;
    }

    public ObjectTypeManager getObjectTypeManager() {
        return this.objectTypeManager;
    }

    public VariableTypeManager getVariableTypeManager() {
        return this.variableTypeManager;
    }

    public Set<NodeId> getRegisteredViews() {
        return this.registeredViews;
    }

    public Map<UInteger, Subscription> getSubscriptions() {
        return this.subscriptions;
    }

    public Optional<KeyPair> getKeyPair(ByteString thumbprint) {
        return this.stackServer.getConfig().getCertificateManager().getKeyPair(thumbprint);
    }

    public Optional<X509Certificate> getCertificate(ByteString thumbprint) {
        return this.stackServer.getConfig().getCertificateManager().getCertificate(thumbprint);
    }

    public Optional<X509Certificate[]> getCertificateChain(ByteString thumbprint) {
        return this.stackServer.getConfig().getCertificateManager().getCertificateChain(thumbprint);
    }

    public ExecutorService getExecutorService() {
        return this.stackServer.getConfig().getExecutor();
    }

    public ScheduledExecutorService getScheduledExecutorService() {
        return this.config.getScheduledExecutorService();
    }

    public ImmutableList<EndpointDescription> getEndpointDescriptions() {
        return this.stackServer.getEndpointDescriptions();
    }

    public Map<NodeId, ReferenceType> getReferenceTypes() {
        return this.referenceTypes;
    }

    static {
        Logger logger = LoggerFactory.getLogger(OpcUaServer.class);
        logger.info("Java version: " + System.getProperty("java.version"));
        logger.info("Eclipse Milo OPC UA Stack version: {}", (Object)Stack.VERSION);
        logger.info("Eclipse Milo OPC UA Server SDK version: {}", (Object)SDK_VERSION);
    }
}

