/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.core;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import org.eclipse.milo.opcua.stack.core.BuiltinDataType;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UNumber;
import org.eclipse.milo.opcua.stack.core.util.Tree;
import org.jetbrains.annotations.Nullable;

public class DataTypeTree {
    private final Map<NodeId, Tree<DataType>> dataTypes = Maps.newConcurrentMap();
    private final Tree<DataType> tree;

    public DataTypeTree(Tree<DataType> tree) {
        this.tree = tree;
        tree.traverseNodes(treeNode -> this.dataTypes.put(((DataType)treeNode.getValue()).getNodeId(), (Tree<DataType>)treeNode));
    }

    public Class<?> getBackingClass(NodeId dataTypeId) {
        Tree<DataType> parent;
        if (BuiltinDataType.isBuiltin(dataTypeId)) {
            return BuiltinDataType.getBackingClass(dataTypeId);
        }
        if (Identifiers.Enumeration.equals(dataTypeId)) {
            return Integer.class;
        }
        if (Identifiers.Number.equals(dataTypeId)) {
            return Number.class;
        }
        if (Identifiers.Integer.equals(dataTypeId)) {
            return Number.class;
        }
        if (Identifiers.UInteger.equals(dataTypeId)) {
            return UNumber.class;
        }
        Tree<DataType> node = this.dataTypes.get(dataTypeId);
        Tree<DataType> tree = parent = node != null ? node.getParent() : null;
        if (parent != null) {
            return this.getBackingClass(parent.getValue().getNodeId());
        }
        return Object.class;
    }

    public BuiltinDataType getBuiltinType(NodeId dataTypeId) {
        Tree<DataType> parent;
        if (BuiltinDataType.isBuiltin(dataTypeId)) {
            return BuiltinDataType.fromNodeId(dataTypeId);
        }
        Tree<DataType> node = this.dataTypes.get(dataTypeId);
        Tree<DataType> tree = parent = node != null ? node.getParent() : null;
        if (parent != null) {
            return this.getBuiltinType(parent.getValue().getNodeId());
        }
        return BuiltinDataType.Variant;
    }

    @Nullable
    public DataType getDataType(NodeId dataTypeId) {
        Tree<DataType> node = this.dataTypes.get(dataTypeId);
        return node != null ? node.getValue() : null;
    }

    @Nullable
    public NodeId getBinaryEncodingId(NodeId dataTypeId) {
        DataType dataType = this.getDataType(dataTypeId);
        return dataType != null ? dataType.getBinaryEncodingId() : null;
    }

    @Nullable
    public NodeId getXmlEncodingId(NodeId dataTypeId) {
        DataType dataType = this.getDataType(dataTypeId);
        return dataType != null ? dataType.getXmlEncodingId() : null;
    }

    public boolean isAssignable(NodeId dataTypeId, Class<?> clazz) {
        Class<?> backingClass = this.getBackingClass(dataTypeId);
        if (Identifiers.Integer.equals(dataTypeId)) {
            return clazz == Byte.TYPE || clazz == Byte.class || clazz == Short.TYPE || clazz == Short.class || clazz == Integer.TYPE || clazz == Integer.class || clazz == Long.TYPE || clazz == Long.class;
        }
        if (Identifiers.UInteger.equals(dataTypeId)) {
            return UNumber.class.isAssignableFrom(clazz);
        }
        return backingClass.isAssignableFrom(clazz);
    }

    public Tree<DataType> getTree() {
        return this.tree;
    }

    @Nullable
    public Tree<DataType> getTreeNode(NodeId dataTypeId) {
        return this.dataTypes.get(dataTypeId);
    }

    public static class DataType {
        private final QualifiedName browseName;
        private final NodeId nodeId;
        private final NodeId binaryEncodingId;
        private final NodeId xmlEncodingId;

        public DataType(QualifiedName browseName, NodeId nodeId, NodeId binaryEncodingId, NodeId xmlEncodingId) {
            this.browseName = browseName;
            this.nodeId = nodeId;
            this.binaryEncodingId = binaryEncodingId;
            this.xmlEncodingId = xmlEncodingId;
        }

        public QualifiedName getBrowseName() {
            return this.browseName;
        }

        public NodeId getNodeId() {
            return this.nodeId;
        }

        @Nullable
        public NodeId getBinaryEncodingId() {
            return this.binaryEncodingId;
        }

        @Nullable
        public NodeId getXmlEncodingId() {
            return this.xmlEncodingId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DataType dataType = (DataType)o;
            return this.browseName.equals(dataType.browseName) && this.nodeId.equals(dataType.nodeId) && Objects.equals(this.binaryEncodingId, dataType.binaryEncodingId) && Objects.equals(this.xmlEncodingId, dataType.xmlEncodingId);
        }

        public int hashCode() {
            return Objects.hash(this.browseName, this.nodeId, this.binaryEncodingId, this.xmlEncodingId);
        }

        public String toString() {
            return "DataType{browseName=" + this.browseName + ", nodeId=" + this.nodeId + ", binaryEncodingId=" + this.binaryEncodingId + ", xmlEncodingId=" + this.xmlEncodingId + '}';
        }
    }
}

