/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.subscriptions;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.api.subscriptions.UaMonitoredItem;
import org.eclipse.milo.opcua.sdk.client.nodes.UaVariableNode;
import org.eclipse.milo.opcua.sdk.client.subscriptions.BatchItemResult;
import org.eclipse.milo.opcua.sdk.client.subscriptions.ManagedSubscription;
import org.eclipse.milo.opcua.sdk.client.subscriptions.OpcUaMonitoredItem;
import org.eclipse.milo.opcua.sdk.client.subscriptions.OpcUaSubscription;
import org.eclipse.milo.opcua.sdk.core.util.GroupMapCollate;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MonitoringMode;
import org.eclipse.milo.opcua.stack.core.util.FutureUtils;
import org.jetbrains.annotations.Nullable;

public class BatchSetMonitoringMode {
    private final Map<OpcUaMonitoredItem, MonitoringMode> monitoringModesByItem = Collections.synchronizedMap(new LinkedHashMap());
    private final ListMultimap<OpcUaMonitoredItem, CompletableFuture<SetMonitoringModeResult>> futuresByItem = Multimaps.synchronizedListMultimap(ArrayListMultimap.create());
    private final List<CompletableFuture<SetMonitoringModeResult>> resultFutures = Collections.synchronizedList(new ArrayList());
    private final AtomicInteger serviceInvocationCount = new AtomicInteger(0);
    private final OpcUaClient client;
    private final OpcUaSubscription subscription;

    public BatchSetMonitoringMode(ManagedSubscription subscription) {
        this(subscription.getClient(), subscription.getSubscription());
    }

    public BatchSetMonitoringMode(OpcUaClient client, OpcUaSubscription subscription) {
        this.client = client;
        this.subscription = subscription;
    }

    public int getServiceInvocationCount() {
        return this.serviceInvocationCount.get();
    }

    public CompletableFuture<SetMonitoringModeResult> add(OpcUaMonitoredItem monitoredItem, MonitoringMode monitoringMode) {
        this.monitoringModesByItem.put(monitoredItem, monitoringMode);
        CompletableFuture<SetMonitoringModeResult> future = new CompletableFuture<SetMonitoringModeResult>();
        this.futuresByItem.put(monitoredItem, future);
        this.resultFutures.add(future);
        return future;
    }

    public List<SetMonitoringModeResult> execute() throws InterruptedException {
        try {
            return this.executeAsync().get();
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(e);
        }
    }

    public CompletableFuture<List<SetMonitoringModeResult>> executeAsync() {
        return BatchSetMonitoringMode.readOperationLimit(this.client).thenCompose(this::executeAsync);
    }

    private CompletableFuture<List<SetMonitoringModeResult>> executeAsync(UInteger operationLimit) {
        ArrayList<Map.Entry<OpcUaMonitoredItem, MonitoringMode>> entries = new ArrayList<Map.Entry<OpcUaMonitoredItem, MonitoringMode>>(this.monitoringModesByItem.entrySet());
        CompletableFuture resultsFuture = GroupMapCollate.groupMapCollate(entries, Map.Entry::getValue, monitoringMode -> itemsAndModes -> {
            List partitionFutures = Lists.partition(itemsAndModes, operationLimit.intValue()).stream().map(this::setMonitoringModeAsync).collect(Collectors.toList());
            return FutureUtils.flatSequence(partitionFutures);
        });
        return resultsFuture.thenCompose(results -> {
            ArrayList<OpcUaMonitoredItem> items = new ArrayList<OpcUaMonitoredItem>(this.monitoringModesByItem.keySet());
            assert (items.size() == results.size());
            for (int i = 0; i < items.size(); ++i) {
                ArrayList futures;
                OpcUaMonitoredItem item = (OpcUaMonitoredItem)items.get(i);
                SetMonitoringModeResult result = (SetMonitoringModeResult)results.get(i);
                ListMultimap<OpcUaMonitoredItem, CompletableFuture<SetMonitoringModeResult>> listMultimap = this.futuresByItem;
                synchronized (listMultimap) {
                    futures = new ArrayList(this.futuresByItem.get((Object)item));
                }
                futures.forEach(f -> f.complete(result));
            }
            return FutureUtils.sequence(this.resultFutures);
        });
    }

    private CompletableFuture<List<SetMonitoringModeResult>> setMonitoringModeAsync(List<Map.Entry<OpcUaMonitoredItem, MonitoringMode>> itemsAndModes) {
        this.serviceInvocationCount.incrementAndGet();
        MonitoringMode monitoringMode = itemsAndModes.get(0).getValue();
        List<UaMonitoredItem> items = itemsAndModes.stream().map(Map.Entry::getKey).collect(Collectors.toList());
        CompletionStage resultsFuture = this.subscription.setMonitoringMode(monitoringMode, items).thenApply(statusCodes -> statusCodes.stream().map(statusCode -> new SetMonitoringModeResult(StatusCode.GOOD, (StatusCode)statusCode)).collect(Collectors.toList()));
        return ((CompletableFuture)resultsFuture).exceptionally(ex -> {
            StatusCode serviceResult = UaException.extractStatusCode(ex).orElse(new StatusCode(0x80010000L));
            SetMonitoringModeResult result = new SetMonitoringModeResult(serviceResult);
            return Collections.nCopies(items.size(), result);
        });
    }

    private static CompletableFuture<UInteger> readOperationLimit(OpcUaClient client) {
        CompletableFuture<UaVariableNode> nodeFuture = client.getAddressSpace().getVariableNodeAsync(Identifiers.Server_ServerCapabilities_OperationLimits_MaxMonitoredItemsPerCall);
        return nodeFuture.thenCompose(variableNode -> ((CompletableFuture)variableNode.readAttributeAsync(AttributeId.Value).thenApply(v -> (UInteger)v.getValue().getValue())).exceptionally(ex -> Unsigned.uint(1000)));
    }

    public static class SetMonitoringModeResult
    implements BatchItemResult<StatusCode> {
        private final StatusCode serviceResult;
        private final StatusCode operationResult;

        SetMonitoringModeResult(StatusCode serviceResult) {
            this(serviceResult, null);
        }

        SetMonitoringModeResult(StatusCode serviceResult, @Nullable StatusCode operationResult) {
            this.serviceResult = serviceResult;
            this.operationResult = operationResult;
        }

        @Override
        public StatusCode serviceResult() {
            return this.serviceResult;
        }

        @Override
        public Optional<StatusCode> operationResult() {
            return Optional.ofNullable(this.operationResult);
        }

        public boolean isServiceResultGood() {
            return this.serviceResult.isGood();
        }

        public boolean isOperationResultGood() {
            return this.operationResult().map(StatusCode::isGood).orElse(false);
        }
    }
}

