/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.session;

import com.digitalpetri.strictmachine.Fsm;
import com.digitalpetri.strictmachine.FsmContext;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledFuture;
import org.eclipse.milo.opcua.sdk.client.OpcUaSession;
import org.eclipse.milo.opcua.sdk.client.SessionActivityListener;
import org.eclipse.milo.opcua.sdk.client.session.Event;
import org.eclipse.milo.opcua.sdk.client.session.State;
import org.eclipse.milo.opcua.stack.client.UaStackClient;
import org.eclipse.milo.opcua.stack.core.util.Unit;

public class SessionFsm {
    static final String LOGGER_NAME = "org.eclipse.milo.opcua.sdk.client.SessionFsm";
    private final List<SessionInitializer> sessionInitializers;
    private final List<SessionActivityListener> sessionActivityListeners;
    private final Fsm<State, Event> fsm;
    static final FsmContext.Key<Long> KEY_WAIT_TIME = new FsmContext.Key<Long>("delay", Long.class);
    static final FsmContext.Key<ScheduledFuture> KEY_WAIT_FUTURE = new FsmContext.Key<ScheduledFuture>("delayFuture", ScheduledFuture.class);
    static final FsmContext.Key<CloseFuture> KEY_CLOSE_FUTURE = new FsmContext.Key<CloseFuture>("closeFuture", CloseFuture.class);
    static final FsmContext.Key<OpcUaSession> KEY_SESSION = new FsmContext.Key<OpcUaSession>("session", OpcUaSession.class);
    static final FsmContext.Key<SessionFuture> KEY_SESSION_FUTURE = new FsmContext.Key<SessionFuture>("sessionFuture", SessionFuture.class);
    static final FsmContext.Key<Long> KEY_KEEP_ALIVE_FAILURE_COUNT = new FsmContext.Key<Long>("keepAliveFailureCount", Long.class);
    static final FsmContext.Key<ScheduledFuture> KEY_KEEP_ALIVE_SCHEDULED_FUTURE = new FsmContext.Key<ScheduledFuture>("keepAliveScheduledFuture", ScheduledFuture.class);
    static final FsmContext.Key<SessionInitializers> KEY_SESSION_INITIALIZERS = new FsmContext.Key<SessionInitializers>("sessionInitializers", SessionInitializers.class);
    static final FsmContext.Key<SessionActivityListeners> KEY_SESSION_ACTIVITY_LISTENERS = new FsmContext.Key<SessionActivityListeners>("sessionActivityListeners", SessionActivityListeners.class);

    SessionFsm(Fsm<State, Event> fsm) {
        this.fsm = fsm;
        this.sessionInitializers = fsm.getFromContext(ctx -> {
            KEY_SESSION_INITIALIZERS.set((FsmContext<?, ?>)ctx, new SessionInitializers());
            return SessionFsm.KEY_SESSION_INITIALIZERS.get(ctx).sessionInitializers;
        });
        this.sessionActivityListeners = fsm.getFromContext(ctx -> {
            KEY_SESSION_ACTIVITY_LISTENERS.set((FsmContext<?, ?>)ctx, new SessionActivityListeners());
            return SessionFsm.KEY_SESSION_ACTIVITY_LISTENERS.get(ctx).sessionActivityListeners;
        });
    }

    public CompletableFuture<OpcUaSession> openSession() {
        Event.OpenSession openSession = new Event.OpenSession();
        this.fsm.fireEvent(openSession);
        return openSession.future;
    }

    public CompletableFuture<Unit> closeSession() {
        Event.CloseSession closeSession = new Event.CloseSession();
        this.fsm.fireEvent(closeSession);
        return closeSession.future;
    }

    public CompletableFuture<OpcUaSession> getSession() {
        CompletableFuture future = this.fsm.getFromContext(ctx -> {
            State state = (State)((Object)((Object)ctx.currentState()));
            if (state == State.Active) {
                SessionFuture sf = KEY_SESSION_FUTURE.get((FsmContext<?, ?>)ctx);
                assert (sf != null);
                return sf.future;
            }
            return null;
        });
        if (future != null) {
            return future;
        }
        Event.GetSession getSession = new Event.GetSession();
        this.fsm.fireEvent(getSession);
        return getSession.future;
    }

    public void addInitializer(SessionInitializer initializer) {
        this.sessionInitializers.add(initializer);
    }

    public void removeInitializer(SessionInitializer initializer) {
        this.sessionInitializers.remove(initializer);
    }

    public void addActivityListener(SessionActivityListener listener) {
        this.sessionActivityListeners.add(listener);
    }

    public void removeActivityListener(SessionActivityListener listener) {
        this.sessionActivityListeners.remove(listener);
    }

    public static interface SessionInitializer {
        public CompletableFuture<Unit> initialize(UaStackClient var1, OpcUaSession var2);
    }

    static class SessionActivityListeners {
        final List<SessionActivityListener> sessionActivityListeners = new CopyOnWriteArrayList<SessionActivityListener>();

        private SessionActivityListeners() {
        }
    }

    static class SessionInitializers {
        final List<SessionInitializer> sessionInitializers = new CopyOnWriteArrayList<SessionInitializer>();

        private SessionInitializers() {
        }
    }

    static class SessionFuture {
        final CompletableFuture<OpcUaSession> future = new CompletableFuture();

        SessionFuture() {
        }
    }

    static class CloseFuture {
        final CompletableFuture<Unit> future = new CompletableFuture();

        CloseFuture() {
        }
    }
}

