/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.nodes;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaVariableTypeNode;
import org.eclipse.milo.opcua.sdk.core.nodes.VariableNode;
import org.eclipse.milo.opcua.sdk.core.nodes.VariableNodeProperties;
import org.eclipse.milo.opcua.sdk.core.util.StreamUtil;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.BrowseDirection;
import org.eclipse.milo.opcua.stack.core.types.enumerated.BrowseResultMask;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseResult;
import org.eclipse.milo.opcua.stack.core.types.structured.EUInformation;
import org.eclipse.milo.opcua.stack.core.types.structured.ReferenceDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.TimeZoneDataType;
import org.eclipse.milo.opcua.stack.core.util.ConversionUtil;
import org.eclipse.milo.opcua.stack.core.util.FutureUtils;
import org.jetbrains.annotations.Nullable;

public class UaVariableNode
extends UaNode
implements VariableNode {
    private DataValue value;
    private NodeId dataType;
    private Integer valueRank;
    private UInteger[] arrayDimensions;
    private UByte accessLevel;
    private UByte userAccessLevel;
    private Double minimumSamplingInterval;
    private Boolean historizing;

    public UaVariableNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, DataValue value, NodeId dataType, Integer valueRank, UInteger[] arrayDimensions, UByte accessLevel, UByte userAccessLevel, Double minimumSamplingInterval, Boolean historizing) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask);
        this.value = value;
        this.dataType = dataType;
        this.valueRank = valueRank;
        this.arrayDimensions = arrayDimensions;
        this.accessLevel = accessLevel;
        this.userAccessLevel = userAccessLevel;
        this.minimumSamplingInterval = minimumSamplingInterval;
        this.historizing = historizing;
    }

    @Override
    public synchronized DataValue getValue() {
        return this.value;
    }

    @Override
    public synchronized NodeId getDataType() {
        return this.dataType;
    }

    @Override
    public synchronized Integer getValueRank() {
        return this.valueRank;
    }

    @Override
    public synchronized UInteger[] getArrayDimensions() {
        return this.arrayDimensions;
    }

    @Override
    public synchronized UByte getAccessLevel() {
        return this.accessLevel;
    }

    @Override
    public synchronized UByte getUserAccessLevel() {
        return this.userAccessLevel;
    }

    @Override
    public synchronized Double getMinimumSamplingInterval() {
        return this.minimumSamplingInterval;
    }

    @Override
    public synchronized Boolean getHistorizing() {
        return this.historizing;
    }

    @Override
    public synchronized void setValue(DataValue value) {
        this.value = value;
    }

    public synchronized void setValue(Variant variant) {
        this.setValue(DataValue.valueOnly(variant));
    }

    @Override
    public synchronized void setDataType(NodeId dataType) {
        this.dataType = dataType;
    }

    @Override
    public synchronized void setValueRank(Integer valueRank) {
        this.valueRank = valueRank;
    }

    @Override
    public synchronized void setArrayDimensions(UInteger[] arrayDimensions) {
        this.arrayDimensions = arrayDimensions;
    }

    @Override
    public synchronized void setAccessLevel(UByte accessLevel) {
        this.accessLevel = accessLevel;
    }

    @Override
    public synchronized void setUserAccessLevel(UByte userAccessLevel) {
        this.userAccessLevel = userAccessLevel;
    }

    @Override
    public synchronized void setMinimumSamplingInterval(Double minimumSamplingInterval) {
        this.minimumSamplingInterval = minimumSamplingInterval;
    }

    @Override
    public synchronized void setHistorizing(Boolean historizing) {
        this.historizing = historizing;
    }

    public DataValue readValue() throws UaException {
        DataValue value = this.readAttribute(AttributeId.Value);
        this.setValue(value);
        return value;
    }

    public NodeId readDataType() throws UaException {
        DataValue value = this.readAttribute(AttributeId.DataType);
        StatusCode statusCode = value.getStatusCode();
        if (statusCode != null && statusCode.isBad()) {
            throw new UaException(statusCode, "read DataType failed");
        }
        NodeId dataType = (NodeId)value.getValue().getValue();
        this.setDataType(dataType);
        return dataType;
    }

    public Integer readValueRank() throws UaException {
        DataValue value = this.readAttribute(AttributeId.ValueRank);
        StatusCode statusCode = value.getStatusCode();
        if (statusCode != null && statusCode.isBad()) {
            throw new UaException(statusCode, "read ValueRank failed");
        }
        Integer valueRank = (Integer)value.getValue().getValue();
        this.setValueRank(valueRank);
        return valueRank;
    }

    @Nullable
    public UInteger[] readArrayDimensions() throws UaException {
        DataValue value = this.readAttribute(AttributeId.ArrayDimensions);
        StatusCode statusCode = value.getStatusCode();
        if (statusCode != null && statusCode.isBad() && statusCode.getValue() != 2150957056L) {
            throw new UaException(statusCode, "read ArrayDimensions failed");
        }
        UInteger[] arrayDimensions = (UInteger[])value.getValue().getValue();
        this.setArrayDimensions(arrayDimensions);
        return arrayDimensions;
    }

    public UByte readAccessLevel() throws UaException {
        DataValue value = this.readAttribute(AttributeId.AccessLevel);
        StatusCode statusCode = value.getStatusCode();
        if (statusCode != null && statusCode.isBad()) {
            throw new UaException(statusCode, "read AccessLevel failed");
        }
        UByte accessLevel = (UByte)value.getValue().getValue();
        this.setAccessLevel(accessLevel);
        return accessLevel;
    }

    public UByte readUserAccessLevel() throws UaException {
        DataValue value = this.readAttribute(AttributeId.UserAccessLevel);
        StatusCode statusCode = value.getStatusCode();
        if (statusCode != null && statusCode.isBad()) {
            throw new UaException(statusCode, "read UserAccessLevel failed");
        }
        UByte userAccessLevel = (UByte)value.getValue().getValue();
        this.setUserAccessLevel(userAccessLevel);
        return userAccessLevel;
    }

    @Nullable
    public Double readMinimumSamplingInterval() throws UaException {
        DataValue value = this.readAttribute(AttributeId.MinimumSamplingInterval);
        StatusCode statusCode = value.getStatusCode();
        if (statusCode != null && statusCode.isBad() && statusCode.getValue() != 2150957056L) {
            throw new UaException(statusCode, "read MinimumSamplingInterval failed");
        }
        Double minimumSamplingInterval = (Double)value.getValue().getValue();
        this.setMinimumSamplingInterval(minimumSamplingInterval);
        return minimumSamplingInterval;
    }

    public Boolean readHistorizing() throws UaException {
        DataValue value = this.readAttribute(AttributeId.Historizing);
        StatusCode statusCode = value.getStatusCode();
        if (statusCode != null && statusCode.isBad()) {
            throw new UaException(statusCode, "read Historizing failed");
        }
        Boolean historizing = (Boolean)value.getValue().getValue();
        this.setHistorizing(historizing);
        return historizing;
    }

    public void writeValue(DataValue value) throws UaException {
        StatusCode statusCode = this.writeAttribute(AttributeId.Value, value);
        if (statusCode != null && statusCode.isBad()) {
            throw new UaException(statusCode, "write Value failed");
        }
        this.setValue(value);
    }

    public void writeValue(Variant variant) throws UaException {
        this.writeValue(DataValue.valueOnly(variant));
    }

    public void writeDataType(NodeId dataType) throws UaException {
        DataValue value = DataValue.valueOnly(new Variant(dataType));
        StatusCode statusCode = this.writeAttribute(AttributeId.DataType, value);
        if (statusCode != null && statusCode.isBad()) {
            throw new UaException(statusCode, "write DataType failed");
        }
        this.setDataType(dataType);
    }

    public void writeValueRank(Integer valueRank) throws UaException {
        DataValue value = DataValue.valueOnly(new Variant(valueRank));
        StatusCode statusCode = this.writeAttribute(AttributeId.ValueRank, value);
        if (statusCode != null && statusCode.isBad()) {
            throw new UaException(statusCode, "write ValueRank failed");
        }
        this.setValueRank(valueRank);
    }

    public void writeArrayDimensions(UInteger[] arrayDimensions) throws UaException {
        DataValue value = DataValue.valueOnly(new Variant(arrayDimensions));
        StatusCode statusCode = this.writeAttribute(AttributeId.ArrayDimensions, value);
        if (statusCode != null && statusCode.isBad()) {
            throw new UaException(statusCode, "write ArrayDimensions failed");
        }
        this.setArrayDimensions(arrayDimensions);
    }

    public void writeAccessLevel(UByte accessLevel) throws UaException {
        DataValue value = DataValue.valueOnly(new Variant(accessLevel));
        StatusCode statusCode = this.writeAttribute(AttributeId.AccessLevel, value);
        if (statusCode != null && statusCode.isBad()) {
            throw new UaException(statusCode, "write AccessLevel failed");
        }
        this.setAccessLevel(accessLevel);
    }

    public void writeUserAccessLevel(UByte userAccessLevel) throws UaException {
        DataValue value = DataValue.valueOnly(new Variant(userAccessLevel));
        StatusCode statusCode = this.writeAttribute(AttributeId.UserAccessLevel, value);
        if (statusCode != null && statusCode.isBad()) {
            throw new UaException(statusCode, "write UserAccessLevel failed");
        }
        this.setUserAccessLevel(userAccessLevel);
    }

    public void writeMinimumSamplingInterval(Double minimumSamplingInterval) throws UaException {
        DataValue value = DataValue.valueOnly(new Variant(minimumSamplingInterval));
        StatusCode statusCode = this.writeAttribute(AttributeId.MinimumSamplingInterval, value);
        if (statusCode != null && statusCode.isBad()) {
            throw new UaException(statusCode, "write MinimumSamplingInterval failed");
        }
        this.setMinimumSamplingInterval(minimumSamplingInterval);
    }

    public void writeHistorizing(Boolean historizing) throws UaException {
        DataValue value = DataValue.valueOnly(new Variant(historizing));
        StatusCode statusCode = this.writeAttribute(AttributeId.Historizing, value);
        if (statusCode != null && statusCode.isBad()) {
            throw new UaException(statusCode, "write Historizing failed");
        }
        this.setHistorizing(historizing);
    }

    public UaVariableNode getVariableComponent(String name) throws UaException {
        try {
            return this.getVariableComponentAsync(name).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public UaVariableNode getVariableComponent(String namespaceUri, String name) throws UaException {
        try {
            return this.getVariableComponentAsync(namespaceUri, name).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public UaVariableNode getVariableComponent(QualifiedName browseName) throws UaException {
        try {
            return this.getVariableComponentAsync(browseName).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends UaVariableNode> getVariableComponentAsync(String name) {
        return this.getVariableComponentAsync(new QualifiedName(this.getNodeId().getNamespaceIndex(), name));
    }

    public CompletableFuture<? extends UaVariableNode> getVariableComponentAsync(String namespaceUri, String name) {
        UShort namespaceIndex = this.client.getNamespaceTable().getIndex(namespaceUri);
        if (namespaceIndex != null) {
            return this.getVariableComponentAsync(new QualifiedName(namespaceIndex, name));
        }
        return FutureUtils.failedUaFuture(2151546880L);
    }

    public CompletableFuture<? extends UaVariableNode> getVariableComponentAsync(QualifiedName browseName) {
        return this.getComponentAsync(browseName, NodeClass.Variable).thenApply(UaVariableNode.class::cast);
    }

    public UaVariableTypeNode getTypeDefinition() throws UaException {
        try {
            return this.getTypeDefinitionAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends UaVariableTypeNode> getTypeDefinitionAsync() {
        UInteger nodeClassMask = Unsigned.uint(NodeClass.VariableType.getValue());
        UInteger resultMask = Unsigned.uint(BrowseResultMask.All.getValue());
        CompletableFuture<BrowseResult> future = this.client.browse(new BrowseDescription(this.getNodeId(), BrowseDirection.Forward, Identifiers.HasTypeDefinition, false, nodeClassMask, resultMask));
        return future.thenCompose(result -> {
            List<ReferenceDescription> references = ConversionUtil.l(result.getReferences());
            Optional node = references.stream().flatMap(r -> {
                Optional<CompletableFuture> opt = r.getNodeId().toNodeId(this.client.getNamespaceTable()).map(id -> this.client.getAddressSpace().getNodeAsync((NodeId)id).thenApply(n -> (UaVariableTypeNode)n));
                return StreamUtil.opt2stream(opt);
            }).findFirst();
            return node.orElse(FutureUtils.failedUaFuture(2151546880L));
        });
    }

    public CompletableFuture<? extends String> readNodeVersionAsync() {
        return this.getProperty(VariableNodeProperties.NodeVersion);
    }

    public CompletableFuture<? extends TimeZoneDataType> readLocalTimeAsync() {
        return this.getProperty(VariableNodeProperties.LocalTime);
    }

    public CompletableFuture<? extends String> readDataTypeVersionAsync() {
        return this.getProperty(VariableNodeProperties.DataTypeVersion);
    }

    public CompletableFuture<? extends ByteString> readDictionaryFragmentAsync() {
        return this.getProperty(VariableNodeProperties.DictionaryFragment);
    }

    public CompletableFuture<? extends Boolean> readAllowNullsAsync() {
        return this.getProperty(VariableNodeProperties.AllowNulls);
    }

    public CompletableFuture<? extends LocalizedText> readValueAsTextAsync() {
        return this.getProperty(VariableNodeProperties.ValueAsText);
    }

    public CompletableFuture<? extends UInteger> readMaxStringLengthAsync() {
        return this.getProperty(VariableNodeProperties.MaxStringLength);
    }

    public CompletableFuture<? extends UInteger> readMaxArrayLengthAsync() {
        return this.getProperty(VariableNodeProperties.MaxArrayLength);
    }

    public CompletableFuture<? extends EUInformation> readEngineeringUnitsAsync() {
        return this.getProperty(VariableNodeProperties.EngineeringUnits);
    }

    public CompletableFuture<StatusCode> writeNodeVersionAsync(String nodeVersion) {
        return this.setProperty(VariableNodeProperties.NodeVersion, nodeVersion);
    }

    public CompletableFuture<StatusCode> writeLocalTimeAsync(TimeZoneDataType localTime) {
        return this.setProperty(VariableNodeProperties.LocalTime, localTime);
    }

    public CompletableFuture<StatusCode> writeDataTypeVersionAsync(String dataTypeVersion) {
        return this.setProperty(VariableNodeProperties.DataTypeVersion, dataTypeVersion);
    }

    public CompletableFuture<StatusCode> writeDictionaryFragmentAsync(ByteString dictionaryFragment) {
        return this.setProperty(VariableNodeProperties.DictionaryFragment, dictionaryFragment);
    }

    public CompletableFuture<StatusCode> writeAllowNullsAsync(Boolean allowNulls) {
        return this.setProperty(VariableNodeProperties.AllowNulls, allowNulls);
    }

    public CompletableFuture<StatusCode> writeValueAsTextAsync(LocalizedText valueAsText) {
        return this.setProperty(VariableNodeProperties.ValueAsText, valueAsText);
    }

    public CompletableFuture<StatusCode> writeMaxStringLengthAsync(UInteger maxStringLength) {
        return this.setProperty(VariableNodeProperties.MaxStringLength, maxStringLength);
    }

    public CompletableFuture<StatusCode> writeMaxArrayLengthAsync(UInteger maxArrayLength) {
        return this.setProperty(VariableNodeProperties.MaxArrayLength, maxArrayLength);
    }

    public CompletableFuture<StatusCode> writeEngineeringUnitsAsync(EUInformation engineeringUnits) {
        return this.setProperty(VariableNodeProperties.EngineeringUnits, engineeringUnits);
    }

    @Override
    protected DataValue getAttributeValue(AttributeId attributeId) {
        switch (attributeId) {
            case Value: {
                return DataValue.valueOnly(new Variant(this.getValue().getValue().getValue()));
            }
            case DataType: {
                return DataValue.valueOnly(new Variant(this.getDataType()));
            }
            case ValueRank: {
                return DataValue.valueOnly(new Variant(this.getValueRank()));
            }
            case ArrayDimensions: {
                return DataValue.valueOnly(new Variant(this.getArrayDimensions()));
            }
            case AccessLevel: {
                return DataValue.valueOnly(new Variant(this.getAccessLevel()));
            }
            case UserAccessLevel: {
                return DataValue.valueOnly(new Variant(this.getUserAccessLevel()));
            }
            case MinimumSamplingInterval: {
                return DataValue.valueOnly(new Variant(this.getMinimumSamplingInterval()));
            }
            case Historizing: {
                return DataValue.valueOnly(new Variant(this.getHistorizing()));
            }
        }
        return super.getAttributeValue(attributeId);
    }

    @Override
    protected void setAttributeValue(AttributeId attributeId, DataValue value) {
        switch (attributeId) {
            case Value: {
                this.setValue(value);
                break;
            }
            case DataType: {
                this.setDataType((NodeId)value.getValue().getValue());
                break;
            }
            case ValueRank: {
                this.setValueRank((Integer)value.getValue().getValue());
                break;
            }
            case ArrayDimensions: {
                this.setArrayDimensions((UInteger[])value.getValue().getValue());
                break;
            }
            case AccessLevel: {
                this.setAccessLevel((UByte)value.getValue().getValue());
                break;
            }
            case UserAccessLevel: {
                this.setUserAccessLevel((UByte)value.getValue().getValue());
                break;
            }
            case MinimumSamplingInterval: {
                this.setMinimumSamplingInterval((Double)value.getValue().getValue());
                break;
            }
            case Historizing: {
                this.setHistorizing((Boolean)value.getValue().getValue());
                break;
            }
            default: {
                super.setAttributeValue(attributeId, value);
            }
        }
    }
}

