/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.nodes;

import java.util.concurrent.CompletableFuture;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.core.nodes.DataTypeNode;
import org.eclipse.milo.opcua.sdk.core.nodes.DataTypeNodeProperties;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.EnumValueType;

public class UaDataTypeNode
extends UaNode
implements DataTypeNode {
    private Boolean isAbstract;

    public UaDataTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, Boolean isAbstract) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask);
        this.isAbstract = isAbstract;
    }

    @Override
    public synchronized Boolean getIsAbstract() {
        return this.isAbstract;
    }

    @Override
    public synchronized void setIsAbstract(Boolean isAbstract) {
        this.isAbstract = isAbstract;
    }

    public Boolean readIsAbstract() throws UaException {
        DataValue value = this.readAttribute(AttributeId.IsAbstract);
        StatusCode statusCode = value.getStatusCode();
        if (statusCode != null && statusCode.isBad()) {
            throw new UaException(statusCode, "read IsAbstract failed");
        }
        Boolean isAbstract = (Boolean)value.getValue().getValue();
        this.setIsAbstract(isAbstract);
        return isAbstract;
    }

    public void writeIsAbstract(Boolean isAbstract) throws UaException {
        DataValue value = DataValue.valueOnly(new Variant(isAbstract));
        StatusCode statusCode = this.writeAttribute(AttributeId.IsAbstract, value);
        if (statusCode != null && statusCode.isBad()) {
            throw new UaException(statusCode, "write IsAbstract failed");
        }
        this.setIsAbstract(isAbstract);
    }

    public CompletableFuture<? extends String> readNodeVersionAsync() {
        return this.getProperty(DataTypeNodeProperties.NodeVersion);
    }

    public CompletableFuture<? extends LocalizedText[]> readEnumStringsAsync() {
        return this.getProperty(DataTypeNodeProperties.EnumStrings);
    }

    public CompletableFuture<? extends EnumValueType[]> readEnumValuesAsync() {
        return this.getProperty(DataTypeNodeProperties.EnumValues);
    }

    public CompletableFuture<? extends LocalizedText[]> readOptionSetValuesAsync() {
        return this.getProperty(DataTypeNodeProperties.OptionSetValues);
    }

    public CompletableFuture<StatusCode> writeNodeVersionAsync(String nodeVersion) {
        return this.setProperty(DataTypeNodeProperties.NodeVersion, nodeVersion);
    }

    public CompletableFuture<StatusCode> writeEnumStringsAsync(LocalizedText[] enumStrings) {
        return this.setProperty(DataTypeNodeProperties.EnumStrings, enumStrings);
    }

    public CompletableFuture<StatusCode> writeEnumValuesAsync(EnumValueType[] enumValues) {
        return this.setProperty(DataTypeNodeProperties.EnumValues, enumValues);
    }

    public CompletableFuture<StatusCode> writeOptionSetValuesAsync(LocalizedText[] optionSetValues) {
        return this.setProperty(DataTypeNodeProperties.OptionSetValues, optionSetValues);
    }

    @Override
    protected DataValue getAttributeValue(AttributeId attributeId) {
        switch (attributeId) {
            case IsAbstract: {
                return DataValue.valueOnly(new Variant(this.getIsAbstract()));
            }
        }
        return super.getAttributeValue(attributeId);
    }

    @Override
    protected void setAttributeValue(AttributeId attributeId, DataValue value) {
        switch (attributeId) {
            case IsAbstract: {
                this.setIsAbstract((Boolean)value.getValue().getValue());
                break;
            }
            default: {
                super.setAttributeValue(attributeId, value);
            }
        }
    }
}

