/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.nodes.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.BaseObjectTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.CertificateGroupFolderTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.types.objects.ServerConfigurationType;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;

public class ServerConfigurationTypeNode
extends BaseObjectTypeNode
implements ServerConfigurationType {
    public ServerConfigurationTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, eventNotifier);
    }

    @Override
    public String[] getServerCapabilities() throws UaException {
        PropertyTypeNode node = this.getServerCapabilitiesNode();
        return (String[])node.getValue().getValue().getValue();
    }

    @Override
    public void setServerCapabilities(String[] serverCapabilities) throws UaException {
        PropertyTypeNode node = this.getServerCapabilitiesNode();
        node.setValue(new Variant(serverCapabilities));
    }

    @Override
    public String[] readServerCapabilities() throws UaException {
        try {
            return this.readServerCapabilitiesAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeServerCapabilities(String[] serverCapabilities) throws UaException {
        try {
            this.writeServerCapabilitiesAsync(serverCapabilities).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String[]> readServerCapabilitiesAsync() {
        return ((CompletableFuture)this.getServerCapabilitiesNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String[])v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeServerCapabilitiesAsync(String[] serverCapabilities) {
        DataValue value = DataValue.valueOnly(new Variant(serverCapabilities));
        return this.getServerCapabilitiesNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getServerCapabilitiesNode() throws UaException {
        try {
            return this.getServerCapabilitiesNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getServerCapabilitiesNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ServerCapabilities", ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public String[] getSupportedPrivateKeyFormats() throws UaException {
        PropertyTypeNode node = this.getSupportedPrivateKeyFormatsNode();
        return (String[])node.getValue().getValue().getValue();
    }

    @Override
    public void setSupportedPrivateKeyFormats(String[] supportedPrivateKeyFormats) throws UaException {
        PropertyTypeNode node = this.getSupportedPrivateKeyFormatsNode();
        node.setValue(new Variant(supportedPrivateKeyFormats));
    }

    @Override
    public String[] readSupportedPrivateKeyFormats() throws UaException {
        try {
            return this.readSupportedPrivateKeyFormatsAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeSupportedPrivateKeyFormats(String[] supportedPrivateKeyFormats) throws UaException {
        try {
            this.writeSupportedPrivateKeyFormatsAsync(supportedPrivateKeyFormats).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String[]> readSupportedPrivateKeyFormatsAsync() {
        return ((CompletableFuture)this.getSupportedPrivateKeyFormatsNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String[])v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeSupportedPrivateKeyFormatsAsync(String[] supportedPrivateKeyFormats) {
        DataValue value = DataValue.valueOnly(new Variant(supportedPrivateKeyFormats));
        return this.getSupportedPrivateKeyFormatsNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getSupportedPrivateKeyFormatsNode() throws UaException {
        try {
            return this.getSupportedPrivateKeyFormatsNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getSupportedPrivateKeyFormatsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SupportedPrivateKeyFormats", ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UInteger getMaxTrustListSize() throws UaException {
        PropertyTypeNode node = this.getMaxTrustListSizeNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxTrustListSize(UInteger maxTrustListSize) throws UaException {
        PropertyTypeNode node = this.getMaxTrustListSizeNode();
        node.setValue(new Variant(maxTrustListSize));
    }

    @Override
    public UInteger readMaxTrustListSize() throws UaException {
        try {
            return this.readMaxTrustListSizeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeMaxTrustListSize(UInteger maxTrustListSize) throws UaException {
        try {
            this.writeMaxTrustListSizeAsync(maxTrustListSize).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readMaxTrustListSizeAsync() {
        return ((CompletableFuture)this.getMaxTrustListSizeNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMaxTrustListSizeAsync(UInteger maxTrustListSize) {
        DataValue value = DataValue.valueOnly(new Variant(maxTrustListSize));
        return this.getMaxTrustListSizeNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getMaxTrustListSizeNode() throws UaException {
        try {
            return this.getMaxTrustListSizeNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMaxTrustListSizeNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxTrustListSize", ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Boolean getMulticastDnsEnabled() throws UaException {
        PropertyTypeNode node = this.getMulticastDnsEnabledNode();
        return (Boolean)node.getValue().getValue().getValue();
    }

    @Override
    public void setMulticastDnsEnabled(Boolean multicastDnsEnabled) throws UaException {
        PropertyTypeNode node = this.getMulticastDnsEnabledNode();
        node.setValue(new Variant(multicastDnsEnabled));
    }

    @Override
    public Boolean readMulticastDnsEnabled() throws UaException {
        try {
            return this.readMulticastDnsEnabledAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeMulticastDnsEnabled(Boolean multicastDnsEnabled) throws UaException {
        try {
            this.writeMulticastDnsEnabledAsync(multicastDnsEnabled).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Boolean> readMulticastDnsEnabledAsync() {
        return ((CompletableFuture)this.getMulticastDnsEnabledNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Boolean)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMulticastDnsEnabledAsync(Boolean multicastDnsEnabled) {
        DataValue value = DataValue.valueOnly(new Variant(multicastDnsEnabled));
        return this.getMulticastDnsEnabledNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getMulticastDnsEnabledNode() throws UaException {
        try {
            return this.getMulticastDnsEnabledNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMulticastDnsEnabledNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MulticastDnsEnabled", ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public CertificateGroupFolderTypeNode getCertificateGroupsNode() throws UaException {
        try {
            return this.getCertificateGroupsNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends CertificateGroupFolderTypeNode> getCertificateGroupsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "CertificateGroups", ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (CertificateGroupFolderTypeNode)node);
    }
}

