/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.nodes.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.FolderTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.types.objects.OperationLimitsType;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;

public class OperationLimitsTypeNode
extends FolderTypeNode
implements OperationLimitsType {
    public OperationLimitsTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, eventNotifier);
    }

    @Override
    public UInteger getMaxNodesPerRead() throws UaException {
        PropertyTypeNode node = this.getMaxNodesPerReadNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxNodesPerRead(UInteger maxNodesPerRead) throws UaException {
        PropertyTypeNode node = this.getMaxNodesPerReadNode();
        node.setValue(new Variant(maxNodesPerRead));
    }

    @Override
    public UInteger readMaxNodesPerRead() throws UaException {
        try {
            return this.readMaxNodesPerReadAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeMaxNodesPerRead(UInteger maxNodesPerRead) throws UaException {
        try {
            this.writeMaxNodesPerReadAsync(maxNodesPerRead).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readMaxNodesPerReadAsync() {
        return ((CompletableFuture)this.getMaxNodesPerReadNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMaxNodesPerReadAsync(UInteger maxNodesPerRead) {
        DataValue value = DataValue.valueOnly(new Variant(maxNodesPerRead));
        return this.getMaxNodesPerReadNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getMaxNodesPerReadNode() throws UaException {
        try {
            return this.getMaxNodesPerReadNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMaxNodesPerReadNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxNodesPerRead", ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UInteger getMaxNodesPerHistoryReadData() throws UaException {
        PropertyTypeNode node = this.getMaxNodesPerHistoryReadDataNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxNodesPerHistoryReadData(UInteger maxNodesPerHistoryReadData) throws UaException {
        PropertyTypeNode node = this.getMaxNodesPerHistoryReadDataNode();
        node.setValue(new Variant(maxNodesPerHistoryReadData));
    }

    @Override
    public UInteger readMaxNodesPerHistoryReadData() throws UaException {
        try {
            return this.readMaxNodesPerHistoryReadDataAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeMaxNodesPerHistoryReadData(UInteger maxNodesPerHistoryReadData) throws UaException {
        try {
            this.writeMaxNodesPerHistoryReadDataAsync(maxNodesPerHistoryReadData).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readMaxNodesPerHistoryReadDataAsync() {
        return ((CompletableFuture)this.getMaxNodesPerHistoryReadDataNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMaxNodesPerHistoryReadDataAsync(UInteger maxNodesPerHistoryReadData) {
        DataValue value = DataValue.valueOnly(new Variant(maxNodesPerHistoryReadData));
        return this.getMaxNodesPerHistoryReadDataNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getMaxNodesPerHistoryReadDataNode() throws UaException {
        try {
            return this.getMaxNodesPerHistoryReadDataNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMaxNodesPerHistoryReadDataNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxNodesPerHistoryReadData", ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UInteger getMaxNodesPerHistoryReadEvents() throws UaException {
        PropertyTypeNode node = this.getMaxNodesPerHistoryReadEventsNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxNodesPerHistoryReadEvents(UInteger maxNodesPerHistoryReadEvents) throws UaException {
        PropertyTypeNode node = this.getMaxNodesPerHistoryReadEventsNode();
        node.setValue(new Variant(maxNodesPerHistoryReadEvents));
    }

    @Override
    public UInteger readMaxNodesPerHistoryReadEvents() throws UaException {
        try {
            return this.readMaxNodesPerHistoryReadEventsAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeMaxNodesPerHistoryReadEvents(UInteger maxNodesPerHistoryReadEvents) throws UaException {
        try {
            this.writeMaxNodesPerHistoryReadEventsAsync(maxNodesPerHistoryReadEvents).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readMaxNodesPerHistoryReadEventsAsync() {
        return ((CompletableFuture)this.getMaxNodesPerHistoryReadEventsNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMaxNodesPerHistoryReadEventsAsync(UInteger maxNodesPerHistoryReadEvents) {
        DataValue value = DataValue.valueOnly(new Variant(maxNodesPerHistoryReadEvents));
        return this.getMaxNodesPerHistoryReadEventsNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getMaxNodesPerHistoryReadEventsNode() throws UaException {
        try {
            return this.getMaxNodesPerHistoryReadEventsNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMaxNodesPerHistoryReadEventsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxNodesPerHistoryReadEvents", ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UInteger getMaxNodesPerWrite() throws UaException {
        PropertyTypeNode node = this.getMaxNodesPerWriteNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxNodesPerWrite(UInteger maxNodesPerWrite) throws UaException {
        PropertyTypeNode node = this.getMaxNodesPerWriteNode();
        node.setValue(new Variant(maxNodesPerWrite));
    }

    @Override
    public UInteger readMaxNodesPerWrite() throws UaException {
        try {
            return this.readMaxNodesPerWriteAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeMaxNodesPerWrite(UInteger maxNodesPerWrite) throws UaException {
        try {
            this.writeMaxNodesPerWriteAsync(maxNodesPerWrite).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readMaxNodesPerWriteAsync() {
        return ((CompletableFuture)this.getMaxNodesPerWriteNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMaxNodesPerWriteAsync(UInteger maxNodesPerWrite) {
        DataValue value = DataValue.valueOnly(new Variant(maxNodesPerWrite));
        return this.getMaxNodesPerWriteNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getMaxNodesPerWriteNode() throws UaException {
        try {
            return this.getMaxNodesPerWriteNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMaxNodesPerWriteNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxNodesPerWrite", ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UInteger getMaxNodesPerHistoryUpdateData() throws UaException {
        PropertyTypeNode node = this.getMaxNodesPerHistoryUpdateDataNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxNodesPerHistoryUpdateData(UInteger maxNodesPerHistoryUpdateData) throws UaException {
        PropertyTypeNode node = this.getMaxNodesPerHistoryUpdateDataNode();
        node.setValue(new Variant(maxNodesPerHistoryUpdateData));
    }

    @Override
    public UInteger readMaxNodesPerHistoryUpdateData() throws UaException {
        try {
            return this.readMaxNodesPerHistoryUpdateDataAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeMaxNodesPerHistoryUpdateData(UInteger maxNodesPerHistoryUpdateData) throws UaException {
        try {
            this.writeMaxNodesPerHistoryUpdateDataAsync(maxNodesPerHistoryUpdateData).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readMaxNodesPerHistoryUpdateDataAsync() {
        return ((CompletableFuture)this.getMaxNodesPerHistoryUpdateDataNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMaxNodesPerHistoryUpdateDataAsync(UInteger maxNodesPerHistoryUpdateData) {
        DataValue value = DataValue.valueOnly(new Variant(maxNodesPerHistoryUpdateData));
        return this.getMaxNodesPerHistoryUpdateDataNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getMaxNodesPerHistoryUpdateDataNode() throws UaException {
        try {
            return this.getMaxNodesPerHistoryUpdateDataNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMaxNodesPerHistoryUpdateDataNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxNodesPerHistoryUpdateData", ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UInteger getMaxNodesPerHistoryUpdateEvents() throws UaException {
        PropertyTypeNode node = this.getMaxNodesPerHistoryUpdateEventsNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxNodesPerHistoryUpdateEvents(UInteger maxNodesPerHistoryUpdateEvents) throws UaException {
        PropertyTypeNode node = this.getMaxNodesPerHistoryUpdateEventsNode();
        node.setValue(new Variant(maxNodesPerHistoryUpdateEvents));
    }

    @Override
    public UInteger readMaxNodesPerHistoryUpdateEvents() throws UaException {
        try {
            return this.readMaxNodesPerHistoryUpdateEventsAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeMaxNodesPerHistoryUpdateEvents(UInteger maxNodesPerHistoryUpdateEvents) throws UaException {
        try {
            this.writeMaxNodesPerHistoryUpdateEventsAsync(maxNodesPerHistoryUpdateEvents).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readMaxNodesPerHistoryUpdateEventsAsync() {
        return ((CompletableFuture)this.getMaxNodesPerHistoryUpdateEventsNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMaxNodesPerHistoryUpdateEventsAsync(UInteger maxNodesPerHistoryUpdateEvents) {
        DataValue value = DataValue.valueOnly(new Variant(maxNodesPerHistoryUpdateEvents));
        return this.getMaxNodesPerHistoryUpdateEventsNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getMaxNodesPerHistoryUpdateEventsNode() throws UaException {
        try {
            return this.getMaxNodesPerHistoryUpdateEventsNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMaxNodesPerHistoryUpdateEventsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxNodesPerHistoryUpdateEvents", ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UInteger getMaxNodesPerMethodCall() throws UaException {
        PropertyTypeNode node = this.getMaxNodesPerMethodCallNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxNodesPerMethodCall(UInteger maxNodesPerMethodCall) throws UaException {
        PropertyTypeNode node = this.getMaxNodesPerMethodCallNode();
        node.setValue(new Variant(maxNodesPerMethodCall));
    }

    @Override
    public UInteger readMaxNodesPerMethodCall() throws UaException {
        try {
            return this.readMaxNodesPerMethodCallAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeMaxNodesPerMethodCall(UInteger maxNodesPerMethodCall) throws UaException {
        try {
            this.writeMaxNodesPerMethodCallAsync(maxNodesPerMethodCall).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readMaxNodesPerMethodCallAsync() {
        return ((CompletableFuture)this.getMaxNodesPerMethodCallNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMaxNodesPerMethodCallAsync(UInteger maxNodesPerMethodCall) {
        DataValue value = DataValue.valueOnly(new Variant(maxNodesPerMethodCall));
        return this.getMaxNodesPerMethodCallNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getMaxNodesPerMethodCallNode() throws UaException {
        try {
            return this.getMaxNodesPerMethodCallNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMaxNodesPerMethodCallNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxNodesPerMethodCall", ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UInteger getMaxNodesPerBrowse() throws UaException {
        PropertyTypeNode node = this.getMaxNodesPerBrowseNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxNodesPerBrowse(UInteger maxNodesPerBrowse) throws UaException {
        PropertyTypeNode node = this.getMaxNodesPerBrowseNode();
        node.setValue(new Variant(maxNodesPerBrowse));
    }

    @Override
    public UInteger readMaxNodesPerBrowse() throws UaException {
        try {
            return this.readMaxNodesPerBrowseAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeMaxNodesPerBrowse(UInteger maxNodesPerBrowse) throws UaException {
        try {
            this.writeMaxNodesPerBrowseAsync(maxNodesPerBrowse).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readMaxNodesPerBrowseAsync() {
        return ((CompletableFuture)this.getMaxNodesPerBrowseNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMaxNodesPerBrowseAsync(UInteger maxNodesPerBrowse) {
        DataValue value = DataValue.valueOnly(new Variant(maxNodesPerBrowse));
        return this.getMaxNodesPerBrowseNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getMaxNodesPerBrowseNode() throws UaException {
        try {
            return this.getMaxNodesPerBrowseNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMaxNodesPerBrowseNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxNodesPerBrowse", ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UInteger getMaxNodesPerRegisterNodes() throws UaException {
        PropertyTypeNode node = this.getMaxNodesPerRegisterNodesNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxNodesPerRegisterNodes(UInteger maxNodesPerRegisterNodes) throws UaException {
        PropertyTypeNode node = this.getMaxNodesPerRegisterNodesNode();
        node.setValue(new Variant(maxNodesPerRegisterNodes));
    }

    @Override
    public UInteger readMaxNodesPerRegisterNodes() throws UaException {
        try {
            return this.readMaxNodesPerRegisterNodesAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeMaxNodesPerRegisterNodes(UInteger maxNodesPerRegisterNodes) throws UaException {
        try {
            this.writeMaxNodesPerRegisterNodesAsync(maxNodesPerRegisterNodes).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readMaxNodesPerRegisterNodesAsync() {
        return ((CompletableFuture)this.getMaxNodesPerRegisterNodesNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMaxNodesPerRegisterNodesAsync(UInteger maxNodesPerRegisterNodes) {
        DataValue value = DataValue.valueOnly(new Variant(maxNodesPerRegisterNodes));
        return this.getMaxNodesPerRegisterNodesNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getMaxNodesPerRegisterNodesNode() throws UaException {
        try {
            return this.getMaxNodesPerRegisterNodesNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMaxNodesPerRegisterNodesNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxNodesPerRegisterNodes", ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UInteger getMaxNodesPerTranslateBrowsePathsToNodeIds() throws UaException {
        PropertyTypeNode node = this.getMaxNodesPerTranslateBrowsePathsToNodeIdsNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxNodesPerTranslateBrowsePathsToNodeIds(UInteger maxNodesPerTranslateBrowsePathsToNodeIds) throws UaException {
        PropertyTypeNode node = this.getMaxNodesPerTranslateBrowsePathsToNodeIdsNode();
        node.setValue(new Variant(maxNodesPerTranslateBrowsePathsToNodeIds));
    }

    @Override
    public UInteger readMaxNodesPerTranslateBrowsePathsToNodeIds() throws UaException {
        try {
            return this.readMaxNodesPerTranslateBrowsePathsToNodeIdsAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeMaxNodesPerTranslateBrowsePathsToNodeIds(UInteger maxNodesPerTranslateBrowsePathsToNodeIds) throws UaException {
        try {
            this.writeMaxNodesPerTranslateBrowsePathsToNodeIdsAsync(maxNodesPerTranslateBrowsePathsToNodeIds).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readMaxNodesPerTranslateBrowsePathsToNodeIdsAsync() {
        return ((CompletableFuture)this.getMaxNodesPerTranslateBrowsePathsToNodeIdsNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMaxNodesPerTranslateBrowsePathsToNodeIdsAsync(UInteger maxNodesPerTranslateBrowsePathsToNodeIds) {
        DataValue value = DataValue.valueOnly(new Variant(maxNodesPerTranslateBrowsePathsToNodeIds));
        return this.getMaxNodesPerTranslateBrowsePathsToNodeIdsNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getMaxNodesPerTranslateBrowsePathsToNodeIdsNode() throws UaException {
        try {
            return this.getMaxNodesPerTranslateBrowsePathsToNodeIdsNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMaxNodesPerTranslateBrowsePathsToNodeIdsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxNodesPerTranslateBrowsePathsToNodeIds", ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UInteger getMaxNodesPerNodeManagement() throws UaException {
        PropertyTypeNode node = this.getMaxNodesPerNodeManagementNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxNodesPerNodeManagement(UInteger maxNodesPerNodeManagement) throws UaException {
        PropertyTypeNode node = this.getMaxNodesPerNodeManagementNode();
        node.setValue(new Variant(maxNodesPerNodeManagement));
    }

    @Override
    public UInteger readMaxNodesPerNodeManagement() throws UaException {
        try {
            return this.readMaxNodesPerNodeManagementAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeMaxNodesPerNodeManagement(UInteger maxNodesPerNodeManagement) throws UaException {
        try {
            this.writeMaxNodesPerNodeManagementAsync(maxNodesPerNodeManagement).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readMaxNodesPerNodeManagementAsync() {
        return ((CompletableFuture)this.getMaxNodesPerNodeManagementNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMaxNodesPerNodeManagementAsync(UInteger maxNodesPerNodeManagement) {
        DataValue value = DataValue.valueOnly(new Variant(maxNodesPerNodeManagement));
        return this.getMaxNodesPerNodeManagementNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getMaxNodesPerNodeManagementNode() throws UaException {
        try {
            return this.getMaxNodesPerNodeManagementNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMaxNodesPerNodeManagementNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxNodesPerNodeManagement", ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UInteger getMaxMonitoredItemsPerCall() throws UaException {
        PropertyTypeNode node = this.getMaxMonitoredItemsPerCallNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxMonitoredItemsPerCall(UInteger maxMonitoredItemsPerCall) throws UaException {
        PropertyTypeNode node = this.getMaxMonitoredItemsPerCallNode();
        node.setValue(new Variant(maxMonitoredItemsPerCall));
    }

    @Override
    public UInteger readMaxMonitoredItemsPerCall() throws UaException {
        try {
            return this.readMaxMonitoredItemsPerCallAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeMaxMonitoredItemsPerCall(UInteger maxMonitoredItemsPerCall) throws UaException {
        try {
            this.writeMaxMonitoredItemsPerCallAsync(maxMonitoredItemsPerCall).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readMaxMonitoredItemsPerCallAsync() {
        return ((CompletableFuture)this.getMaxMonitoredItemsPerCallNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMaxMonitoredItemsPerCallAsync(UInteger maxMonitoredItemsPerCall) {
        DataValue value = DataValue.valueOnly(new Variant(maxMonitoredItemsPerCall));
        return this.getMaxMonitoredItemsPerCallNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getMaxMonitoredItemsPerCallNode() throws UaException {
        try {
            return this.getMaxMonitoredItemsPerCallNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMaxMonitoredItemsPerCallNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxMonitoredItemsPerCall", ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }
}

