/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.nodes.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.BaseEventTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.ConditionVariableTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.TwoStateVariableTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.types.objects.ConditionType;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;

public class ConditionTypeNode
extends BaseEventTypeNode
implements ConditionType {
    public ConditionTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, eventNotifier);
    }

    @Override
    public NodeId getConditionClassId() throws UaException {
        PropertyTypeNode node = this.getConditionClassIdNode();
        return (NodeId)node.getValue().getValue().getValue();
    }

    @Override
    public void setConditionClassId(NodeId conditionClassId) throws UaException {
        PropertyTypeNode node = this.getConditionClassIdNode();
        node.setValue(new Variant(conditionClassId));
    }

    @Override
    public NodeId readConditionClassId() throws UaException {
        try {
            return this.readConditionClassIdAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeConditionClassId(NodeId conditionClassId) throws UaException {
        try {
            this.writeConditionClassIdAsync(conditionClassId).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends NodeId> readConditionClassIdAsync() {
        return ((CompletableFuture)this.getConditionClassIdNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (NodeId)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeConditionClassIdAsync(NodeId conditionClassId) {
        DataValue value = DataValue.valueOnly(new Variant(conditionClassId));
        return this.getConditionClassIdNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getConditionClassIdNode() throws UaException {
        try {
            return this.getConditionClassIdNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getConditionClassIdNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ConditionClassId", ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public LocalizedText getConditionClassName() throws UaException {
        PropertyTypeNode node = this.getConditionClassNameNode();
        return (LocalizedText)node.getValue().getValue().getValue();
    }

    @Override
    public void setConditionClassName(LocalizedText conditionClassName) throws UaException {
        PropertyTypeNode node = this.getConditionClassNameNode();
        node.setValue(new Variant(conditionClassName));
    }

    @Override
    public LocalizedText readConditionClassName() throws UaException {
        try {
            return this.readConditionClassNameAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeConditionClassName(LocalizedText conditionClassName) throws UaException {
        try {
            this.writeConditionClassNameAsync(conditionClassName).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends LocalizedText> readConditionClassNameAsync() {
        return ((CompletableFuture)this.getConditionClassNameNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (LocalizedText)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeConditionClassNameAsync(LocalizedText conditionClassName) {
        DataValue value = DataValue.valueOnly(new Variant(conditionClassName));
        return this.getConditionClassNameNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getConditionClassNameNode() throws UaException {
        try {
            return this.getConditionClassNameNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getConditionClassNameNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ConditionClassName", ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public String getConditionName() throws UaException {
        PropertyTypeNode node = this.getConditionNameNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setConditionName(String conditionName) throws UaException {
        PropertyTypeNode node = this.getConditionNameNode();
        node.setValue(new Variant(conditionName));
    }

    @Override
    public String readConditionName() throws UaException {
        try {
            return this.readConditionNameAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeConditionName(String conditionName) throws UaException {
        try {
            this.writeConditionNameAsync(conditionName).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String> readConditionNameAsync() {
        return ((CompletableFuture)this.getConditionNameNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeConditionNameAsync(String conditionName) {
        DataValue value = DataValue.valueOnly(new Variant(conditionName));
        return this.getConditionNameNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getConditionNameNode() throws UaException {
        try {
            return this.getConditionNameNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getConditionNameNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ConditionName", ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public NodeId getBranchId() throws UaException {
        PropertyTypeNode node = this.getBranchIdNode();
        return (NodeId)node.getValue().getValue().getValue();
    }

    @Override
    public void setBranchId(NodeId branchId) throws UaException {
        PropertyTypeNode node = this.getBranchIdNode();
        node.setValue(new Variant(branchId));
    }

    @Override
    public NodeId readBranchId() throws UaException {
        try {
            return this.readBranchIdAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeBranchId(NodeId branchId) throws UaException {
        try {
            this.writeBranchIdAsync(branchId).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends NodeId> readBranchIdAsync() {
        return ((CompletableFuture)this.getBranchIdNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (NodeId)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeBranchIdAsync(NodeId branchId) {
        DataValue value = DataValue.valueOnly(new Variant(branchId));
        return this.getBranchIdNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getBranchIdNode() throws UaException {
        try {
            return this.getBranchIdNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getBranchIdNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "BranchId", ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Boolean getRetain() throws UaException {
        PropertyTypeNode node = this.getRetainNode();
        return (Boolean)node.getValue().getValue().getValue();
    }

    @Override
    public void setRetain(Boolean retain) throws UaException {
        PropertyTypeNode node = this.getRetainNode();
        node.setValue(new Variant(retain));
    }

    @Override
    public Boolean readRetain() throws UaException {
        try {
            return this.readRetainAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeRetain(Boolean retain) throws UaException {
        try {
            this.writeRetainAsync(retain).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Boolean> readRetainAsync() {
        return ((CompletableFuture)this.getRetainNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Boolean)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeRetainAsync(Boolean retain) {
        DataValue value = DataValue.valueOnly(new Variant(retain));
        return this.getRetainNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getRetainNode() throws UaException {
        try {
            return this.getRetainNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getRetainNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Retain", ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public String getClientUserId() throws UaException {
        PropertyTypeNode node = this.getClientUserIdNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setClientUserId(String clientUserId) throws UaException {
        PropertyTypeNode node = this.getClientUserIdNode();
        node.setValue(new Variant(clientUserId));
    }

    @Override
    public String readClientUserId() throws UaException {
        try {
            return this.readClientUserIdAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeClientUserId(String clientUserId) throws UaException {
        try {
            this.writeClientUserIdAsync(clientUserId).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String> readClientUserIdAsync() {
        return ((CompletableFuture)this.getClientUserIdNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeClientUserIdAsync(String clientUserId) {
        DataValue value = DataValue.valueOnly(new Variant(clientUserId));
        return this.getClientUserIdNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getClientUserIdNode() throws UaException {
        try {
            return this.getClientUserIdNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getClientUserIdNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ClientUserId", ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public LocalizedText getEnabledState() throws UaException {
        TwoStateVariableTypeNode node = this.getEnabledStateNode();
        return (LocalizedText)node.getValue().getValue().getValue();
    }

    @Override
    public void setEnabledState(LocalizedText enabledState) throws UaException {
        TwoStateVariableTypeNode node = this.getEnabledStateNode();
        node.setValue(new Variant(enabledState));
    }

    @Override
    public LocalizedText readEnabledState() throws UaException {
        try {
            return this.readEnabledStateAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeEnabledState(LocalizedText enabledState) throws UaException {
        try {
            this.writeEnabledStateAsync(enabledState).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends LocalizedText> readEnabledStateAsync() {
        return ((CompletableFuture)this.getEnabledStateNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (LocalizedText)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeEnabledStateAsync(LocalizedText enabledState) {
        DataValue value = DataValue.valueOnly(new Variant(enabledState));
        return this.getEnabledStateNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public TwoStateVariableTypeNode getEnabledStateNode() throws UaException {
        try {
            return this.getEnabledStateNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends TwoStateVariableTypeNode> getEnabledStateNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "EnabledState", ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (TwoStateVariableTypeNode)node);
    }

    @Override
    public StatusCode getQuality() throws UaException {
        ConditionVariableTypeNode node = this.getQualityNode();
        return (StatusCode)node.getValue().getValue().getValue();
    }

    @Override
    public void setQuality(StatusCode quality) throws UaException {
        ConditionVariableTypeNode node = this.getQualityNode();
        node.setValue(new Variant(quality));
    }

    @Override
    public StatusCode readQuality() throws UaException {
        try {
            return this.readQualityAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeQuality(StatusCode quality) throws UaException {
        try {
            this.writeQualityAsync(quality).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends StatusCode> readQualityAsync() {
        return ((CompletableFuture)this.getQualityNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (StatusCode)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeQualityAsync(StatusCode quality) {
        DataValue value = DataValue.valueOnly(new Variant(quality));
        return this.getQualityNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public ConditionVariableTypeNode getQualityNode() throws UaException {
        try {
            return this.getQualityNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends ConditionVariableTypeNode> getQualityNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Quality", ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (ConditionVariableTypeNode)node);
    }

    @Override
    public UShort getLastSeverity() throws UaException {
        ConditionVariableTypeNode node = this.getLastSeverityNode();
        return (UShort)node.getValue().getValue().getValue();
    }

    @Override
    public void setLastSeverity(UShort lastSeverity) throws UaException {
        ConditionVariableTypeNode node = this.getLastSeverityNode();
        node.setValue(new Variant(lastSeverity));
    }

    @Override
    public UShort readLastSeverity() throws UaException {
        try {
            return this.readLastSeverityAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeLastSeverity(UShort lastSeverity) throws UaException {
        try {
            this.writeLastSeverityAsync(lastSeverity).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UShort> readLastSeverityAsync() {
        return ((CompletableFuture)this.getLastSeverityNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UShort)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeLastSeverityAsync(UShort lastSeverity) {
        DataValue value = DataValue.valueOnly(new Variant(lastSeverity));
        return this.getLastSeverityNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public ConditionVariableTypeNode getLastSeverityNode() throws UaException {
        try {
            return this.getLastSeverityNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends ConditionVariableTypeNode> getLastSeverityNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "LastSeverity", ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (ConditionVariableTypeNode)node);
    }

    @Override
    public LocalizedText getComment() throws UaException {
        ConditionVariableTypeNode node = this.getCommentNode();
        return (LocalizedText)node.getValue().getValue().getValue();
    }

    @Override
    public void setComment(LocalizedText comment) throws UaException {
        ConditionVariableTypeNode node = this.getCommentNode();
        node.setValue(new Variant(comment));
    }

    @Override
    public LocalizedText readComment() throws UaException {
        try {
            return this.readCommentAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeComment(LocalizedText comment) throws UaException {
        try {
            this.writeCommentAsync(comment).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends LocalizedText> readCommentAsync() {
        return ((CompletableFuture)this.getCommentNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (LocalizedText)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeCommentAsync(LocalizedText comment) {
        DataValue value = DataValue.valueOnly(new Variant(comment));
        return this.getCommentNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public ConditionVariableTypeNode getCommentNode() throws UaException {
        try {
            return this.getCommentNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends ConditionVariableTypeNode> getCommentNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Comment", ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (ConditionVariableTypeNode)node);
    }
}

