/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.nodes.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.AuditSessionEventTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.types.objects.AuditActivateSessionEventType;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.SignedSoftwareCertificate;
import org.eclipse.milo.opcua.stack.core.types.structured.UserIdentityToken;

public class AuditActivateSessionEventTypeNode
extends AuditSessionEventTypeNode
implements AuditActivateSessionEventType {
    public AuditActivateSessionEventTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, eventNotifier);
    }

    @Override
    public SignedSoftwareCertificate[] getClientSoftwareCertificates() throws UaException {
        PropertyTypeNode node = this.getClientSoftwareCertificatesNode();
        return this.cast(node.getValue().getValue().getValue(), SignedSoftwareCertificate[].class);
    }

    @Override
    public void setClientSoftwareCertificates(SignedSoftwareCertificate[] clientSoftwareCertificates) throws UaException {
        PropertyTypeNode node = this.getClientSoftwareCertificatesNode();
        ExtensionObject[] encoded = ExtensionObject.encodeArray(this.client.getStaticSerializationContext(), clientSoftwareCertificates);
        node.setValue(new Variant(encoded));
    }

    @Override
    public SignedSoftwareCertificate[] readClientSoftwareCertificates() throws UaException {
        try {
            return this.readClientSoftwareCertificatesAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeClientSoftwareCertificates(SignedSoftwareCertificate[] clientSoftwareCertificates) throws UaException {
        try {
            this.writeClientSoftwareCertificatesAsync(clientSoftwareCertificates).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends SignedSoftwareCertificate[]> readClientSoftwareCertificatesAsync() {
        return ((CompletableFuture)this.getClientSoftwareCertificatesNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), SignedSoftwareCertificate[].class));
    }

    @Override
    public CompletableFuture<StatusCode> writeClientSoftwareCertificatesAsync(SignedSoftwareCertificate[] clientSoftwareCertificates) {
        ExtensionObject[] encoded = ExtensionObject.encodeArray(this.client.getStaticSerializationContext(), clientSoftwareCertificates);
        DataValue value = DataValue.valueOnly(new Variant(encoded));
        return this.getClientSoftwareCertificatesNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getClientSoftwareCertificatesNode() throws UaException {
        try {
            return this.getClientSoftwareCertificatesNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getClientSoftwareCertificatesNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ClientSoftwareCertificates", ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UserIdentityToken getUserIdentityToken() throws UaException {
        PropertyTypeNode node = this.getUserIdentityTokenNode();
        return this.cast(node.getValue().getValue().getValue(), UserIdentityToken.class);
    }

    @Override
    public void setUserIdentityToken(UserIdentityToken userIdentityToken) throws UaException {
        PropertyTypeNode node = this.getUserIdentityTokenNode();
        ExtensionObject value = ExtensionObject.encode(this.client.getStaticSerializationContext(), userIdentityToken);
        node.setValue(new Variant(value));
    }

    @Override
    public UserIdentityToken readUserIdentityToken() throws UaException {
        try {
            return this.readUserIdentityTokenAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeUserIdentityToken(UserIdentityToken userIdentityToken) throws UaException {
        try {
            this.writeUserIdentityTokenAsync(userIdentityToken).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UserIdentityToken> readUserIdentityTokenAsync() {
        return ((CompletableFuture)this.getUserIdentityTokenNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), UserIdentityToken.class));
    }

    @Override
    public CompletableFuture<StatusCode> writeUserIdentityTokenAsync(UserIdentityToken userIdentityToken) {
        ExtensionObject encoded = ExtensionObject.encode(this.client.getStaticSerializationContext(), userIdentityToken);
        DataValue value = DataValue.valueOnly(new Variant(encoded));
        return this.getUserIdentityTokenNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getUserIdentityTokenNode() throws UaException {
        try {
            return this.getUserIdentityTokenNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getUserIdentityTokenNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "UserIdentityToken", ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public String getSecureChannelId() throws UaException {
        PropertyTypeNode node = this.getSecureChannelIdNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setSecureChannelId(String secureChannelId) throws UaException {
        PropertyTypeNode node = this.getSecureChannelIdNode();
        node.setValue(new Variant(secureChannelId));
    }

    @Override
    public String readSecureChannelId() throws UaException {
        try {
            return this.readSecureChannelIdAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeSecureChannelId(String secureChannelId) throws UaException {
        try {
            this.writeSecureChannelIdAsync(secureChannelId).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String> readSecureChannelIdAsync() {
        return ((CompletableFuture)this.getSecureChannelIdNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeSecureChannelIdAsync(String secureChannelId) {
        DataValue value = DataValue.valueOnly(new Variant(secureChannelId));
        return this.getSecureChannelIdNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getSecureChannelIdNode() throws UaException {
        try {
            return this.getSecureChannelIdNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract(e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getSecureChannelIdNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SecureChannelId", ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }
}

