/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.api.services;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseNextResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowsePath;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseResult;
import org.eclipse.milo.opcua.stack.core.types.structured.RegisterNodesResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.TranslateBrowsePathsToNodeIdsResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.UnregisterNodesResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.ViewDescription;
import org.eclipse.milo.opcua.stack.core.util.ConversionUtil;

public interface ViewServices {
    public CompletableFuture<BrowseResponse> browse(ViewDescription var1, UInteger var2, List<BrowseDescription> var3);

    default public CompletableFuture<BrowseResult> browse(BrowseDescription nodeToBrowse) {
        return this.browse(Lists.newArrayList(nodeToBrowse)).thenApply(rs -> (BrowseResult)rs.get(0));
    }

    default public CompletableFuture<List<BrowseResult>> browse(List<BrowseDescription> nodesToBrowse) {
        return this.browse(new ViewDescription(NodeId.NULL_VALUE, DateTime.MIN_VALUE, Unsigned.uint(0)), Unsigned.uint(0), nodesToBrowse).thenApply(r -> ConversionUtil.l(r.getResults()));
    }

    public CompletableFuture<BrowseNextResponse> browseNext(boolean var1, List<ByteString> var2);

    default public CompletableFuture<BrowseResult> browseNext(boolean releaseContinuationPoint, ByteString continuationPoint) {
        return this.browseNext(releaseContinuationPoint, Lists.newArrayList(continuationPoint)).thenApply(response -> response.getResults()[0]);
    }

    public CompletableFuture<TranslateBrowsePathsToNodeIdsResponse> translateBrowsePaths(List<BrowsePath> var1);

    public CompletableFuture<RegisterNodesResponse> registerNodes(List<NodeId> var1);

    public CompletableFuture<UnregisterNodesResponse> unregisterNodes(List<NodeId> var1);
}

