/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.api.services;

import com.google.common.collect.Streams;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryReadDetails;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryReadResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryReadValueId;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryUpdateDetails;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryUpdateResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadValueId;
import org.eclipse.milo.opcua.stack.core.types.structured.WriteResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.WriteValue;
import org.eclipse.milo.opcua.stack.core.util.ConversionUtil;

public interface AttributeServices {
    public CompletableFuture<ReadResponse> read(double var1, TimestampsToReturn var3, List<ReadValueId> var4);

    default public CompletableFuture<List<DataValue>> read(double maxAge, TimestampsToReturn timestampsToReturn, List<NodeId> nodeIds, List<UInteger> attributeIds) {
        if (nodeIds.size() != attributeIds.size()) {
            CompletableFuture<List<DataValue>> failed = new CompletableFuture<List<DataValue>>();
            failed.completeExceptionally(new IllegalArgumentException("nodeIds.size() != attributeIds.size()"));
            return failed;
        }
        Stream<ReadValueId> stream = Streams.zip(nodeIds.stream(), attributeIds.stream(), (nId, aId) -> new ReadValueId((NodeId)nId, (UInteger)aId, null, QualifiedName.NULL_VALUE));
        return this.read(maxAge, timestampsToReturn, stream.collect(Collectors.toList())).thenApply(r -> ConversionUtil.l(r.getResults()));
    }

    default public CompletableFuture<DataValue> readValue(double maxAge, TimestampsToReturn timestampsToReturn, NodeId nodeId) {
        return this.readValues(maxAge, timestampsToReturn, Collections.singletonList(nodeId)).thenApply(r -> (DataValue)r.get(0));
    }

    default public CompletableFuture<List<DataValue>> readValues(double maxAge, TimestampsToReturn timestampsToReturn, List<NodeId> nodeIds) {
        List<ReadValueId> readValueIds = nodeIds.stream().map(nodeId -> new ReadValueId((NodeId)nodeId, AttributeId.Value.uid(), null, QualifiedName.NULL_VALUE)).collect(Collectors.toList());
        return this.read(maxAge, timestampsToReturn, readValueIds).thenApply(r -> ConversionUtil.l(r.getResults()));
    }

    public CompletableFuture<WriteResponse> write(List<WriteValue> var1);

    default public CompletableFuture<List<StatusCode>> writeValues(List<NodeId> nodeIds, List<DataValue> values) {
        if (nodeIds.size() != values.size()) {
            CompletableFuture<List<StatusCode>> failed = new CompletableFuture<List<StatusCode>>();
            failed.completeExceptionally(new IllegalArgumentException("nodeIds.size() != values.size()"));
            return failed;
        }
        Stream<WriteValue> stream = Streams.zip(nodeIds.stream(), values.stream(), (nodeId, value) -> new WriteValue((NodeId)nodeId, Unsigned.uint(13), null, (DataValue)value));
        return this.write(stream.collect(Collectors.toList())).thenApply(response -> ConversionUtil.l(response.getResults()));
    }

    default public CompletableFuture<StatusCode> writeValue(NodeId nodeId, DataValue value) {
        return this.write(Collections.singletonList(new WriteValue(nodeId, Unsigned.uint(13), null, value))).thenApply(response -> ConversionUtil.l(response.getResults()).get(0));
    }

    public CompletableFuture<HistoryReadResponse> historyRead(HistoryReadDetails var1, TimestampsToReturn var2, boolean var3, List<HistoryReadValueId> var4);

    public CompletableFuture<HistoryUpdateResponse> historyUpdate(List<HistoryUpdateDetails> var1);
}

