/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.api.identity;

import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.milo.opcua.sdk.client.api.identity.IdentityProvider;
import org.eclipse.milo.opcua.sdk.client.api.identity.SignedIdentityToken;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.structured.EndpointDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeProvider
implements IdentityProvider {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ImmutableList<IdentityProvider> providers;

    public CompositeProvider(IdentityProvider ... providers) {
        this(ImmutableList.copyOf(providers));
    }

    public CompositeProvider(List<IdentityProvider> providers) {
        this.providers = ImmutableList.copyOf(providers);
    }

    @Override
    public SignedIdentityToken getIdentityToken(EndpointDescription endpoint, ByteString serverNonce) throws Exception {
        Iterator iterator = this.providers.iterator();
        while (iterator.hasNext()) {
            IdentityProvider provider = (IdentityProvider)iterator.next();
            try {
                return provider.getIdentityToken(endpoint, serverNonce);
            }
            catch (Exception e) {
                if (!iterator.hasNext()) {
                    throw e;
                }
                this.logger.debug("IdentityProvider={} failed, trying next...", (Object)provider.toString());
            }
        }
        throw new Exception("no sufficient UserTokenPolicy found");
    }

    public String toString() {
        return "CompositeProvider{providers=" + this.providers + '}';
    }

    public static CompositeProvider of(IdentityProvider ... providers) {
        return new CompositeProvider(providers);
    }
}

