/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.api.identity;

import java.util.List;
import org.eclipse.milo.opcua.sdk.client.api.identity.IdentityProvider;
import org.eclipse.milo.opcua.sdk.client.api.identity.SignedIdentityToken;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.enumerated.UserTokenType;
import org.eclipse.milo.opcua.stack.core.types.structured.AnonymousIdentityToken;
import org.eclipse.milo.opcua.stack.core.types.structured.EndpointDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.SignatureData;
import org.eclipse.milo.opcua.stack.core.types.structured.UserTokenPolicy;
import org.eclipse.milo.opcua.stack.core.util.ConversionUtil;

public class AnonymousProvider
implements IdentityProvider {
    public static final IdentityProvider INSTANCE = new AnonymousProvider();

    @Override
    public SignedIdentityToken getIdentityToken(EndpointDescription endpoint, ByteString serverNonce) throws Exception {
        List<UserTokenPolicy> userIdentityTokens = ConversionUtil.l(endpoint.getUserIdentityTokens());
        return userIdentityTokens.stream().filter(t -> t.getTokenType() == UserTokenType.Anonymous).findFirst().map(policy -> {
            AnonymousIdentityToken token = new AnonymousIdentityToken(policy.getPolicyId());
            return new SignedIdentityToken(token, new SignatureData(null, null));
        }).orElseThrow(() -> new Exception("no anonymous token policy found"));
    }

    public String toString() {
        return "AnonymousProvider{}";
    }
}

