/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client;

import com.google.common.base.MoreObjects;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.milo.opcua.sdk.client.api.UaSession;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.SignedSoftwareCertificate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpcUaSession
extends ConcurrentHashMap<String, Object>
implements UaSession {
    private volatile ByteString serverNonce = ByteString.NULL_VALUE;
    private final NodeId authToken;
    private final NodeId sessionId;
    private final String sessionName;
    private final double sessionTimeout;
    private final UInteger maxRequestSize;
    private final ByteString serverCertificate;
    private final SignedSoftwareCertificate[] serverSoftwareCertificates;

    public OpcUaSession(NodeId authToken, NodeId sessionId, String sessionName, double sessionTimeout, UInteger maxRequestSize, ByteString serverCertificate, SignedSoftwareCertificate[] serverSoftwareCertificates) {
        this.authToken = authToken;
        this.sessionId = sessionId;
        this.sessionName = sessionName;
        this.sessionTimeout = sessionTimeout;
        this.maxRequestSize = maxRequestSize;
        this.serverCertificate = serverCertificate;
        this.serverSoftwareCertificates = serverSoftwareCertificates;
    }

    @Override
    public NodeId getAuthenticationToken() {
        return this.authToken;
    }

    @Override
    public NodeId getSessionId() {
        return this.sessionId;
    }

    @Override
    public String getSessionName() {
        return this.sessionName;
    }

    @Override
    public Double getSessionTimeout() {
        return this.sessionTimeout;
    }

    @Override
    public UInteger getMaxRequestSize() {
        return this.maxRequestSize;
    }

    @Override
    public SignedSoftwareCertificate[] getServerSoftwareCertificates() {
        return this.serverSoftwareCertificates;
    }

    @Override
    public ByteString getServerCertificate() {
        return this.serverCertificate;
    }

    @Override
    public ByteString getServerNonce() {
        return this.serverNonce;
    }

    public void setServerNonce(ByteString serverNonce) {
        this.serverNonce = serverNonce;
    }

    @Override
    @Nullable
    public Object getAttribute(@NotNull String name) {
        return this.get(name);
    }

    @Override
    @Nullable
    public Object setAttribute(@NotNull String name, @NotNull Object value) {
        return this.put(name, value);
    }

    @Override
    public Object removeAttribute(@NotNull String name) {
        return this.remove(name);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("sessionId", this.sessionId).add("sessionName", this.sessionName).toString();
    }
}

