/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.wireguard;

import com.tas.wp500.fileLogSetting.FileBasedLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class WireGuardService {
    private static final Logger logger = Logger.getLogger(WireGuardService.class);
    private static WireGuardService instanceGuardService;
    private static final String WORKING_DIRECTORY = "/home/wp500/wireguard";
    private static final String configFile = "/etc/wireguard/wg0.conf";
    private String privateKey;
    private String publicKey;

    private WireGuardService() {
        this.readKeys();
    }

    public static WireGuardService getWireguardInstance() {
        if (instanceGuardService == null) {
            instanceGuardService = new WireGuardService();
        }
        return instanceGuardService;
    }

    private void generatePrivateKey() {
        this.executeCommand("wg genkey > private.txt", "Generate private key");
    }

    private void readKeys() {
        this.createDirectory(WORKING_DIRECTORY);
        this.privateKey = this.readFile("/home/wp500/wireguard/private.txt");
        this.publicKey = this.readFile("/home/wp500/wireguard/publickey.txt");
        if (this.privateKey == null || this.publicKey == null) {
            this.generateKeys();
        }
    }

    public JSONObject genrateKeys() {
        JSONObject resultObject = null;
        try {
            this.generateKeys();
            resultObject = this.getPrivateAndPublicKeys("wp500");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error occurred while genrating new keys : " + e);
            FileBasedLogger.error("Application", "Error occurred while genrating new keys : " + e, "system");
        }
        return resultObject;
    }

    private void generateKeys() {
        this.generatePrivateKey();
        String privateKey = this.readFile("/home/wp500/wireguard/private.txt");
        this.generatePublicKey(privateKey);
    }

    private void generatePublicKey(String privateKey) {
        this.executeCommand("bash -c 'echo " + privateKey + " | wg pubkey > publickey.txt'", "Generate public key");
    }

    private void executeCommand(String command, String action) {
        try {
            ProcessBuilder processBuilder = new ProcessBuilder("bash", "-c", command);
            processBuilder.directory(new File(WORKING_DIRECTORY));
            Process process = processBuilder.start();
            int exitCode = process.waitFor();
            if (exitCode == 0) {
                logger.debug(action + " command executed successfully.");
            } else {
                logger.debug(action + " command failed with exit code : " + exitCode);
            }
        }
        catch (IOException | InterruptedException e) {
            FileBasedLogger.error("Application", "Error while " + action.toLowerCase() + ": " + e.getMessage(), "system");
            logger.error("Error while " + action.toLowerCase() + ": " + e.getMessage());
        }
    }

    private void createDirectory(String directoryPath) {
        Path path = Paths.get(directoryPath, new String[0]);
        if (Files.notExists(path, new LinkOption[0])) {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
                logger.debug("Directory created : " + directoryPath);
            }
            catch (IOException e) {
                FileBasedLogger.error("Application", "Failed to create directory : " + directoryPath, "system");
                logger.error("Failed to create directory : " + directoryPath);
            }
        }
    }

    private String readFile(String filePath) {
        try {
            String content = new String(Files.readAllBytes(Paths.get(filePath, new String[0])));
            return content.replace("\n", "").replace("\r", "");
        }
        catch (IOException e) {
            logger.error("Error while reading file : " + e.getMessage());
            FileBasedLogger.error("Application", "Error while reading file : " + e.getMessage(), "system");
            return null;
        }
    }

    public JSONObject getPrivateAndPublicKeys(String user) {
        JSONObject resultObject = new JSONObject();
        try {
            this.privateKey = this.readFile("/home/wp500/wireguard/private.txt");
            this.publicKey = this.readFile("/home/wp500/wireguard/publickey.txt");
            if (this.publicKey != null && this.privateKey != null) {
                resultObject.put("private_key", this.privateKey);
                resultObject.put("public_key", this.publicKey);
                resultObject.put("status", "success");
                resultObject.put("msg", "Successfully read the keys files.");
                logger.debug("Read the keys files successsfully.");
            } else {
                resultObject.put("status", "fail");
                resultObject.put("msg", "Error generating WireGuard keys");
                logger.debug("Generating an error for wireguard keys.");
            }
        }
        catch (Exception e) {
            logger.error(" Error while reading private and public keys from file : " + e.getMessage());
            FileBasedLogger.error("Application", " Error while reading private and public keys from file : " + e.getMessage(), user);
        }
        return resultObject;
    }

    private String readFromFile(String fileName) {
        String string;
        BufferedReader reader = new BufferedReader(new InputStreamReader(WireGuardService.class.getResourceAsStream("/" + fileName)));
        try {
            string = reader.readLine();
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        reader.close();
        return string;
    }

    public JSONObject activateWireGuard1(String user) {
        JSONObject resultObject = new JSONObject();
        try {
            if (this.isWireGuardServiceRunning()) {
                this.deactivateWireGuard();
            }
            String[] command = new String[]{"wg-quick", "up", configFile};
            ProcessBuilder processBuilder = new ProcessBuilder(command);
            processBuilder.redirectErrorStream(true);
            Process process = processBuilder.start();
            int exitCode = process.waitFor();
            JSONArray printOutput = this.printOutput(process);
            if (exitCode == 0) {
                logger.info("WireGuard Activated successfully.");
                FileBasedLogger.info("Audit", "WireGuard Activated successfully.", user);
                resultObject.put("status", "success");
                resultObject.put("msg", "Successfully activate WireGuard service.");
                resultObject.put("result", printOutput);
            } else {
                logger.info("Failed  while activating WireGuard service.");
                FileBasedLogger.info("Audit", "Failed  while activating WireGuard service.", user);
                resultObject.put("status", "fail");
                resultObject.put("msg", "Failed to activate WireGuard service.");
                resultObject.put("result", printOutput);
            }
        }
        catch (Exception e) {
            FileBasedLogger.error("Audit", "Error occurred while activting wireguad :" + e.getMessage(), user);
            logger.error("Error occurred while activting wireguad :" + e.getMessage());
            e.printStackTrace();
        }
        return resultObject;
    }

    public JSONObject activateWireGuard(String user) {
        JSONObject resultObject = new JSONObject();
        try {
            String configFile = configFile;
            if (this.isWireGuardServiceRunning()) {
                this.deactivateWireGuard();
            }
            String[] command = new String[]{"wg-quick", "up", configFile};
            ProcessBuilder processBuilder = new ProcessBuilder(command);
            processBuilder.redirectErrorStream(true);
            Process process = processBuilder.start();
            int exitCode = process.waitFor();
            JSONArray printOutput = this.printOutput(process);
            if (printOutput.toString().contains("Unknown device type") && this.loadWireGuardModule()) {
                logger.debug("Detected missing WireGuard kernel module. Attempting to load it.");
                process = processBuilder.start();
                exitCode = process.waitFor();
                printOutput = this.printOutput(process);
            }
            if (exitCode == 0) {
                logger.info("WireGuard Activated successfully.");
                FileBasedLogger.info("Audit", "WireGuard Activated successfully.", user);
                resultObject.put("status", "success");
                resultObject.put("msg", "Successfully activated WireGuard service.");
                resultObject.put("result", printOutput);
            } else {
                logger.info("Failed while activating WireGuard service.");
                FileBasedLogger.info("Audit", "Failed while activating WireGuard service.", user);
                resultObject.put("status", "fail");
                resultObject.put("msg", "Failed to activate WireGuard service.");
                resultObject.put("result", printOutput);
            }
        }
        catch (Exception e) {
            logger.error("Error occurred while activating WireGuard: " + e.getMessage());
            FileBasedLogger.error("Audit", "Error occurred while activating WireGuard: " + e.getMessage(), user);
            e.printStackTrace();
        }
        return resultObject;
    }

    private boolean loadWireGuardModule() {
        try {
            String[] command = new String[]{"modprobe", "wireguard"};
            ProcessBuilder processBuilder = new ProcessBuilder(command);
            processBuilder.redirectErrorStream(true);
            Process process = processBuilder.start();
            int exitCode = process.waitFor();
            return exitCode == 0;
        }
        catch (Exception e) {
            logger.error("Error occurred while loading WireGuard kernel module: " + e.getMessage());
            FileBasedLogger.error("Application", "Error occurred while loading WireGuard kernel module: " + e.getMessage(), "system");
            e.printStackTrace();
            return false;
        }
    }

    private JSONArray printOutput(Process process) throws IOException {
        JSONArray resultArray = new JSONArray();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                logger.debug(line);
                resultArray.put(line);
            }
        }
        return resultArray;
    }

    public JSONObject deActivateWireGuard(String user) {
        JSONObject resultObject = new JSONObject();
        try {
            String[] command = new String[]{"wg-quick", "down", configFile};
            ProcessBuilder processBuilder = new ProcessBuilder(command);
            processBuilder.redirectErrorStream(true);
            Process process = processBuilder.start();
            int exitCode = process.waitFor();
            JSONArray printOutput = this.printOutput(process);
            if (exitCode == 0) {
                logger.info("WireGuard deactivated successfully.");
                FileBasedLogger.info("Application", "WireGuard deactivated successfully.", user);
                resultObject.put("status", "success");
                resultObject.put("msg", "Successfully deactivate WireGuard service.");
                resultObject.put("result", printOutput);
            } else {
                resultObject.put("status", "fail");
                resultObject.put("msg", "Failed to  deactivate WireGuard service.");
                resultObject.put("result", printOutput);
                logger.info("Failed to deactivating WireGuard.");
                FileBasedLogger.info("Application", "Failed to deactivating WireGuard.", user);
            }
        }
        catch (Exception e) {
            logger.error(" Error occurred while deactivting wireguad : " + e.getMessage());
            FileBasedLogger.error("Audit", " Error occurred while deactivting wireguad : " + e.getMessage(), user);
            e.printStackTrace();
        }
        return resultObject;
    }

    private boolean isWireGuardServiceRunning() throws IOException, InterruptedException {
        String[] checkCommand = new String[]{"wg", "show", configFile};
        ProcessBuilder checkProcessBuilder = new ProcessBuilder(checkCommand);
        checkProcessBuilder.redirectErrorStream(true);
        Process checkProcess = checkProcessBuilder.start();
        int exitCode = checkProcess.waitFor();
        return exitCode == 0;
    }

    private void deactivateWireGuard() throws IOException, InterruptedException {
        String[] deactivateCommand = new String[]{"wg-quick", "down", configFile};
        ProcessBuilder deactivateProcessBuilder = new ProcessBuilder(deactivateCommand);
        deactivateProcessBuilder.redirectErrorStream(true);
        Process deactivateProcess = deactivateProcessBuilder.start();
        int exitCode = deactivateProcess.waitFor();
        this.printOutput(deactivateProcess);
        if (exitCode == 0) {
            logger.info("WireGuard deactivated successfully.");
            FileBasedLogger.info("Application", "WireGuard deactivated successfully.", "system");
        } else {
            logger.error("Error deactivating WireGuard. Exit code: " + exitCode);
            FileBasedLogger.error("Application", "Error deactivating WireGuard. Exit code: " + exitCode, "system");
        }
    }

    public JSONObject getWireGuardInfo(String user) throws JSONException {
        JSONObject resultObject = new JSONObject();
        try {
            ProcessBuilder processBuilder = new ProcessBuilder("wg");
            Process process = processBuilder.start();
            int exitCode = process.waitFor();
            if (exitCode == 0) {
                logger.info("WireGuard information retrieved successfully.");
                FileBasedLogger.info("Audit", "WireGuard information retrieved successfully.", user);
                JSONArray wireGuardInfoArray = this.readWireGuardInfo(process);
                resultObject.put("wireguard_info", wireGuardInfoArray);
                resultObject.put("status", "success");
                resultObject.put("msg", "Successfully retrieved WireGuard information.");
            } else {
                resultObject.put("status", "fail");
                resultObject.put("msg", "Error retrieving WireGuard information. ");
                logger.info("Error retrieving WireGuard information.");
                FileBasedLogger.info("Audit", "Error retrieving WireGuard information.", user);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            resultObject.put("status", "fail");
            resultObject.put("msg", "Error while retrieving WireGuard information : " + e.getMessage());
            logger.error(" Error occurred while retrieving wireguard information : " + e);
            FileBasedLogger.error("Audit", " Error occurred while retrieving wireguard information : " + e, user);
        }
        return resultObject;
    }

    private JSONArray readWireGuardInfo(Process process) throws IOException {
        JSONArray wireGuardInfoArray = new JSONArray();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                wireGuardInfoArray.put(line);
            }
        }
        return wireGuardInfoArray;
    }

    private void parseAndAddToJsonObject(String line, JSONObject jsonObject) {
        String[] parts = line.split(":");
        if (parts.length == 2) {
            String key = parts[0].trim();
            String value = parts[1].trim();
            try {
                jsonObject.put(key, value);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    public JSONObject readWG0File(String user) throws JSONException {
        JSONObject resultObject = new JSONObject();
        JSONArray linesBetweenHashes = null;
        try {
            linesBetweenHashes = new JSONArray();
            try (BufferedReader reader = new BufferedReader(new FileReader(configFile));){
                String line;
                while ((line = reader.readLine()) != null) {
                    linesBetweenHashes.put(line);
                }
                resultObject.put("data", linesBetweenHashes);
                resultObject.put("status", "success");
                resultObject.put("msg", "Successfully read text from wireguard file ");
                logger.info("Successfully read text from wireguard file.");
                FileBasedLogger.info("Audit", "Successfully read text from wireguard file.", user);
            }
        }
        catch (Exception e) {
            resultObject.put("status", "fail");
            resultObject.put("msg", "Failed to read text from wireguard file. ");
            e.printStackTrace();
            logger.error(" Error occurred while reading wireguard file : " + e.getMessage());
            FileBasedLogger.error("Audit", " Error occurred while reading wireguard file : " + e.getMessage(), user);
        }
        return resultObject;
    }

    public JSONObject writeBackUpdatedLinesInWG0Files(JSONObject json, String user) throws JSONException {
        JSONObject resultObject = new JSONObject();
        ArrayList<String> modifiedLines = new ArrayList<String>();
        try {
            if (json.has("data")) {
                JSONArray dataArray = json.getJSONArray("data");
                for (int i = 0; i < dataArray.length(); ++i) {
                    String value = dataArray.getString(i);
                    modifiedLines.add(value);
                }
                this.writeLinesToFile(modifiedLines);
                resultObject.put("status", "success");
                resultObject.put("msg", "Successfully update text in wireguard file. ");
                logger.info("Successfully updated text in wireguard file.");
                FileBasedLogger.info("Audit", "Successfully updated text in wireguard file.", user);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            resultObject.put("status", "fail");
            resultObject.put("msg", "Failed to update text in wireguard file. ");
            logger.error("Error occurred while updating wireguard file : " + e);
            FileBasedLogger.error("Audit", "Error occurred while updating wireguard file : " + e, user);
        }
        return resultObject;
    }

    private void writeLinesToFile(List<String> modifiedLines) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(configFile));){
            for (String line : modifiedLines) {
                writer.write(line);
                writer.newLine();
            }
        }
    }
}

