/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.webSocket;

import com.tas.wp500.protocol.startan.Tag;
import com.tas.wp500.services.Service;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class WebSocketMessageProcessor
implements Runnable {
    private static final BlockingQueue<String> messageQueue = new LinkedBlockingQueue<String>();
    private static final Logger logger = Logger.getLogger(WebSocketMessageProcessor.class);
    private static final int THREAD_POOL_SIZE = 25;
    private final ExecutorService liveExecutor = Executors.newFixedThreadPool(25);

    public static void addMessage(String message) {
        if (message != null) {
            messageQueue.offer(message);
        } else {
            logger.warn("Attempted to add null message to the queue.");
        }
    }

    @Override
    public void run() {
        try {
            try {
                while (true) {
                    String message = messageQueue.take();
                    this.liveExecutor.execute(() -> this.processMessage(message));
                }
            }
            catch (InterruptedException e) {
                logger.error("Message processing thread interrupted", e);
                Thread.currentThread().interrupt();
                this.shutdownExecutor();
            }
        }
        catch (Throwable throwable) {
            this.shutdownExecutor();
            throw throwable;
        }
    }

    private void processMessage(String message) {
        try {
            if (message == null || message.contains("rtstatus2")) {
                return;
            }
            JSONObject response = new JSONObject(message);
            if (this.isValidResponse(response)) {
                JSONArray dataArray = response.getJSONArray("data");
                this.processTags(dataArray);
            } else {
                logger.error("Invalid response format: Missing 'error' or 'ok' field.");
            }
        }
        catch (JSONException e) {
            logger.error("Error processing message: " + message, e);
        }
    }

    private boolean isValidResponse(JSONObject response) {
        return response.has("error") && response.getInt("error") == 200 || response.has("ok") && "ok".equals(response.getString("ok"));
    }

    private void processTags(JSONArray dataArray) {
        try {
            for (int i = 0; i < dataArray.length(); ++i) {
                try {
                    JSONObject jsonObject = dataArray.getJSONObject(i);
                    if (!this.isValidTag(jsonObject)) continue;
                    String name = jsonObject.getString("name");
                    String value = jsonObject.getString("value");
                    int access = jsonObject.getInt("access");
                    int error = jsonObject.getInt("error");
                    int extError = jsonObject.getInt("extError");
                    Tag tag = new Tag(name, value, access, error, extError);
                    Service.variableTagMap.put(name.split("\\.")[1], tag);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.error("Error while creating JSON object array : " + e);
                }
            }
        }
        catch (Exception e) {
            logger.error("Error parsing JSON object in data array: " + e.getMessage(), e);
        }
    }

    private boolean isValidTag(JSONObject jsonObject) {
        return jsonObject.has("name") && jsonObject.has("value") && jsonObject.has("access") && jsonObject.has("error") && jsonObject.has("extError");
    }

    private void shutdownExecutor() {
        this.liveExecutor.shutdown();
        logger.info("Executor service shut down.");
    }
}

