/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.webSocket;

import com.tas.wp500.fileLogSetting.FileBasedLogger;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.websocket.ClientEndpoint;
import javax.websocket.CloseReason;
import javax.websocket.ContainerProvider;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import org.apache.log4j.Logger;
import org.json.JSONObject;

@ClientEndpoint(subprotocols={"straton-protocol"})
public class WebSocketClient {
    private static final Logger logger = Logger.getLogger(WebSocketClient.class);
    private CountDownLatch responseLatch;
    private final long timeoutMillis = 120000L;
    private final List<String> messages = new CopyOnWriteArrayList<String>();

    @OnOpen
    public void onOpen(Session session) {
        logger.debug("Connected to the server");
    }

    @OnMessage
    public void onMessage(String message, Session session) {
        this.messages.add(message);
        this.responseLatch.countDown();
    }

    @OnMessage
    public void onMessage(ByteBuffer message, Session session) {
        logger.debug("Received ByteBuffer: " + message);
        byte[] bytes = new byte[message.remaining()];
        message.get(bytes);
        logger.debug("Raw bytes: " + Arrays.toString(bytes));
    }

    @OnClose
    public void onClose(Session session, CloseReason closeReason) {
        logger.debug("Connection closed: " + closeReason);
    }

    @OnError
    public void onError(Session session, Throwable throwable) {
        logger.error("An error occurred: " + throwable.getMessage(), throwable);
    }

    public boolean waitForResponse() throws InterruptedException {
        boolean responseReceived = this.responseLatch.await(120000L, TimeUnit.MILLISECONDS);
        if (!responseReceived) {
            logger.debug("Timeout: No response received within 120 seconds.");
        } else {
            logger.debug("Response received within timeout.");
        }
        return responseReceived;
    }

    public List<String> getMessages() {
        return new ArrayList<String>(this.messages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendJsonAndGetResponse(String uri, String json) {
        WebSocketContainer container = ContainerProvider.getWebSocketContainer();
        WebSocketClient client = new WebSocketClient();
        Session session = null;
        try {
            session = container.connectToServer(client, URI.create(uri));
            logger.debug("WebSocket connection established.");
            client.responseLatch = new CountDownLatch(1);
            client.messages.clear();
            logger.debug("Sending: " + json);
            session.getAsyncRemote().sendText(json);
            boolean responseReceived = client.waitForResponse();
            if (!responseReceived) {
                logger.debug("No response received.");
            }
            logger.debug("Length of received messages: " + client.messages.size());
            for (String message : client.messages) {
                JSONObject responseJson = new JSONObject(message);
                if (!responseJson.has("data")) continue;
                String string = message;
                return string;
            }
        }
        catch (Exception e) {
            logger.error("Error while sending message to WebSocket: ", e);
            FileBasedLogger.error("Application", "Error while sending message to WebSocket: " + e, "system");
        }
        finally {
            if (session != null && session.isOpen()) {
                try {
                    session.close();
                }
                catch (IOException e) {
                    logger.error("Error while closing WebSocket session: ", e);
                    FileBasedLogger.error("Application", "Error while closing WebSocket session: " + e, "system");
                }
            }
        }
        return null;
    }
}

