/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.webSocket;

import com.tas.wp500.fileLogSetting.FileBasedLogger;
import com.tas.wp500.services.Service;
import com.tas.wp500.webSocket.WebSocketClient;
import com.tas.wp500.webSocket.WebSocketMessageProcessor;
import java.util.List;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FcgiCommand {
    private static Logger logger = Logger.getLogger(FcgiCommand.class);
    String listCommand = "{\"cmd\":\"list2\"}";
    private static FcgiCommand instance = null;

    private FcgiCommand() {
    }

    public static FcgiCommand getInstance() {
        if (instance == null) {
            instance = new FcgiCommand();
        }
        return instance;
    }

    public JSONObject executeFCGIgetListCommand() {
        JSONObject resultObj = new JSONObject();
        try {
            String response = WebSocketClient.sendJsonAndGetResponse(Service.webSocketUrl, this.listCommand);
            if (response != null) {
                JSONObject responseJson = new JSONObject(response);
                if (responseJson.getInt("error") == 200) {
                    if (responseJson.has("data")) {
                        JSONArray dataList = responseJson.getJSONArray("data");
                        JSONArray jsonArrayBuilder = new JSONArray();
                        for (int i = 0; i < dataList.length(); ++i) {
                            String tagName = dataList.getString(i);
                            jsonArrayBuilder.put(tagName);
                        }
                        resultObj.put("status", "Success");
                        resultObj.put("result", jsonArrayBuilder);
                    }
                } else {
                    resultObj.put("status", "Fail");
                    resultObj.put("error", responseJson.getString("errorTxt"));
                }
            } else {
                resultObj.put("status", "Fail");
                resultObj.put("error", "No response from WebSocket server");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error occurred while fetching tag list from WebSocket: " + e);
            FileBasedLogger.error("Application", "Error occurred while fetching tag list from WebSocket: " + e, "system");
            try {
                resultObj.put("status", "Fail");
                resultObj.put("error", e.getMessage());
            }
            catch (JSONException jsonException) {
                jsonException.printStackTrace();
            }
        }
        return resultObj;
    }

    public JSONObject readMultiplevariableUsingFCGICommand(String commandString) {
        JSONObject resultObj = new JSONObject();
        try {
            String response = WebSocketClient.sendJsonAndGetResponse(Service.webSocketUrl, commandString);
            if (response != null) {
                JSONObject responseJson = new JSONObject(response);
                if (responseJson.getInt("error") == 200 || responseJson.get("ok").equals("ok")) {
                    if (responseJson.has("data")) {
                        WebSocketMessageProcessor.addMessage(response);
                        resultObj.put("status", "success");
                    } else {
                        resultObj.put("status", "Fail");
                    }
                } else {
                    resultObj.put("status", "Fail");
                    resultObj.put("error", responseJson.getString("errorTxt"));
                }
            } else {
                resultObj.put("status", "Fail");
                resultObj.put("error", "No response from WebSocket server");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error occurred while fetching tag list from WebSocket: " + e);
            FileBasedLogger.error("Application", "Error occurred while fetching tag list from WebSocket: " + e, "system");
            try {
                resultObj.put("status", "Fail");
                resultObj.put("error", e.getMessage());
            }
            catch (JSONException jsonException) {
                jsonException.printStackTrace();
            }
        }
        return resultObj;
    }

    public JSONObject buildReadCommandFromList(List<String> list) {
        JSONObject commandObj = new JSONObject();
        try {
            commandObj.put("cmd", "read2");
            JSONArray dataArray = new JSONArray();
            for (String element : list) {
                JSONObject obj = new JSONObject();
                obj.put("name", "app." + element);
                dataArray.put(obj);
            }
            commandObj.put("data", dataArray);
        }
        catch (JSONException e) {
            e.printStackTrace();
            logger.error("Error occurred while building read command: " + e);
            FileBasedLogger.error("Application", "Error occurred while building read command: " + e, "system");
        }
        return commandObj;
    }
}

