/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.util;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.log4j.Logger;

public class Util {
    private static Logger logger = Logger.getLogger(Util.class);

    public static String convertISTToUTC() {
        String inputDateTimeString = Util.getISTTime();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd-MM-yyyy HH:mm:ss");
        LocalDateTime localDateTime = LocalDateTime.parse(inputDateTimeString, formatter);
        ZoneId sourceZone = ZoneId.of("Asia/Kolkata");
        ZoneId targetZone = ZoneId.of("UTC");
        ZonedDateTime sourceZonedDateTime = localDateTime.atZone(sourceZone);
        ZonedDateTime targetZonedDateTime = sourceZonedDateTime.withZoneSameInstant(targetZone);
        DateTimeFormatter outputFormatter = DateTimeFormatter.ofPattern("dd-MM-yyyy HH:mm:ss");
        String istDateTimeString = targetZonedDateTime.format(outputFormatter);
        return istDateTimeString;
    }

    public static LocalDateTime getCurrentISTDateTime() {
        ZoneId istZone = ZoneId.of("Asia/Kolkata");
        ZonedDateTime currentISTZonedDateTime = ZonedDateTime.now(istZone);
        return currentISTZonedDateTime.toLocalDateTime();
    }

    public static String getISTTime() {
        LocalDateTime currentDateTime = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd-MM-yyyy HH:mm:ss");
        String formattedDateTime = currentDateTime.format(formatter);
        return formattedDateTime;
    }

    public static String checkISToUTC(String currentPublishingTimeZone) {
        String currentTime = null;
        try {
            if (currentPublishingTimeZone.equalsIgnoreCase("IST")) {
                currentTime = Util.getISTTime();
            } else if (currentPublishingTimeZone.equalsIgnoreCase("UTC")) {
                currentTime = Util.convertISTToUTC();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            currentTime = "";
            logger.error("Error while set time for publishing : " + e.getLocalizedMessage());
        }
        return currentTime;
    }
}

