/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.util;

import com.tas.wp500.fileLogSetting.FileBasedLogger;
import com.tas.wp500.protocol.startan.Tag;
import com.tas.wp500.services.Service;
import com.tas.wp500.util.Util;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Set;
import java.util.function.BiConsumer;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LiveDataOperations {
    private static Logger logger = Logger.getLogger(LiveDataOperations.class);
    private static LiveDataOperations instance = null;

    private LiveDataOperations() {
    }

    public static LiveDataOperations getInstance() {
        if (instance == null) {
            instance = new LiveDataOperations();
        }
        return instance;
    }

    public JSONObject getLivedata(JSONObject json) throws JSONException {
        JSONObject resultObj = new JSONObject();
        try {
            final JSONArray finalSendArray = new JSONArray();
            Service.variableTagMap.forEach(new BiConsumer<String, Tag>(){
                JSONObject eachJSon = new JSONObject();

                @Override
                public void accept(String ver_name, Tag tag) {
                    try {
                        JSONObject eachJSon = new JSONObject();
                        eachJSon.put("tag_name", ver_name);
                        eachJSon.put("value", tag.getValue());
                        eachJSon.put("access", tag.getAccess());
                        eachJSon.put("error", tag.getError());
                        eachJSon.put("extError", tag.getExtError());
                        finalSendArray.put(eachJSon);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            resultObj.put("result", finalSendArray);
            resultObj.put("status", "success");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(" Error occurred while geting live data : " + e);
            FileBasedLogger.error("Application", " Error occurred while geting live data : " + e, "system");
            resultObj.put("status", "fail");
        }
        return resultObj;
    }

    public JSONObject getOnlyVariableList(JSONObject json) throws JSONException {
        JSONObject resultObj = new JSONObject();
        try {
            Set keySet = Service.variableTagMap.keySet();
            resultObj.put("result", keySet);
            resultObj.put("status", "success");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(" Error occurred while retrieving the variable list : " + e);
            FileBasedLogger.error("Application", " Error occurred while retrieving the variable list : " + e, "system");
            resultObj.put("status", "fail");
        }
        return resultObj;
    }

    public JSONObject getliveDateTimeLinux(JSONObject json) {
        try {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd-MM-yyyy HH:mm:ss");
            LocalDateTime now = LocalDateTime.now();
            json.put("system_time", now.format(formatter));
            json.put("IST_Time", Util.getISTTime());
            json.put("UTC_Time", Util.convertISTToUTC());
        }
        catch (Exception e) {
            logger.error("Error occurred while retrieving the system time : " + e);
        }
        return json;
    }

    public JSONObject rebootSystem(final String user) throws JSONException {
        final JSONObject json = new JSONObject();
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(10000L);
                    Process process = Runtime.getRuntime().exec("reboot");
                    int exitStatus = process.waitFor();
                    if (exitStatus == 0) {
                        logger.info("Rebooting the system.");
                        FileBasedLogger.info("Audit", "Rebooting the system.", user);
                    } else {
                        logger.error("Failed to reboot the system.");
                        FileBasedLogger.error("Audit", "Failed to reboot the system.", user);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.error("Error occurred while rebooting the system." + e.getMessage());
                    FileBasedLogger.error("Application", "Error occurred while rebooting the system." + e.getMessage(), user);
                    try {
                        json.put("status", "error");
                        json.put("msg", "Error occurred while rebooting the system.");
                    }
                    catch (JSONException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        }).start();
        try {
            json.put("status", "success");
            json.put("msg", "System is Rebooting. Please wait !!!");
        }
        catch (JSONException e) {
            logger.error("Error occurred while rebooting the system." + e.getMessage());
            FileBasedLogger.error("Application", "Error occurred while rebooting the system." + e.getMessage(), user);
            json.put("status", "fail");
            json.put("msg", "Failed to reboot the system.");
        }
        return json;
    }
}

