/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.util;

import com.tas.wp500.util.ConfigClass;
import org.apache.log4j.Logger;

public class ConfigUtils {
    private static final Logger logger = Logger.getLogger(ConfigUtils.class);
    private static ConfigClass configInstance = ConfigClass.getInstance();
    private static final int DEFAULT_INTERVAL = 5;

    public static int getStratonInterval() {
        String stratonInterval = configInstance.readConfigName("straton_interval");
        try {
            int interval = Integer.parseInt(stratonInterval);
            if (interval > 0) {
                return interval;
            }
            logger.warn("Straton interval value is invalid (<= 0). Using default value: 5");
        }
        catch (NumberFormatException e) {
            logger.warn("Straton interval value is not a valid integer. Using default value: 5", e);
        }
        catch (Exception e) {
            logger.error("Unexpected error while reading Straton interval. Using default value: 5", e);
        }
        return 5;
    }
}

